/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileArrayState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.List;

public class DigestAndPercentileArrayStateSerializer
implements AccumulatorStateSerializer<DigestAndPercentileArrayState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(DigestAndPercentileArrayState state, BlockBuilder out) {
        if (state.getDigest() == null) {
            out.appendNull();
        } else {
            Slice digest = state.getDigest().serialize();
            SliceOutput output = Slices.allocate((int)(4 + state.getPercentiles().size() * 8 + 4 + digest.length())).getOutput();
            List<Double> percentiles = state.getPercentiles();
            output.appendInt(percentiles.size());
            for (double percentile : percentiles) {
                output.appendDouble(percentile);
            }
            output.appendInt(digest.length());
            output.appendBytes(digest);
            VarbinaryType.VARBINARY.writeSlice(out, output.slice());
        }
    }

    public void deserialize(Block block, int index, DigestAndPercentileArrayState state) {
        BasicSliceInput input = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
        int numPercentiles = input.readInt();
        ImmutableList.Builder percentilesListBuilder = ImmutableList.builder();
        for (int i = 0; i < numPercentiles; ++i) {
            percentilesListBuilder.add((Object)input.readDouble());
        }
        state.setPercentiles((List<Double>)percentilesListBuilder.build());
        int length = input.readInt();
        state.setDigest(new QuantileDigest(input.readSlice(length)));
        state.addMemoryUsage(state.getDigest().estimatedInMemorySizeInBytes());
    }
}

