/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.sketch.kll;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.sketch.kll.KllSketchAggregationState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.memory.Memory;

public class KllSketchStateSerializer
implements AccumulatorStateSerializer<KllSketchAggregationState> {
    private final Type type;

    public KllSketchStateSerializer(@TypeParameter(value="T") Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(KllSketchAggregationState state, BlockBuilder out) {
        if (state.getSketch() == null) {
            out.appendNull();
            return;
        }
        VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedBuffer((byte[])state.getSketch().toByteArray()));
    }

    public void deserialize(Block block, int index, KllSketchAggregationState state) {
        if (block.isNull(index)) {
            state.setSketch(null);
            return;
        }
        Memory memory = Memory.wrap((ByteBuffer)VarbinaryType.VARBINARY.getSlice(block, index).toByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        KllSketchAggregationState.SketchParameters<?> parameters = KllSketchAggregationState.getSketchParameters(this.type);
        KllItemsSketch sketch = KllItemsSketch.heapify((Memory)memory, parameters.getComparator(), parameters.getSerde());
        state.addMemoryUsage(-KllSketchAggregationState.getEstimatedKllInMemorySize(state.getSketch(), this.type.getJavaType()));
        state.setSketch(sketch);
        state.addMemoryUsage(KllSketchAggregationState.getEstimatedKllInMemorySize(state.getSketch(), this.type.getJavaType()));
    }
}

