/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.reservoirsample;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.NullablePosition;
import com.facebook.presto.operator.aggregation.reservoirsample.ReservoirSample;
import com.facebook.presto.operator.aggregation.reservoirsample.ReservoirSampleState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.google.common.base.Preconditions;
import java.util.Optional;

@AggregationFunction(value="reservoir_sample", isCalledOnNullInput=true)
@Description(value="Generates a fixed-size bernoulli sample from the input column. Will merge an existing sample into the newly-generated sample.")
public class ReservoirSampleFunction {
    public static final String NAME = "reservoir_sample";

    private ReservoirSampleFunction() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@TypeParameter(value="T") Type type, @AggregationState ReservoirSampleState state, @BlockPosition @SqlType(value="array(T)") @NullablePosition Block initialState, @BlockIndex int initialStatePos, @SqlType(value="bigint") long initialProcessedCount, @BlockPosition @SqlType(value="T") @NullablePosition Block value, @BlockIndex int position, @SqlType(value="integer") long desiredSampleSize) {
        Preconditions.checkArgument((desiredSampleSize > 0L ? 1 : 0) != 0, (Object)"desired sample size must be > 0");
        if (initialProcessedCount <= 0L) {
            Preconditions.checkArgument((initialState.isNull(initialStatePos) || initialState.getBlock(initialStatePos).getPositionCount() == 0 ? 1 : 0) != 0, (Object)"initial state array must be null or empty when initial processed count is <= 0");
        }
        if (state.get() == null) {
            state.set(new ReservoirSample(type));
        }
        ReservoirSample sample = state.get();
        sample.tryInitialize((int)desiredSampleSize);
        Block initialStateBlock = null;
        if (initialProcessedCount > 0L) {
            initialStateBlock = initialState.getBlock(initialStatePos);
        }
        sample.initializeInitialSample(initialStateBlock, initialProcessedCount);
        sample.add(value, position);
    }

    @CombineFunction
    public static void combine(@AggregationState ReservoirSampleState state, @AggregationState ReservoirSampleState otherState) {
        if (state.get() == null) {
            state.set(otherState.get());
            return;
        }
        state.get().mergeWith(otherState.get());
    }

    @OutputFunction(value="row(processed_count bigint, sample array(T))")
    public static void output(@TypeParameter(value="T") Type elementType, @AggregationState ReservoirSampleState state, BlockBuilder out) {
        ReservoirSample reservoirSample = state.get();
        Block initialSampleBlock = Optional.ofNullable(reservoirSample.getInitialSample()).orElseGet(() -> RunLengthEncodedBlock.create((Type)elementType, null, (int)0));
        long initialProcessedCount = reservoirSample.getInitialProcessedCount();
        Preconditions.checkArgument((initialProcessedCount == -1L || initialProcessedCount == (long)initialSampleBlock.getPositionCount() || reservoirSample.getMaxSampleSize() == initialSampleBlock.getPositionCount() ? 1 : 0) != 0, (Object)"when a positive initial_processed_count is provided the size of the initial sample must be equal to desired_sample_size parameter");
        ReservoirSample finalSample = new ReservoirSample(elementType, Math.max(initialProcessedCount, 0L), reservoirSample.getMaxSampleSize(), initialSampleBlock, null, 0L);
        finalSample.merge(reservoirSample);
        long count = finalSample.getProcessedCount();
        BlockBuilder entryBuilder = out.beginBlockEntry();
        BigintType.BIGINT.writeLong(entryBuilder, count);
        BlockBuilder sampleBlock = finalSample.getSampleBlockBuilder();
        reservoirSample.getArrayType().appendTo(sampleBlock.build(), 0, entryBuilder);
        out.closeEntry();
    }
}

