/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.FixedHistogramJacknifeStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.FixedHistogramMleStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.UnweightedReservoirSampleStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.WeightedReservoirSampleStateStrategy;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public interface DifferentialEntropyStateStrategy
extends Cloneable {
    @VisibleForTesting
    public static final String FIXED_HISTOGRAM_MLE_METHOD_NAME = "fixed_histogram_mle";
    @VisibleForTesting
    public static final String FIXED_HISTOGRAM_JACKNIFE_METHOD_NAME = "fixed_histogram_jacknife";

    public static DifferentialEntropyStateStrategy getStrategy(DifferentialEntropyStateStrategy strategy, long size, double sample, double weight, String method, double min, double max) {
        if (strategy == null) {
            switch (method) {
                case "fixed_histogram_mle": {
                    strategy = new FixedHistogramMleStateStrategy(size, min, max);
                    break;
                }
                case "fixed_histogram_jacknife": {
                    strategy = new FixedHistogramJacknifeStateStrategy(size, min, max);
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, invalid method: %s", method));
                }
            }
        } else {
            switch (method) {
                case "fixed_histogram_mle": {
                    if (strategy instanceof FixedHistogramMleStateStrategy) break;
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy, strategy class is not compatible with entropy method: %s %s", strategy.getClass().getSimpleName(), method));
                }
                case "fixed_histogram_jacknife": {
                    if (strategy instanceof FixedHistogramJacknifeStateStrategy) break;
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy, strategy class is not compatible with entropy method: %s %s", strategy.getClass().getSimpleName(), method));
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy, unknown entropy method: %s", method));
                }
            }
        }
        strategy.validateParameters(size, sample, weight, min, max);
        return strategy;
    }

    public static DifferentialEntropyStateStrategy getStrategy(DifferentialEntropyStateStrategy strategy, long size, double sample, double weight) {
        if (strategy == null) {
            strategy = new WeightedReservoirSampleStateStrategy(size);
        } else {
            Verify.verify((boolean)(strategy instanceof WeightedReservoirSampleStateStrategy), (String)String.format("In differential entropy, expected WeightedReservoirSampleStateStrategy, got: %s", strategy.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        strategy.validateParameters(size, sample, weight);
        return strategy;
    }

    public static DifferentialEntropyStateStrategy getStrategy(DifferentialEntropyStateStrategy strategy, long size, double sample) {
        if (strategy == null) {
            strategy = new UnweightedReservoirSampleStateStrategy(size);
        } else {
            Verify.verify((boolean)(strategy instanceof UnweightedReservoirSampleStateStrategy), (String)String.format("In differential entropy, expected UnweightedReservoirSampleStateStrategy, got: %s", strategy.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        return strategy;
    }

    default public void add(double sample) {
        Verify.verify((boolean)false, (String)String.format("Unweighted unsupported for type: %s", this.getClass().getSimpleName()), (Object[])new Object[0]);
    }

    default public void add(double sample, double weight) {
        Verify.verify((boolean)false, (String)String.format("Weighted unsupported for type: %s", this.getClass().getSimpleName()), (Object[])new Object[0]);
    }

    public double calculateEntropy();

    public long getEstimatedSize();

    public static int getRequiredBytesForSerialization(DifferentialEntropyStateStrategy strategy) {
        return 8 + (strategy == null ? 0 : strategy.getRequiredBytesForSpecificSerialization());
    }

    public int getRequiredBytesForSpecificSerialization();

    public void serialize(SliceOutput var1);

    public void mergeWith(DifferentialEntropyStateStrategy var1);

    public DifferentialEntropyStateStrategy clone();

    default public void validateParameters(long size, double sample, double weight, double min, double max) {
        throw new UnsupportedOperationException(String.format("In differential_entropy UDF, unsupported arguments for type: %s", this.getClass().getSimpleName()));
    }

    default public void validateParameters(long size, double sample, double weight) {
        throw new UnsupportedOperationException(String.format("In differential_entropy UDF, unsupported arguments for type: %s", this.getClass().getSimpleName()));
    }

    default public void validateParameters(long size, double sample) {
        throw new UnsupportedOperationException(String.format("In differential_entropy UDF, unsupported arguments for type: %s", this.getClass().getSimpleName()));
    }

    public static void serialize(DifferentialEntropyStateStrategy strategy, SliceOutput sliceOut) {
        sliceOut.appendInt(DifferentialEntropyStateStrategy.class.getSimpleName().hashCode());
        if (strategy == null) {
            sliceOut.appendInt(0);
            return;
        }
        if (strategy instanceof UnweightedReservoirSampleStateStrategy) {
            sliceOut.appendInt(1);
        } else if (strategy instanceof WeightedReservoirSampleStateStrategy) {
            sliceOut.appendInt(2);
        } else if (strategy instanceof FixedHistogramMleStateStrategy) {
            sliceOut.appendInt(3);
        } else if (strategy instanceof FixedHistogramJacknifeStateStrategy) {
            sliceOut.appendInt(4);
        } else {
            Verify.verify((boolean)false, (String)String.format("Strategy cannot be serialized: %s", strategy.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        strategy.serialize(sliceOut);
    }

    public static DifferentialEntropyStateStrategy deserialize(SliceInput input) {
        Verify.verify((input.readInt() == DifferentialEntropyStateStrategy.class.getSimpleName().hashCode() ? 1 : 0) != 0, (String)"magic failed", (Object[])new Object[0]);
        int method = input.readInt();
        switch (method) {
            case 0: {
                return null;
            }
            case 1: {
                return UnweightedReservoirSampleStateStrategy.deserialize(input);
            }
            case 2: {
                return WeightedReservoirSampleStateStrategy.deserialize(input);
            }
            case 3: {
                return FixedHistogramMleStateStrategy.deserialize(input);
            }
            case 4: {
                return FixedHistogramJacknifeStateStrategy.deserialize(input);
            }
        }
        Verify.verify((boolean)false, (String)String.format("In differential_entropy UDF, Unknown method code when deserializing: %s", method), (Object[])new Object[0]);
        return null;
    }

    public static void combine(DifferentialEntropyStateStrategy strategy, DifferentialEntropyStateStrategy otherStrategy) {
        Verify.verify((strategy.getClass() == otherStrategy.getClass() ? 1 : 0) != 0, (String)String.format("In combine, %s != %s", strategy.getClass().getSimpleName(), otherStrategy.getClass().getSimpleName()), (Object[])new Object[0]);
        strategy.mergeWith(otherStrategy);
    }

    public DifferentialEntropyStateStrategy cloneEmpty();

    public double getTotalPopulationWeight();
}

