/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.presto.operator.aggregation.state.HyperLogLogState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.util.Failures;

public final class HyperLogLogUtils {
    private static final double LOWEST_MAX_STANDARD_ERROR = 0.0040625;
    private static final double HIGHEST_MAX_STANDARD_ERROR = 0.26;

    private HyperLogLogUtils() {
    }

    public static int standardErrorToBuckets(double maxStandardError) {
        Failures.checkCondition(maxStandardError >= 0.0040625 && maxStandardError <= 0.26, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Max standard error must be in [%s, %s]: %s", 0.0040625, 0.26, maxStandardError);
        return HyperLogLogUtils.log2Ceiling((int)Math.ceil(1.0816 / (maxStandardError * maxStandardError)));
    }

    public static HyperLogLog getOrCreateHyperLogLog(HyperLogLogState state, double maxStandardError) {
        HyperLogLog hll = state.getHyperLogLog();
        if (hll == null) {
            hll = HyperLogLog.newInstance((int)HyperLogLogUtils.standardErrorToBuckets(maxStandardError));
            state.setHyperLogLog(hll);
            state.addMemoryUsage(hll.estimatedInMemorySize());
        }
        return hll;
    }

    public static void mergeState(@AggregationState HyperLogLogState state, HyperLogLog input) {
        HyperLogLog previous = state.getHyperLogLog();
        if (previous == null) {
            state.setHyperLogLog(input);
            state.addMemoryUsage(input.estimatedInMemorySize());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySize());
            try {
                previous.mergeWith(input);
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, e.getMessage(), (Throwable)e);
            }
            state.addMemoryUsage(previous.estimatedInMemorySize());
        }
    }

    private static int log2Ceiling(int value) {
        return Integer.highestOneBit(value - 1) << 1;
    }
}

