/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftEnum;
import com.facebook.drift.annotations.ThriftEnumValue;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.JoinBridgeManager;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.LookupJoinOperatorFactory;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class LookupJoinOperators {
    @Inject
    public LookupJoinOperators() {
    }

    public OperatorFactory innerJoin(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactory, List<Type> probeTypes, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannels, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, boolean optimizeProbeForEmptyBuild) {
        return this.createJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeJoinChannel, probeHashChannel, probeOutputChannels.orElse(LookupJoinOperators.rangeList(probeTypes.size())), JoinType.INNER, totalOperatorsCount, partitioningSpillerFactory, optimizeProbeForEmptyBuild);
    }

    public OperatorFactory probeOuterJoin(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactory, List<Type> probeTypes, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannels, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, boolean optimizeProbeForEmptyBuild) {
        return this.createJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeJoinChannel, probeHashChannel, probeOutputChannels.orElse(LookupJoinOperators.rangeList(probeTypes.size())), JoinType.PROBE_OUTER, totalOperatorsCount, partitioningSpillerFactory, optimizeProbeForEmptyBuild);
    }

    public OperatorFactory lookupOuterJoin(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactory, List<Type> probeTypes, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannels, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, boolean optimizeProbeForEmptyBuild) {
        return this.createJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeJoinChannel, probeHashChannel, probeOutputChannels.orElse(LookupJoinOperators.rangeList(probeTypes.size())), JoinType.LOOKUP_OUTER, totalOperatorsCount, partitioningSpillerFactory, optimizeProbeForEmptyBuild);
    }

    public OperatorFactory fullOuterJoin(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactory, List<Type> probeTypes, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannels, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, boolean optimizeProbeForEmptyBuild) {
        return this.createJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeJoinChannel, probeHashChannel, probeOutputChannels.orElse(LookupJoinOperators.rangeList(probeTypes.size())), JoinType.FULL_OUTER, totalOperatorsCount, partitioningSpillerFactory, optimizeProbeForEmptyBuild);
    }

    private static List<Integer> rangeList(int endExclusive) {
        return (List)IntStream.range(0, endExclusive).boxed().collect(ImmutableList.toImmutableList());
    }

    private OperatorFactory createJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactoryManager, List<Type> probeTypes, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, List<Integer> probeOutputChannels, JoinType joinType, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, boolean optimizeProbeForEmptyBuild) {
        List probeOutputChannelTypes = (List)probeOutputChannels.stream().map(probeTypes::get).collect(ImmutableList.toImmutableList());
        return new LookupJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactoryManager, probeTypes, probeOutputChannelTypes, lookupSourceFactoryManager.getBuildOutputTypes(), joinType, new JoinProbe.JoinProbeFactory(probeOutputChannels.stream().mapToInt(i -> i).toArray(), probeJoinChannel, probeHashChannel), totalOperatorsCount, probeJoinChannel, probeHashChannel, partitioningSpillerFactory, optimizeProbeForEmptyBuild);
    }

    @ThriftEnum
    public static enum JoinType {
        INNER(0),
        PROBE_OUTER(1),
        LOOKUP_OUTER(2),
        FULL_OUTER(3);

        private final int value;

        private JoinType(int value) {
            this.value = value;
        }

        @ThriftEnumValue
        public int getValue() {
            return this.value;
        }
    }
}

