/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageSinkCommitStrategy;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.spi.UpdatablePageSource;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public abstract class AbstractRowChangeOperator
implements Operator {
    private final OperatorContext operatorContext;
    protected State state = State.RUNNING;
    protected long rowCount;
    private boolean closed;
    private ListenableFuture<Collection<Slice>> finishFuture;
    private Supplier<Optional<UpdatablePageSource>> pageSource = Optional::empty;
    private final JsonCodec<TableCommitContext> tableCommitContextCodec;

    public AbstractRowChangeOperator(OperatorContext operatorContext, JsonCodec<TableCommitContext> tableCommitContextCodec) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.tableCommitContextCodec = Objects.requireNonNull(tableCommitContextCodec, "tableCommitContextCodec is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
            this.finishFuture = MoreFutures.toListenableFuture((CompletableFuture)this.pageSource().finish());
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public abstract void addInput(Page var1);

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.finishFuture == null) {
            return NOT_BLOCKED;
        }
        return this.finishFuture;
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING || !this.finishFuture.isDone()) {
            return null;
        }
        this.state = State.FINISHED;
        Collection fragments = (Collection)MoreFutures.getFutureValue(this.finishFuture);
        int positionCount = fragments.size() + 1;
        BlockBuilder rowsBuilder = BigintType.BIGINT.createBlockBuilder(null, positionCount);
        BlockBuilder fragmentBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, positionCount);
        rowsBuilder.writeLong(this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        TaskId taskId = this.operatorContext.getDriverContext().getPipelineContext().getTaskId();
        Slice tableCommitContext = Slices.wrappedBuffer((byte[])this.tableCommitContextCodec.toJsonBytes((Object)new TableCommitContext(this.operatorContext.getDriverContext().getLifespan(), taskId, PageSinkCommitStrategy.NO_COMMIT, true)));
        return new Page(positionCount, new Block[]{rowsBuilder.build(), fragmentBuilder.build(), RunLengthEncodedBlock.create((Type)VarbinaryType.VARBINARY, (Object)tableCommitContext, (int)positionCount)});
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.finishFuture != null) {
                this.finishFuture.cancel(true);
            } else {
                this.pageSource.get().ifPresent(UpdatablePageSource::abort);
            }
        }
    }

    public void setPageSource(Supplier<Optional<UpdatablePageSource>> pageSource) {
        this.pageSource = Objects.requireNonNull(pageSource, "pageSource is null");
    }

    protected UpdatablePageSource pageSource() {
        Optional<UpdatablePageSource> source = this.pageSource.get();
        Preconditions.checkState((boolean)source.isPresent(), (Object)"UpdatablePageSource not set");
        return source.get();
    }

    protected static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }
}

