/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class BingTile {
    public static final int MAX_ZOOM_LEVEL = 23;
    @VisibleForTesting
    static final int VERSION_OFFSET = 58;
    private static final int VERSION = 0;
    private static final int BITS_23 = 0xFFFFFF;
    private static final int BITS_5 = 63;
    private static final int ZOOM_OFFSET = 26;
    private final int x;
    private final int y;
    private final int zoomLevel;

    private BingTile(int x, int y, int zoomLevel) {
        Preconditions.checkArgument((0 <= zoomLevel && zoomLevel <= 23 ? 1 : 0) != 0);
        Preconditions.checkArgument((0 <= x && x < 1 << zoomLevel ? 1 : 0) != 0);
        Preconditions.checkArgument((0 <= y && y < 1 << zoomLevel ? 1 : 0) != 0);
        this.x = x;
        this.y = y;
        this.zoomLevel = zoomLevel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BingTile otherTile = (BingTile)other;
        return this.x == otherTile.x && this.y == otherTile.y && this.zoomLevel == otherTile.zoomLevel;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.zoomLevel);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("zoom_level", this.zoomLevel).toString();
    }

    @JsonCreator
    public static BingTile fromCoordinates(@JsonProperty(value="x") int x, @JsonProperty(value="y") int y, @JsonProperty(value="zoom") int zoomLevel) {
        return new BingTile(x, y, zoomLevel);
    }

    public static BingTile fromQuadKey(String quadKey) {
        int zoomLevel = quadKey.length();
        Preconditions.checkArgument((zoomLevel <= 23 ? 1 : 0) != 0);
        int tileX = 0;
        int tileY = 0;
        block6: for (int i = zoomLevel; i > 0; --i) {
            int mask = 1 << i - 1;
            switch (quadKey.charAt(zoomLevel - i)) {
                case '0': {
                    continue block6;
                }
                case '1': {
                    tileX |= mask;
                    continue block6;
                }
                case '2': {
                    tileY |= mask;
                    continue block6;
                }
                case '3': {
                    tileX |= mask;
                    tileY |= mask;
                    continue block6;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid QuadKey digit sequence: " + quadKey);
                }
            }
        }
        return new BingTile(tileX, tileY, zoomLevel);
    }

    @JsonProperty
    public int getX() {
        return this.x;
    }

    @JsonProperty
    public int getY() {
        return this.y;
    }

    @JsonProperty(value="zoom")
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public String toQuadKey() {
        char[] quadKey = new char[this.zoomLevel];
        for (int i = this.zoomLevel; i > 0; --i) {
            int digit = 48;
            int mask = 1 << i - 1;
            if ((this.x & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((this.y & mask) != 0) {
                digit = (char)(digit + 2);
            }
            quadKey[this.zoomLevel - i] = digit;
        }
        return String.valueOf(quadKey);
    }

    public List<BingTile> findChildren() {
        return this.findChildren(this.zoomLevel + 1);
    }

    public List<BingTile> findChildren(int newZoom) {
        if (newZoom == this.zoomLevel) {
            return ImmutableList.of((Object)this);
        }
        Preconditions.checkArgument((newZoom <= 23 ? 1 : 0) != 0, (String)"newZoom must be less than or equal to %s: %s", (int)23, (int)newZoom);
        Preconditions.checkArgument((newZoom >= this.zoomLevel ? 1 : 0) != 0, (String)"newZoom must be greater than or equal to current zoom %s: %s", (int)this.zoomLevel, (int)newZoom);
        int zoomDelta = newZoom - this.zoomLevel;
        int xNew = this.x << zoomDelta;
        int yNew = this.y << zoomDelta;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(1 << 2 * zoomDelta));
        for (int yDelta = 0; yDelta < 1 << zoomDelta; ++yDelta) {
            for (int xDelta = 0; xDelta < 1 << zoomDelta; ++xDelta) {
                builder.add((Object)BingTile.fromCoordinates(xNew + xDelta, yNew + yDelta, newZoom));
            }
        }
        return builder.build();
    }

    public BingTile findParent() {
        return this.findParent(this.zoomLevel - 1);
    }

    public BingTile findParent(int newZoom) {
        if (newZoom == this.zoomLevel) {
            return this;
        }
        Preconditions.checkArgument((newZoom >= 0 ? 1 : 0) != 0, (String)"newZoom must be greater than or equal to 0: %s", (int)newZoom);
        Preconditions.checkArgument((newZoom <= this.zoomLevel ? 1 : 0) != 0, (String)"newZoom must be less than or equal to current zoom %s: %s", (int)this.zoomLevel, (int)newZoom);
        int zoomDelta = this.zoomLevel - newZoom;
        return BingTile.fromCoordinates(this.x >> zoomDelta, this.y >> zoomDelta, newZoom);
    }

    public long encode() {
        return 0L | (long)this.y | (long)this.x << 32 | (long)this.zoomLevel << 26;
    }

    public static BingTile decode(long tile) {
        int version = (int)(tile >>> 58) & 0x3F;
        if (version == 0) {
            return BingTile.decodeV0(tile);
        }
        throw new IllegalArgumentException(String.format("Unknown Bing Tile encoding version: %s", version));
    }

    private static BingTile decodeV0(long tile) {
        int tileX = (int)(tile >>> 32) & 0xFFFFFF;
        int tileY = (int)tile & 0xFFFFFF;
        int zoomLevel = (int)(tile >>> 26) & 0x3F;
        return new BingTile(tileX, tileY, zoomLevel);
    }
}

