/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.common.type.encoding.StringUtils;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHashingNodeProvider
implements NodeProvider {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32();
    private final NavigableMap<Integer, InternalNode> candidates;
    private final int nodeCount;

    static ConsistentHashingNodeProvider create(Collection<InternalNode> nodes, int weight) {
        TreeMap<Integer, InternalNode> activeNodesByConsistentHashing = new TreeMap<Integer, InternalNode>();
        for (InternalNode node : nodes) {
            for (int i = 0; i < weight; ++i) {
                activeNodesByConsistentHashing.put(HASH_FUNCTION.hashString((CharSequence)String.format("%s%d", node.getNodeIdentifier(), i), StringUtils.UTF_8).asInt(), node);
            }
        }
        return new ConsistentHashingNodeProvider(activeNodesByConsistentHashing, nodes.size());
    }

    private ConsistentHashingNodeProvider(NavigableMap<Integer, InternalNode> candidates, int nodeCount) {
        this.candidates = Objects.requireNonNull(candidates, "candidates is null");
        this.nodeCount = nodeCount;
    }

    public List<HostAddress> get(String key, int count) {
        if (count > this.nodeCount) {
            count = this.nodeCount;
        }
        LinkedHashSet<HostAddress> uniqueNodes = new LinkedHashSet<HostAddress>();
        int hashKey = HASH_FUNCTION.hashString((CharSequence)key, StringUtils.UTF_8).asInt();
        SortedMap<Integer, InternalNode> tailMap = this.candidates.tailMap(hashKey);
        for (Map.Entry<Integer, InternalNode> entry : tailMap.entrySet()) {
            uniqueNodes.add(entry.getValue().getHostAndPort());
            if (uniqueNodes.size() != count) continue;
            break;
        }
        if (uniqueNodes.size() < count) {
            SortedMap<Integer, InternalNode> headMap = this.candidates.headMap(hashKey);
            for (Map.Entry<Integer, InternalNode> entry : headMap.entrySet()) {
                uniqueNodes.add(entry.getValue().getHostAndPort());
                if (uniqueNodes.size() != count) continue;
                break;
            }
        }
        return ImmutableList.copyOf(uniqueNodes);
    }
}

