/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.resourceGroups.ResourceGroupSpecInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public class ResourceGroupRuntimeInfo {
    private final ResourceGroupId resourceGroupId;
    private final long memoryUsageBytes;
    private final int queuedQueries;
    private final int descendantQueuedQueries;
    private final int runningQueries;
    private final int descendantRunningQueries;
    private final Optional<ResourceGroupSpecInfo> resourceGroupConfigSpec;

    @ThriftConstructor
    public ResourceGroupRuntimeInfo(ResourceGroupId resourceGroupId, long memoryUsageBytes, int queuedQueries, int descendantQueuedQueries, int runningQueries, int descendantRunningQueries, Optional<ResourceGroupSpecInfo> resourceGroupConfigSpec) {
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        this.memoryUsageBytes = memoryUsageBytes;
        this.queuedQueries = queuedQueries;
        this.descendantQueuedQueries = descendantQueuedQueries;
        this.runningQueries = runningQueries;
        this.descendantRunningQueries = descendantRunningQueries;
        this.resourceGroupConfigSpec = Objects.requireNonNull(resourceGroupConfigSpec, "resourceGroupConfigSpec is null");
    }

    public static Builder builder(ResourceGroupId resourceGroupId) {
        return new Builder(resourceGroupId);
    }

    @ThriftField(value=1)
    public ResourceGroupId getResourceGroupId() {
        return this.resourceGroupId;
    }

    @ThriftField(value=2)
    public long getMemoryUsageBytes() {
        return this.memoryUsageBytes;
    }

    @ThriftField(value=3)
    public int getQueuedQueries() {
        return this.queuedQueries;
    }

    @ThriftField(value=4)
    public int getDescendantQueuedQueries() {
        return this.descendantQueuedQueries;
    }

    @ThriftField(value=5)
    public int getRunningQueries() {
        return this.runningQueries;
    }

    @ThriftField(value=6)
    public int getDescendantRunningQueries() {
        return this.descendantRunningQueries;
    }

    @ThriftField(value=7)
    public Optional<ResourceGroupSpecInfo> getResourceGroupConfigSpec() {
        return this.resourceGroupConfigSpec;
    }

    public static class Builder {
        private final ResourceGroupId resourceGroupId;
        private ResourceGroupSpecInfo resourceGroupSpecInfo;
        private long userMemoryReservationBytes;
        private int queuedQueries;
        private int descendantQueuedQueries;
        private int runningQueries;
        private int descendantRunningQueries;

        private Builder(ResourceGroupId resourceGroupId) {
            this.resourceGroupId = resourceGroupId;
        }

        public Builder addUserMemoryReservationBytes(long userMemoryReservationBytes) {
            this.userMemoryReservationBytes = Math.addExact(this.userMemoryReservationBytes, userMemoryReservationBytes);
            return this;
        }

        public Builder addQueuedQueries(int queuedQueries) {
            this.queuedQueries = Math.addExact(this.queuedQueries, queuedQueries);
            return this;
        }

        public Builder addDescendantQueuedQueries(int descendantQueuedQueries) {
            this.descendantQueuedQueries += descendantQueuedQueries;
            return this;
        }

        public Builder addRunningQueries(int runningQueries) {
            this.runningQueries = Math.addExact(this.runningQueries, runningQueries);
            return this;
        }

        public Builder addDescendantRunningQueries(int descendantRunningQueries) {
            this.descendantRunningQueries += descendantRunningQueries;
            return this;
        }

        public Builder setResourceGroupSpecInfo(ResourceGroupSpecInfo resourceGroupSpecInfo) {
            this.resourceGroupSpecInfo = resourceGroupSpecInfo;
            return this;
        }

        public ResourceGroupRuntimeInfo build() {
            return new ResourceGroupRuntimeInfo(this.resourceGroupId, this.userMemoryReservationBytes, this.queuedQueries, this.descendantQueuedQueries, this.runningQueries, this.descendantRunningQueries, Optional.ofNullable(this.resourceGroupSpecInfo));
        }
    }
}

