/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.annotations.ThriftEnum;
import com.facebook.drift.annotations.ThriftEnumValue;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

@ThriftEnum
public enum TaskState {
    PLANNED(0, false),
    RUNNING(1, false),
    FINISHED(2, true),
    CANCELED(3, true),
    ABORTED(4, true),
    FAILED(5, true);

    public static final Set<TaskState> TERMINAL_TASK_STATES;
    private final int code;
    private final boolean doneState;

    private TaskState(int code, boolean doneState) {
        this.code = code;
        this.doneState = doneState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    @ThriftEnumValue
    public int getCode() {
        return this.code;
    }

    static {
        TERMINAL_TASK_STATES = (Set)Stream.of(TaskState.values()).filter(TaskState::isDone).collect(ImmutableSet.toImmutableSet());
    }
}

