/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.common.analyzer.PreparedQuery;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.execution.AccessControlCheckerExecution;
import com.facebook.presto.execution.DDLDefinitionExecution;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.SessionDefinitionExecution;
import com.facebook.presto.execution.SqlQueryExecution;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;

public class ExecutionFactoriesManager {
    private final SqlQueryExecution.SqlQueryExecutionFactory sqlQueryExecutionFactory;
    private final DDLDefinitionExecution.DDLDefinitionExecutionFactory ddlDefinitionExecutionFactory;
    private final SessionDefinitionExecution.SessionDefinitionExecutionFactory sessionDefinitionExecutionFactory;
    private final AccessControlCheckerExecution.AccessControlCheckerExecutionFactory accessControlCheckerExecutionFactory;

    @Inject
    public ExecutionFactoriesManager(SqlQueryExecution.SqlQueryExecutionFactory sqlQueryExecutionFactory, DDLDefinitionExecution.DDLDefinitionExecutionFactory ddlDefinitionExecutionFactory, SessionDefinitionExecution.SessionDefinitionExecutionFactory sessionDefinitionExecutionFactory, AccessControlCheckerExecution.AccessControlCheckerExecutionFactory accessControlCheckerExecutionFactory) {
        this.sqlQueryExecutionFactory = sqlQueryExecutionFactory;
        this.ddlDefinitionExecutionFactory = ddlDefinitionExecutionFactory;
        this.sessionDefinitionExecutionFactory = sessionDefinitionExecutionFactory;
        this.accessControlCheckerExecutionFactory = accessControlCheckerExecutionFactory;
    }

    public QueryExecution.QueryExecutionFactory<?> getExecutionFactory(PreparedQuery preparedQuery) {
        Preconditions.checkState((preparedQuery != null && preparedQuery.getQueryType().isPresent() ? 1 : 0) != 0, (Object)"preparedQuery is null or preparedQuery does not have queryType");
        QueryType queryType = (QueryType)preparedQuery.getQueryType().get();
        if (queryType == QueryType.DATA_DEFINITION) {
            return this.ddlDefinitionExecutionFactory;
        }
        if (queryType == QueryType.CONTROL) {
            return this.sessionDefinitionExecutionFactory;
        }
        if (preparedQuery.isExplainTypeValidate()) {
            return this.accessControlCheckerExecutionFactory;
        }
        return this.sqlQueryExecutionFactory;
    }
}

