/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DropRole;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Set;

public class DropRoleTask
implements DDLDefinitionTask<DropRole> {
    @Override
    public String getName() {
        return "DROP ROLE";
    }

    @Override
    public ListenableFuture<?> execute(DropRole statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector) {
        String catalog = MetadataUtil.createCatalogName(session, (Node)statement);
        String role = statement.getName().getValueLowerCase();
        accessControl.checkCanDropRole(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), role, catalog);
        Set<String> existingRoles = metadata.listRoles(session, catalog);
        if (!existingRoles.contains(role)) {
            throw new SemanticException(SemanticErrorCode.MISSING_ROLE, (Node)statement, "Role '%s' does not exist", new Object[]{role});
        }
        metadata.dropRole(session, role, catalog);
        return Futures.immediateFuture(null);
    }
}

