/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.execution.NodeResourceStatusConfig;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class ClusterSizeMonitor {
    private final InternalNodeManager nodeManager;
    private final boolean includeCoordinator;
    private final int workerMinCount;
    private final int workerMinCountActive;
    private final Duration executionMaxWait;
    private final int coordinatorMinCount;
    private final int coordinatorMinCountActive;
    private final Duration coordinatorMaxWait;
    private final int resourceManagerMinCountActive;
    private final ScheduledExecutorService executor;
    private final Consumer<AllNodes> listener = this::updateAllNodes;
    @GuardedBy(value="this")
    private int currentWorkerCount;
    @GuardedBy(value="this")
    private int currentCoordinatorCount;
    @GuardedBy(value="this")
    private int currentResourceManagerCount;
    @GuardedBy(value="this")
    private final List<SettableFuture<?>> workerSizeFutures = new ArrayList();
    @GuardedBy(value="this")
    private final List<SettableFuture<?>> coordinatorSizeFutures = new ArrayList();

    @Inject
    public ClusterSizeMonitor(InternalNodeManager nodeManager, NodeSchedulerConfig nodeSchedulerConfig, QueryManagerConfig queryManagerConfig, NodeResourceStatusConfig nodeResourceStatusConfig) {
        this(nodeManager, Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null").isIncludeCoordinator(), Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null").getRequiredWorkers(), Objects.requireNonNull(nodeResourceStatusConfig, "nodeResourceStatusConfig is null").getRequiredWorkersActive(), queryManagerConfig.getRequiredWorkersMaxWait(), queryManagerConfig.getRequiredCoordinators(), nodeResourceStatusConfig.getRequiredCoordinatorsActive(), queryManagerConfig.getRequiredCoordinatorsMaxWait(), nodeResourceStatusConfig.getRequiredResourceManagersActive());
    }

    public ClusterSizeMonitor(InternalNodeManager nodeManager, boolean includeCoordinator, int workerMinCount, int workerMinCountActive, Duration executionMaxWait, int coordinatorMinCount, int coordinatorMinCountActive, Duration coordinatorMaxWait, int resourceManagerMinCountActive) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.includeCoordinator = includeCoordinator;
        Preconditions.checkArgument((workerMinCount >= 0 ? 1 : 0) != 0, (Object)"executionMinCount is negative");
        this.workerMinCount = workerMinCount;
        Preconditions.checkArgument((workerMinCountActive >= 0 ? 1 : 0) != 0, (Object)"executionMinCountActive is negative");
        this.workerMinCountActive = workerMinCountActive;
        this.executionMaxWait = Objects.requireNonNull(executionMaxWait, "executionMaxWait is null");
        Preconditions.checkArgument((coordinatorMinCount >= 0 ? 1 : 0) != 0, (Object)"coordinatorMinCount is negative");
        this.coordinatorMinCount = coordinatorMinCount;
        Preconditions.checkArgument((coordinatorMinCountActive >= 0 ? 1 : 0) != 0, (Object)"coordinatorMinCountActive is negative");
        this.coordinatorMinCountActive = coordinatorMinCountActive;
        this.coordinatorMaxWait = Objects.requireNonNull(coordinatorMaxWait, "coordinatorMaxWait is null");
        Preconditions.checkArgument((resourceManagerMinCountActive >= 0 ? 1 : 0) != 0, (Object)"resourceManagerMinCountActive is negative");
        this.resourceManagerMinCountActive = resourceManagerMinCountActive;
        this.executor = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"node-monitor-%s"));
    }

    @PostConstruct
    public void start() {
        this.nodeManager.addNodeChangeListener(this.listener);
        this.updateAllNodes(this.nodeManager.getAllNodes());
    }

    @PreDestroy
    public void stop() {
        this.nodeManager.removeNodeChangeListener(this.listener);
        this.executor.shutdownNow();
    }

    public boolean hasRequiredWorkers() {
        return this.currentWorkerCount >= this.workerMinCountActive;
    }

    public boolean hasRequiredResourceManagers() {
        return this.currentResourceManagerCount >= this.resourceManagerMinCountActive;
    }

    public boolean hasRequiredCoordinators() {
        return this.currentCoordinatorCount >= this.coordinatorMinCountActive;
    }

    public synchronized ListenableFuture<?> waitForMinimumWorkers() {
        if (this.currentWorkerCount >= this.workerMinCount) {
            return Futures.immediateFuture(null);
        }
        SettableFuture future = SettableFuture.create();
        this.workerSizeFutures.add(future);
        ScheduledFuture<?> timeoutTask = this.executor.schedule(() -> {
            ClusterSizeMonitor clusterSizeMonitor = this;
            synchronized (clusterSizeMonitor) {
                future.setException((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, String.format("Insufficient active worker nodes. Waited %s for at least %s workers, but only %s workers are active", this.executionMaxWait, this.workerMinCount, this.currentWorkerCount)));
            }
        }, this.executionMaxWait.toMillis(), TimeUnit.MILLISECONDS);
        future.addListener(() -> {
            timeoutTask.cancel(true);
            this.removeWorkerFuture(future);
        }, (Executor)this.executor);
        return future;
    }

    public synchronized ListenableFuture<?> waitForMinimumCoordinators() {
        if (this.currentCoordinatorCount >= this.coordinatorMinCount) {
            return Futures.immediateFuture(null);
        }
        SettableFuture future = SettableFuture.create();
        this.coordinatorSizeFutures.add(future);
        ScheduledFuture<?> timeoutTask = this.executor.schedule(() -> {
            ClusterSizeMonitor clusterSizeMonitor = this;
            synchronized (clusterSizeMonitor) {
                future.setException((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, String.format("Insufficient active coordinator nodes. Waited %s for at least %s coordinators, but only %s coordinators are active", this.executionMaxWait, 2, this.currentCoordinatorCount)));
            }
        }, this.coordinatorMaxWait.toMillis(), TimeUnit.MILLISECONDS);
        future.addListener(() -> {
            timeoutTask.cancel(true);
            this.removeCoordinatorFuture(future);
        }, (Executor)this.executor);
        return future;
    }

    private synchronized void removeWorkerFuture(SettableFuture<?> future) {
        this.workerSizeFutures.remove(future);
    }

    private synchronized void removeCoordinatorFuture(SettableFuture<?> future) {
        this.coordinatorSizeFutures.remove(future);
    }

    private synchronized void updateAllNodes(AllNodes allNodes) {
        ImmutableList listeners;
        this.currentWorkerCount = this.includeCoordinator ? allNodes.getActiveNodes().size() : Sets.difference((Set)Sets.difference(allNodes.getActiveNodes(), allNodes.getActiveCoordinators()), allNodes.getActiveResourceManagers()).size();
        this.currentCoordinatorCount = allNodes.getActiveCoordinators().size();
        this.currentResourceManagerCount = allNodes.getActiveResourceManagers().size();
        if (this.currentWorkerCount >= this.workerMinCount) {
            listeners = ImmutableList.copyOf(this.workerSizeFutures);
            this.workerSizeFutures.clear();
            this.executor.submit(() -> ClusterSizeMonitor.lambda$updateAllNodes$5((List)listeners));
        }
        if (this.currentCoordinatorCount >= this.coordinatorMinCount) {
            listeners = ImmutableList.copyOf(this.coordinatorSizeFutures);
            this.coordinatorSizeFutures.clear();
            this.executor.submit(() -> ClusterSizeMonitor.lambda$updateAllNodes$7((List)listeners));
        }
    }

    private static /* synthetic */ void lambda$updateAllNodes$7(List listeners) {
        listeners.forEach(listener -> listener.set(null));
    }

    private static /* synthetic */ void lambda$updateAllNodes$5(List listeners) {
        listeners.forEach(listener -> listener.set(null));
    }
}

