/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.util.MoreMath;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Objects;

public class StatisticRange {
    protected static final double INFINITE_TO_FINITE_RANGE_INTERSECT_OVERLAP_HEURISTIC_FACTOR = 0.25;
    protected static final double INFINITE_TO_INFINITE_RANGE_INTERSECT_OVERLAP_HEURISTIC_FACTOR = 0.5;
    private final double low;
    private final boolean openLow;
    private final double high;
    private final boolean openHigh;
    private final double distinctValues;

    @JsonCreator
    public StatisticRange(@JsonProperty(value="low") double low, @JsonProperty(value="openLow") boolean openLow, @JsonProperty(value="high") double high, @JsonProperty(value="openHigh") boolean openHigh, @JsonProperty(value="distinctValuesCount") double distinctValues) {
        Preconditions.checkArgument((low <= high || Double.isNaN(low) && Double.isNaN(high) ? 1 : 0) != 0, (String)"low value must be less than or equal to high value or both values have to be NaN, got %s and %s respectively", (Object)low, (Object)high);
        this.low = low;
        this.high = high;
        this.openLow = openLow;
        this.openHigh = openHigh;
        Preconditions.checkArgument((distinctValues >= 0.0 || Double.isNaN(distinctValues) ? 1 : 0) != 0, (String)"Distinct values count should be non-negative, got: %s", (Object)distinctValues);
        this.distinctValues = distinctValues;
    }

    public StatisticRange(double low, double high, double distinctValues) {
        this(low, false, high, false, distinctValues);
    }

    public static StatisticRange empty() {
        return new StatisticRange(Double.NaN, false, Double.NaN, false, 0.0);
    }

    public static StatisticRange from(VariableStatsEstimate estimate) {
        return new StatisticRange(estimate.getLowValue(), false, estimate.getHighValue(), false, estimate.getDistinctValuesCount());
    }

    @JsonProperty
    public double getLow() {
        return this.low;
    }

    @JsonProperty
    public double getHigh() {
        return this.high;
    }

    @JsonProperty
    public double getDistinctValuesCount() {
        return this.distinctValues;
    }

    @JsonProperty
    public boolean getOpenLow() {
        return this.openLow;
    }

    @JsonProperty
    public boolean getOpenHigh() {
        return this.openHigh;
    }

    public double length() {
        return this.high - this.low;
    }

    public boolean isEmpty() {
        return Double.isNaN(this.low) && Double.isNaN(this.high);
    }

    public double overlapPercentWith(StatisticRange other) {
        Objects.requireNonNull(other, "other is null");
        if (this.isEmpty() || other.isEmpty() || this.distinctValues == 0.0 || other.distinctValues == 0.0) {
            return 0.0;
        }
        if (this.equals(other)) {
            return 1.0;
        }
        double lengthOfIntersect = Math.min(this.high, other.high) - Math.max(this.low, other.low);
        if (Double.isInfinite(lengthOfIntersect)) {
            if (Double.isFinite(this.distinctValues) && Double.isFinite(other.distinctValues)) {
                return Math.min(other.distinctValues / this.distinctValues, 1.0);
            }
            return 0.5;
        }
        if (lengthOfIntersect == 0.0) {
            return 1.0 / Math.max(this.distinctValues, 1.0);
        }
        if (lengthOfIntersect < 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(this.length()) && Double.isFinite(lengthOfIntersect)) {
            return 0.25;
        }
        if (lengthOfIntersect > 0.0) {
            return lengthOfIntersect / this.length();
        }
        return Double.NaN;
    }

    private double overlappingDistinctValues(StatisticRange other) {
        double overlapPercentOfLeft = this.overlapPercentWith(other);
        double overlapPercentOfRight = other.overlapPercentWith(this);
        double overlapDistinctValuesLeft = overlapPercentOfLeft * this.distinctValues;
        double overlapDistinctValuesRight = overlapPercentOfRight * other.distinctValues;
        double minInputDistinctValues = StatisticRange.minExcludeNaN(this.distinctValues, other.distinctValues);
        return StatisticRange.minExcludeNaN(minInputDistinctValues, StatisticRange.maxExcludeNaN(overlapDistinctValuesLeft, overlapDistinctValuesRight));
    }

    public StatisticRange intersect(StatisticRange other) {
        boolean newOpenHigh;
        boolean newOpenLow;
        double newLow = Math.max(this.low, other.low);
        boolean bl = newOpenLow = newLow == this.low ? this.openLow : other.openLow;
        newOpenLow = MoreMath.nearlyEqual(this.low, other.low, 1.0E-10) ? this.openLow || other.openLow : newOpenLow;
        double newHigh = Math.min(this.high, other.high);
        boolean bl2 = newOpenHigh = newHigh == this.high ? this.openHigh : other.openHigh;
        boolean bl3 = MoreMath.nearlyEqual(this.high, other.high, 1.0E-10) ? this.openHigh || other.openHigh : (newOpenHigh = newOpenHigh);
        if (newLow <= newHigh) {
            return new StatisticRange(newLow, newOpenLow, newHigh, newOpenHigh, this.overlappingDistinctValues(other));
        }
        return StatisticRange.empty();
    }

    public StatisticRange addAndSumDistinctValues(StatisticRange other) {
        double newDistinctValues = this.distinctValues + other.distinctValues;
        return this.expandRangeWithNewDistinct(newDistinctValues, other);
    }

    public StatisticRange addAndMaxDistinctValues(StatisticRange other) {
        double newDistinctValues = Math.max(this.distinctValues, other.distinctValues);
        return this.expandRangeWithNewDistinct(newDistinctValues, other);
    }

    public StatisticRange addAndCollapseDistinctValues(StatisticRange other) {
        double overlapPercentOfThis = this.overlapPercentWith(other);
        double overlapPercentOfOther = other.overlapPercentWith(this);
        double overlapDistinctValuesThis = overlapPercentOfThis * this.distinctValues;
        double overlapDistinctValuesOther = overlapPercentOfOther * other.distinctValues;
        double maxOverlappingValues = Math.max(overlapDistinctValuesThis, overlapDistinctValuesOther);
        double newDistinctValues = maxOverlappingValues + (1.0 - overlapPercentOfThis) * this.distinctValues + (1.0 - overlapPercentOfOther) * other.distinctValues;
        return this.expandRangeWithNewDistinct(newDistinctValues, other);
    }

    public Range<Double> toRange() {
        return Range.range((Comparable)Double.valueOf(this.low), (BoundType)(this.openLow ? BoundType.OPEN : BoundType.CLOSED), (Comparable)Double.valueOf(this.high), (BoundType)(this.openHigh ? BoundType.OPEN : BoundType.CLOSED));
    }

    public static StatisticRange fromRange(Range<Double> range) {
        return new StatisticRange(range.hasLowerBound() ? (Double)range.lowerEndpoint() : Double.NEGATIVE_INFINITY, !range.hasLowerBound() || range.lowerBoundType() == BoundType.OPEN, range.hasUpperBound() ? (Double)range.upperEndpoint() : Double.POSITIVE_INFINITY, !range.hasUpperBound() || range.upperBoundType() == BoundType.OPEN, Double.NaN);
    }

    private StatisticRange expandRangeWithNewDistinct(double newDistinctValues, StatisticRange other) {
        double newLow = StatisticRange.minExcludeNaN(this.low, other.low);
        boolean newOpenLow = StatisticRange.getNewEndpointOpennessLow(this, other, newLow);
        double newHigh = StatisticRange.maxExcludeNaN(this.high, other.high);
        boolean newOpenHigh = StatisticRange.getNewEndpointOpennessHigh(this, other, newHigh);
        return new StatisticRange(newLow, newOpenLow, newHigh, newOpenHigh, newDistinctValues);
    }

    private static boolean getNewEndpointOpennessLow(StatisticRange first, StatisticRange second, double newLow) {
        return newLow == first.low ? first.openLow : second.openLow;
    }

    private static boolean getNewEndpointOpennessHigh(StatisticRange first, StatisticRange second, double newHigh) {
        return newHigh == first.high ? first.openHigh : second.openHigh;
    }

    private static double minExcludeNaN(double v1, double v2) {
        if (Double.isNaN(v1)) {
            return v2;
        }
        if (Double.isNaN(v2)) {
            return v1;
        }
        return Math.min(v1, v2);
    }

    private static double maxExcludeNaN(double v1, double v2) {
        if (Double.isNaN(v1)) {
            return v2;
        }
        if (Double.isNaN(v2)) {
            return v1;
        }
        return Math.max(v1, v2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticRange that = (StatisticRange)o;
        return Double.compare(that.low, this.low) == 0 && that.openLow == this.openLow && Double.compare(that.high, this.high) == 0 && that.openHigh == this.openHigh && Double.compare(that.distinctValues, this.distinctValues) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.low, this.openLow, this.high, this.openHigh, this.distinctValues);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("range", (Object)String.format("%s%s..%s%s", this.openLow ? "(" : "[", this.low, this.high, this.openHigh ? ")" : "]")).add("ndv", this.distinctValues).toString();
    }
}

