/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.DisjointRangeDomainHistogram;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.google.common.base.Preconditions;
import java.util.stream.Stream;

public class PlanNodeStatsEstimateMath {
    private PlanNodeStatsEstimateMath() {
    }

    public static PlanNodeStatsEstimate subtractSubsetStats(PlanNodeStatsEstimate superset, PlanNodeStatsEstimate subset) {
        double subsetRowCount;
        if (superset.isOutputRowCountUnknown() || subset.isOutputRowCountUnknown()) {
            return PlanNodeStatsEstimate.unknown();
        }
        double supersetRowCount = superset.getOutputRowCount();
        double outputRowCount = Double.max(supersetRowCount - (subsetRowCount = subset.getOutputRowCount()), 0.0);
        if (outputRowCount == 0.0) {
            return PlanNodeStatsEstimateMath.createZeroStats(superset);
        }
        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
        result.setOutputRowCount(outputRowCount);
        superset.getVariablesWithKnownStatistics().forEach(symbol -> {
            double subsetNonNullsCount;
            double subsetValuesPerDistinctValue;
            double supersetNonNullsCount;
            double supersetValuesPerDistinctValue;
            VariableStatsEstimate supersetSymbolStats = superset.getVariableStatistics((VariableReferenceExpression)symbol);
            VariableStatsEstimate subsetSymbolStats = subset.getVariableStatistics((VariableReferenceExpression)symbol);
            VariableStatsEstimate.Builder newSymbolStats = VariableStatsEstimate.builder();
            newSymbolStats.setAverageRowSize(supersetSymbolStats.getAverageRowSize());
            double supersetNullsCount = supersetSymbolStats.getNullsFraction() * supersetRowCount;
            double subsetNullsCount = subsetSymbolStats.getNullsFraction() * subsetRowCount;
            double newNullsCount = Double.max(supersetNullsCount - subsetNullsCount, 0.0);
            newSymbolStats.setNullsFraction(Double.min(newNullsCount, outputRowCount) / outputRowCount);
            double supersetDistinctValues = supersetSymbolStats.getDistinctValuesCount();
            double subsetDistinctValues = subsetSymbolStats.getDistinctValuesCount();
            double newDistinctValuesCount = Double.isNaN(supersetDistinctValues) || Double.isNaN(subsetDistinctValues) ? Double.NaN : (supersetDistinctValues == 0.0 ? 0.0 : (subsetDistinctValues == 0.0 ? supersetDistinctValues : ((supersetValuesPerDistinctValue = (supersetNonNullsCount = supersetRowCount - supersetNullsCount) / supersetDistinctValues) <= (subsetValuesPerDistinctValue = (subsetNonNullsCount = subsetRowCount - subsetNullsCount) / subsetDistinctValues) ? Double.max(supersetDistinctValues - subsetDistinctValues, 0.0) : supersetDistinctValues)));
            newSymbolStats.setDistinctValuesCount(newDistinctValuesCount);
            newSymbolStats.setLowValue(supersetSymbolStats.getLowValue());
            newSymbolStats.setHighValue(supersetSymbolStats.getHighValue());
            result.addVariableStatistics((VariableReferenceExpression)symbol, newSymbolStats.build());
        });
        return result.build();
    }

    public static PlanNodeStatsEstimate capStats(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap) {
        if (stats.isOutputRowCountUnknown() || cap.isOutputRowCountUnknown()) {
            return PlanNodeStatsEstimate.unknown();
        }
        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
        double cappedRowCount = Double.min(stats.getOutputRowCount(), cap.getOutputRowCount());
        result.setOutputRowCount(cappedRowCount);
        stats.getVariablesWithKnownStatistics().forEach(symbol -> {
            VariableStatsEstimate symbolStats = stats.getVariableStatistics((VariableReferenceExpression)symbol);
            VariableStatsEstimate capSymbolStats = cap.getVariableStatistics((VariableReferenceExpression)symbol);
            VariableStatsEstimate.Builder newSymbolStats = VariableStatsEstimate.builder();
            newSymbolStats.setAverageRowSize(symbolStats.getAverageRowSize());
            newSymbolStats.setDistinctValuesCount(Double.min(symbolStats.getDistinctValuesCount(), capSymbolStats.getDistinctValuesCount()));
            double newLow = Double.max(symbolStats.getLowValue(), capSymbolStats.getLowValue());
            double newHigh = Double.min(symbolStats.getHighValue(), capSymbolStats.getHighValue());
            newSymbolStats.setLowValue(newLow);
            newSymbolStats.setHighValue(newHigh);
            double numberOfNulls = stats.getOutputRowCount() * symbolStats.getNullsFraction();
            double capNumberOfNulls = cap.getOutputRowCount() * capSymbolStats.getNullsFraction();
            double cappedNumberOfNulls = Double.min(numberOfNulls, capNumberOfNulls);
            double cappedNullsFraction = cappedRowCount == 0.0 ? 1.0 : cappedNumberOfNulls / cappedRowCount;
            newSymbolStats.setNullsFraction(cappedNullsFraction);
            newSymbolStats.setHistogram(DisjointRangeDomainHistogram.addConjunction(symbolStats.getHistogram(), new StatisticRange(newLow, newHigh, 0.0)));
            result.addVariableStatistics((VariableReferenceExpression)symbol, newSymbolStats.build());
        });
        return result.build();
    }

    private static PlanNodeStatsEstimate createZeroStats(PlanNodeStatsEstimate stats) {
        PlanNodeStatsEstimate.Builder result = PlanNodeStatsEstimate.builder();
        result.setOutputRowCount(0.0);
        stats.getVariablesWithKnownStatistics().forEach(symbol -> result.addVariableStatistics((VariableReferenceExpression)symbol, VariableStatsEstimate.zero()));
        return result.build();
    }

    public static PlanNodeStatsEstimate addStatsAndSumDistinctValues(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.addStats(left, right, RangeAdditionStrategy.ADD_AND_SUM_DISTINCT);
    }

    public static PlanNodeStatsEstimate addStatsAndMaxDistinctValues(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.addStats(left, right, RangeAdditionStrategy.ADD_AND_MAX_DISTINCT);
    }

    public static PlanNodeStatsEstimate addStatsAndCollapseDistinctValues(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        return PlanNodeStatsEstimateMath.addStats(left, right, RangeAdditionStrategy.ADD_AND_COLLAPSE_DISTINCT);
    }

    public static PlanNodeStatsEstimate addStatsAndIntersect(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right) {
        if (left.isOutputRowCountUnknown() || right.isOutputRowCountUnknown()) {
            return PlanNodeStatsEstimate.unknown();
        }
        PlanNodeStatsEstimate.Builder statsBuilder = PlanNodeStatsEstimate.builder();
        double estimatedRowCount = Math.min(left.getOutputRowCount(), right.getOutputRowCount());
        double rowCount = Stream.concat(left.getVariablesWithKnownStatistics().stream(), right.getVariablesWithKnownStatistics().stream()).distinct().map(symbol -> {
            StatisticRange lstats = StatisticRange.from(left.getVariableStatistics((VariableReferenceExpression)symbol));
            StatisticRange rstats = StatisticRange.from(right.getVariableStatistics((VariableReferenceExpression)symbol));
            return Math.min(left.getOutputRowCount() * lstats.overlapPercentWith(rstats), right.getOutputRowCount() * rstats.overlapPercentWith(lstats));
        }).reduce(Math::min).orElse(estimatedRowCount);
        PlanNodeStatsEstimateMath.buildVariableStatistics(left, right, statsBuilder, rowCount, RangeAdditionStrategy.INTERSECT);
        return statsBuilder.setOutputRowCount(rowCount).build();
    }

    private static PlanNodeStatsEstimate addStats(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right, RangeAdditionStrategy strategy) {
        double rowCount = left.getOutputRowCount() + right.getOutputRowCount();
        double totalSize = left.getTotalSize() + right.getTotalSize();
        if (Double.isNaN(rowCount) && Double.isNaN(totalSize)) {
            return PlanNodeStatsEstimate.unknown();
        }
        PlanNodeStatsEstimate.Builder statsBuilder = PlanNodeStatsEstimate.builder();
        PlanNodeStatsEstimateMath.buildVariableStatistics(left, right, statsBuilder, rowCount, strategy);
        return statsBuilder.setOutputRowCount(rowCount).setTotalSize(totalSize).build();
    }

    private static void buildVariableStatistics(PlanNodeStatsEstimate left, PlanNodeStatsEstimate right, PlanNodeStatsEstimate.Builder statsBuilder, double estimatedRowCount, RangeAdditionStrategy strategy) {
        Stream.concat(left.getVariablesWithKnownStatistics().stream(), right.getVariablesWithKnownStatistics().stream()).distinct().forEach(symbol -> {
            VariableStatsEstimate symbolStats = VariableStatsEstimate.unknown();
            if (estimatedRowCount <= 0.0) {
                symbolStats = VariableStatsEstimate.zero();
            } else if (estimatedRowCount > 0.0) {
                symbolStats = PlanNodeStatsEstimateMath.addColumnStats(left.getVariableStatistics((VariableReferenceExpression)symbol), left.getOutputRowCount(), right.getVariableStatistics((VariableReferenceExpression)symbol), right.getOutputRowCount(), estimatedRowCount, strategy);
            }
            statsBuilder.addVariableStatistics((VariableReferenceExpression)symbol, symbolStats);
        });
    }

    private static VariableStatsEstimate addColumnStats(VariableStatsEstimate leftStats, double leftRows, VariableStatsEstimate rightStats, double rightRows, double newRowCount, RangeAdditionStrategy strategy) {
        Preconditions.checkArgument((newRowCount > 0.0 ? 1 : 0) != 0, (Object)"newRowCount must be greater than zero");
        StatisticRange leftRange = StatisticRange.from(leftStats);
        StatisticRange rightRange = StatisticRange.from(rightStats);
        StatisticRange sum = strategy.getRangeAdditionFunction().add(leftRange, rightRange);
        double nullsCountRight = rightStats.getNullsFraction() * rightRows;
        double nullsCountLeft = leftStats.getNullsFraction() * leftRows;
        double totalSizeLeft = (leftRows - nullsCountLeft) * leftStats.getAverageRowSize();
        double totalSizeRight = (rightRows - nullsCountRight) * rightStats.getAverageRowSize();
        double newNullsFraction = Math.min((nullsCountLeft + nullsCountRight) / newRowCount, 1.0);
        double newNonNullsRowCount = newRowCount * (1.0 - newNullsFraction);
        double newAverageRowSize = newNonNullsRowCount == 0.0 ? 0.0 : (totalSizeLeft + totalSizeRight) / newNonNullsRowCount;
        ConnectorHistogram newHistogram = RangeAdditionStrategy.INTERSECT.equals((Object)strategy) ? DisjointRangeDomainHistogram.addConjunction(leftStats.getHistogram(), rightRange) : DisjointRangeDomainHistogram.addDisjunction(leftStats.getHistogram(), rightRange);
        return VariableStatsEstimate.builder().setStatisticsRange(sum).setAverageRowSize(newAverageRowSize).setNullsFraction(newNullsFraction).setHistogram(newHistogram).build();
    }

    @FunctionalInterface
    protected static interface RangeAdditionFunction {
        public StatisticRange add(StatisticRange var1, StatisticRange var2);
    }

    protected static enum RangeAdditionStrategy {
        ADD_AND_SUM_DISTINCT(StatisticRange::addAndSumDistinctValues),
        ADD_AND_MAX_DISTINCT(StatisticRange::addAndMaxDistinctValues),
        ADD_AND_COLLAPSE_DISTINCT(StatisticRange::addAndCollapseDistinctValues),
        INTERSECT(StatisticRange::intersect);

        private final RangeAdditionFunction rangeAdditionFunction;

        private RangeAdditionStrategy(RangeAdditionFunction rangeAdditionFunction) {
            this.rangeAdditionFunction = rangeAdditionFunction;
        }

        public RangeAdditionFunction getRangeAdditionFunction() {
            return this.rangeAdditionFunction;
        }
    }
}

