/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class PartialAggregationStatsEstimate {
    private static final PartialAggregationStatsEstimate UNKNOWN = new PartialAggregationStatsEstimate(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    private final double inputBytes;
    private final double outputBytes;
    private final double inputRowCount;
    private final double outputRowCount;

    @JsonCreator
    public PartialAggregationStatsEstimate(@JsonProperty(value="inputBytes") double inputBytes, @JsonProperty(value="outputBytes") double outputBytes, @JsonProperty(value="inputRowCount") double inputRowCount, @JsonProperty(value="outputRowCount") double outputRowCount) {
        this.inputBytes = inputBytes;
        this.outputBytes = outputBytes;
        this.inputRowCount = inputRowCount;
        this.outputRowCount = outputRowCount;
    }

    public static PartialAggregationStatsEstimate unknown() {
        return UNKNOWN;
    }

    @JsonProperty
    public double getInputBytes() {
        return this.inputBytes;
    }

    @JsonProperty
    public double getOutputBytes() {
        return this.outputBytes;
    }

    @JsonProperty
    public double getInputRowCount() {
        return this.inputRowCount;
    }

    @JsonProperty
    public double getOutputRowCount() {
        return this.outputRowCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("inputBytes", this.inputBytes).add("outputBytes", this.outputBytes).add("inputRowCount", this.inputRowCount).add("outputRowCount", this.outputRowCount).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialAggregationStatsEstimate that = (PartialAggregationStatsEstimate)o;
        return Double.compare(this.inputBytes, that.inputBytes) == 0 && Double.compare(this.outputBytes, that.outputBytes) == 0 && Double.compare(this.inputRowCount, that.inputRowCount) == 0 && Double.compare(this.outputRowCount, that.outputRowCount) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.inputBytes, this.outputBytes, this.inputRowCount, this.outputRowCount);
    }

    public static boolean isUnknown(PartialAggregationStatsEstimate partialAggregationStatsEstimate) {
        return partialAggregationStatsEstimate == PartialAggregationStatsEstimate.unknown();
    }
}

