/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.HistogramCalculator;
import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.util.MoreMath;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DisjointRangeDomainHistogram
implements ConnectorHistogram {
    private final ConnectorHistogram source;
    private final RangeSet<Double> rangeSet;
    private final Range<Double> sourceSpan;

    @JsonCreator
    public DisjointRangeDomainHistogram(@JsonProperty(value="source") ConnectorHistogram source, @JsonProperty(value="ranges") Collection<StatisticRange> ranges) {
        this(source, ranges.stream().map(StatisticRange::toRange).collect(Collectors.toSet()));
    }

    public DisjointRangeDomainHistogram(ConnectorHistogram source, Iterable<Range<Double>> ranges) {
        this.source = Objects.requireNonNull(source, "source is null");
        this.sourceSpan = DisjointRangeDomainHistogram.getSourceSpan(source);
        this.rangeSet = TreeRangeSet.create(ranges).subRangeSet(this.sourceSpan);
    }

    private static Range<Double> getSourceSpan(ConnectorHistogram source) {
        return Range.closed((Comparable)Double.valueOf(source.inverseCumulativeProbability(0.0).orElse(() -> Double.NEGATIVE_INFINITY)), (Comparable)Double.valueOf(source.inverseCumulativeProbability(1.0).orElse(() -> Double.POSITIVE_INFINITY)));
    }

    @JsonProperty
    public ConnectorHistogram getSource() {
        return this.source;
    }

    @JsonProperty
    public Set<StatisticRange> getRanges() {
        return this.rangeSet.asRanges().stream().map(StatisticRange::fromRange).collect(Collectors.toSet());
    }

    public DisjointRangeDomainHistogram(ConnectorHistogram source) {
        this(source, (Iterable<Range<Double>>)ImmutableSet.of());
    }

    public Estimate cumulativeProbability(double value, boolean inclusive) {
        if (Double.isNaN(value)) {
            return Estimate.unknown();
        }
        Optional<Range<Double>> optionalSpan = this.getSpan();
        if (!optionalSpan.isPresent()) {
            return Estimate.of((double)0.0);
        }
        Range<Double> span = optionalSpan.get();
        if (value <= (Double)span.lowerEndpoint()) {
            return Estimate.of((double)0.0);
        }
        Range input = Range.range((Comparable)span.lowerEndpoint(), (BoundType)span.lowerBoundType(), (Comparable)Double.valueOf(value), (BoundType)(inclusive ? BoundType.CLOSED : BoundType.OPEN));
        Estimate fullSetOverlap = this.calculateRangeSetOverlap(this.rangeSet);
        RangeSet spanned = this.rangeSet.subRangeSet(input);
        Estimate spannedOverlap = this.calculateRangeSetOverlap((RangeSet<Double>)spanned);
        return spannedOverlap.flatMap(spannedProbability -> fullSetOverlap.map(fullSetProbability -> {
            if (fullSetProbability == 0.0) {
                return 0.0;
            }
            return MoreMath.min(spannedProbability / fullSetProbability, 1.0);
        }));
    }

    private Estimate calculateRangeSetOverlap(RangeSet<Double> ranges) {
        double cumulativeTotal = 0.0;
        for (Range range : ranges.asRanges()) {
            Estimate rangeProbability = this.getRangeProbability((Range<Double>)range);
            if (rangeProbability.isUnknown()) {
                return Estimate.unknown();
            }
            cumulativeTotal += rangeProbability.getValue();
        }
        return Estimate.of((double)cumulativeTotal);
    }

    private Estimate getRangeProbability(Range<Double> range) {
        return HistogramCalculator.calculateFilterFactor(StatisticRange.fromRange(range), this.source, Estimate.unknown(), false);
    }

    public Estimate inverseCumulativeProbability(double percentile) {
        Preconditions.checkArgument((percentile >= 0.0 && percentile <= 1.0 ? 1 : 0) != 0, (Object)"percentile must fall in [0.0, 1.0]");
        Optional<Range<Double>> optionalSpan = this.getSpan();
        if (!optionalSpan.isPresent()) {
            return Estimate.unknown();
        }
        Range<Double> span = optionalSpan.get();
        if (percentile == 0.0 && Double.isFinite((Double)span.lowerEndpoint())) {
            return this.source.inverseCumulativeProbability(0.0).map(sourceMin -> MoreMath.max((Double)span.lowerEndpoint(), sourceMin));
        }
        if (percentile == 1.0 && Double.isFinite((Double)span.upperEndpoint())) {
            return this.source.inverseCumulativeProbability(1.0).map(sourceMax -> MoreMath.min((Double)span.upperEndpoint(), sourceMax));
        }
        Estimate totalCumulativeEstimate = this.calculateRangeSetOverlap(this.rangeSet);
        if (totalCumulativeEstimate.isUnknown()) {
            return Estimate.unknown();
        }
        double totalCumulativeProbabilitySourceDomain = totalCumulativeEstimate.getValue();
        if (totalCumulativeProbabilitySourceDomain == 0.0) {
            return Estimate.unknown();
        }
        double cumulativeProbabilityNewDomain = 0.0;
        double lastRangeEstimateSourceDomain = 0.0;
        Range currentRange = null;
        for (Range range : this.rangeSet.asRanges()) {
            Estimate rangeEstimate = this.getRangeProbability((Range<Double>)range);
            if (rangeEstimate.isUnknown()) {
                return Estimate.unknown();
            }
            currentRange = range;
            lastRangeEstimateSourceDomain = rangeEstimate.getValue();
            if (!((cumulativeProbabilityNewDomain += lastRangeEstimateSourceDomain / totalCumulativeProbabilitySourceDomain) >= percentile)) continue;
            break;
        }
        if (currentRange == null) {
            return Estimate.unknown();
        }
        Estimate rangeLeftSourceEstimate = this.source.cumulativeProbability(((Double)currentRange.lowerEndpoint()).doubleValue(), currentRange.lowerBoundType() == BoundType.OPEN);
        if (rangeLeftSourceEstimate.isUnknown()) {
            return Estimate.unknown();
        }
        double rangeLeftSource = rangeLeftSourceEstimate.getValue();
        double lastRangeProportionalProbability = lastRangeEstimateSourceDomain / totalCumulativeProbabilitySourceDomain;
        double percentileLeftFromNewDomain = percentile - cumulativeProbabilityNewDomain + lastRangeProportionalProbability;
        double percentilePoint = lastRangeEstimateSourceDomain * percentileLeftFromNewDomain / lastRangeProportionalProbability;
        double finalPercentile = rangeLeftSource + percentilePoint;
        return this.source.inverseCumulativeProbability(MoreMath.min(MoreMath.max(finalPercentile, 0.0), 1.0));
    }

    public DisjointRangeDomainHistogram addDisjunction(StatisticRange other) {
        HashSet<Range<Double>> ranges = new HashSet<Range<Double>>(this.rangeSet.asRanges());
        ranges.add(other.toRange());
        return new DisjointRangeDomainHistogram(this.source, (Iterable<Range<Double>>)ranges);
    }

    public DisjointRangeDomainHistogram addConjunction(StatisticRange other) {
        return new DisjointRangeDomainHistogram(this.source, this.rangeSet.subRangeSet(other.toRange()).asRanges());
    }

    public static ConnectorHistogram addDisjunction(ConnectorHistogram histogram, StatisticRange range) {
        if (histogram instanceof DisjointRangeDomainHistogram) {
            return ((DisjointRangeDomainHistogram)histogram).addDisjunction(range);
        }
        return new DisjointRangeDomainHistogram(histogram, (Iterable<Range<Double>>)ImmutableSet.of(range.toRange()));
    }

    public static ConnectorHistogram addConjunction(ConnectorHistogram histogram, StatisticRange range) {
        if (histogram instanceof DisjointRangeDomainHistogram) {
            return ((DisjointRangeDomainHistogram)histogram).addConjunction(range);
        }
        return new DisjointRangeDomainHistogram(histogram, (Iterable<Range<Double>>)ImmutableSet.of(range.toRange()));
    }

    private Optional<Range<Double>> getSpan() {
        try {
            return Optional.of(this.rangeSet.span());
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("sourceSpan", this.sourceSpan).add("rangeSet", this.rangeSet).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisjointRangeDomainHistogram)) {
            return false;
        }
        DisjointRangeDomainHistogram other = (DisjointRangeDomainHistogram)o;
        return Objects.equals(this.source, other.source) && Objects.equals(this.sourceSpan, other.sourceSpan) && Objects.equals(this.rangeSet, other.rangeSet);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.sourceSpan, this.rangeSet);
    }
}

