/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.array.AdaptiveLongBigArray;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.PageSorter;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class PagesIndexPageSorter
implements PageSorter {
    private final PagesIndex.Factory pagesIndexFactory;

    @Inject
    public PagesIndexPageSorter(PagesIndex.Factory pagesIndexFactory) {
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
    }

    public long[] sort(List<Type> types, List<Page> pages, List<Integer> sortChannels, List<SortOrder> sortOrders, int expectedPositions) {
        PagesIndex pagesIndex = this.pagesIndexFactory.newPagesIndex(types, expectedPositions);
        pages.forEach(pagesIndex::addPage);
        pagesIndex.sort(sortChannels, sortOrders);
        int positionCount = pagesIndex.getPositionCount();
        AdaptiveLongBigArray valueAddresses = pagesIndex.getValueAddresses();
        long[] result = new long[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            result[i] = valueAddresses.get(i);
        }
        return result;
    }

    public int decodePageIndex(long address) {
        return SyntheticAddress.decodeSliceIndex(address);
    }

    public int decodePositionIndex(long address) {
        return SyntheticAddress.decodePosition(address);
    }
}

