/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class MoreLists {
    public static <T> List<List<T>> listOfListsCopy(List<List<T>> lists) {
        return (List)Objects.requireNonNull(lists, "lists is null").stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
    }

    public static <T> List<T> filteredCopy(List<T> elements, Predicate<T> predicate) {
        Objects.requireNonNull(elements, "elements is null");
        Objects.requireNonNull(predicate, "predicate is null");
        return (List)elements.stream().filter(predicate).collect(ImmutableList.toImmutableList());
    }

    public static <T, R> List<R> mappedCopy(List<T> elements, Function<T, R> mapper) {
        Objects.requireNonNull(elements, "elements is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return (List)elements.stream().map(mapper).collect(ImmutableList.toImmutableList());
    }

    public static <T> List<T> nElements(int n, IntFunction<T> function) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"n must be greater than or equal to zero");
        Objects.requireNonNull(function, "function is null");
        return (List)IntStream.range(0, n).mapToObj(function).collect(ImmutableList.toImmutableList());
    }

    private MoreLists() {
    }
}

