/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.plan.AbstractJoinNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.MergeJoinNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.planner.planPrinter.RowExpressionFormatter;
import com.facebook.presto.sql.planner.planPrinter.TextRenderer;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class GraphvizPrinter {
    private static final Map<NodeType, String> NODE_COLORS = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)NodeType.EXCHANGE, (Object)"gold").put((Object)NodeType.AGGREGATE, (Object)"chartreuse3").put((Object)NodeType.FILTER, (Object)"yellow").put((Object)NodeType.PROJECT, (Object)"bisque").put((Object)NodeType.TOPN, (Object)"darksalmon").put((Object)NodeType.OUTPUT, (Object)"white").put((Object)NodeType.LIMIT, (Object)"gray83").put((Object)NodeType.TABLESCAN, (Object)"deepskyblue").put((Object)NodeType.VALUES, (Object)"deepskyblue").put((Object)NodeType.JOIN, (Object)"orange").put((Object)NodeType.MERGE_JOIN, (Object)"grey").put((Object)NodeType.SORT, (Object)"aliceblue").put((Object)NodeType.SINK, (Object)"indianred1").put((Object)NodeType.WINDOW, (Object)"darkolivegreen4").put((Object)NodeType.UNION, (Object)"turquoise4").put((Object)NodeType.MARK_DISTINCT, (Object)"violet").put((Object)NodeType.TABLE_WRITER, (Object)"cyan").put((Object)NodeType.TABLE_WRITER_MERGE, (Object)"cyan4").put((Object)NodeType.TABLE_FINISH, (Object)"hotpink").put((Object)NodeType.INDEX_SOURCE, (Object)"dodgerblue3").put((Object)NodeType.UNNEST, (Object)"crimson").put((Object)NodeType.SAMPLE, (Object)"goldenrod4").put((Object)NodeType.ANALYZE_FINISH, (Object)"plum").put((Object)NodeType.EXPLAIN_ANALYZE, (Object)"cadetblue1").build());

    private GraphvizPrinter() {
    }

    public static String printLogical(List<PlanFragment> fragments, FunctionAndTypeManager functionAndTypeManager, Session session) {
        ImmutableMap fragmentsById = Maps.uniqueIndex(fragments, PlanFragment::getId);
        PlanNodeIdGenerator idGenerator = new PlanNodeIdGenerator();
        StringBuilder output = new StringBuilder();
        output.append("digraph logical_plan {\n");
        for (PlanFragment fragment : fragments) {
            GraphvizPrinter.printFragmentNodes(output, fragment, idGenerator, functionAndTypeManager, session);
        }
        for (PlanFragment fragment : fragments) {
            fragment.getRoot().accept((PlanVisitor)new EdgePrinter(output, (Map<PlanFragmentId, PlanFragment>)fragmentsById, idGenerator), null);
        }
        output.append("}\n");
        return output.toString();
    }

    public static String printDistributed(SubPlan plan, FunctionAndTypeManager functionAndTypeManager, Session session) {
        List<PlanFragment> fragments = plan.getAllFragments();
        ImmutableMap fragmentsById = Maps.uniqueIndex(fragments, PlanFragment::getId);
        PlanNodeIdGenerator idGenerator = new PlanNodeIdGenerator();
        StringBuilder output = new StringBuilder();
        output.append("digraph distributed_plan {\n");
        GraphvizPrinter.printSubPlan(plan, (Map<PlanFragmentId, PlanFragment>)fragmentsById, idGenerator, output, functionAndTypeManager, session);
        output.append("}\n");
        return output.toString();
    }

    public static String printDistributedFromFragments(List<PlanFragment> allFragments, FunctionAndTypeManager functionAndTypeManager, Session session) {
        PlanNodeIdGenerator idGenerator = new PlanNodeIdGenerator();
        ImmutableMap fragmentsById = Maps.uniqueIndex(allFragments, PlanFragment::getId);
        StringBuilder output = new StringBuilder();
        output.append("digraph distributed_plan {\n");
        for (PlanFragment planFragment : allFragments) {
            GraphvizPrinter.printFragmentNodes(output, planFragment, idGenerator, functionAndTypeManager, session);
            planFragment.getRoot().accept((PlanVisitor)new EdgePrinter(output, (Map<PlanFragmentId, PlanFragment>)fragmentsById, idGenerator), null);
        }
        output.append("}\n");
        return output.toString();
    }

    private static void printSubPlan(SubPlan plan, Map<PlanFragmentId, PlanFragment> fragmentsById, PlanNodeIdGenerator idGenerator, StringBuilder output, FunctionAndTypeManager functionAndTypeManager, Session session) {
        PlanFragment fragment = plan.getFragment();
        GraphvizPrinter.printFragmentNodes(output, fragment, idGenerator, functionAndTypeManager, session);
        fragment.getRoot().accept((PlanVisitor)new EdgePrinter(output, fragmentsById, idGenerator), null);
        for (SubPlan child : plan.getChildren()) {
            GraphvizPrinter.printSubPlan(child, fragmentsById, idGenerator, output, functionAndTypeManager, session);
        }
    }

    private static void printFragmentNodes(StringBuilder output, PlanFragment fragment, PlanNodeIdGenerator idGenerator, FunctionAndTypeManager functionAndTypeManager, Session session) {
        String clusterId = "cluster_" + fragment.getId();
        output.append("subgraph ").append(clusterId).append(" {").append('\n');
        output.append(String.format("label = \"%s\"", fragment.getPartitioning())).append('\n');
        PlanNode plan = fragment.getRoot();
        plan.accept((PlanVisitor)new NodePrinter(output, idGenerator, fragment.getStatsAndCosts(), functionAndTypeManager, session), null);
        output.append("}").append('\n');
    }

    static {
        Preconditions.checkState((NODE_COLORS.size() == NodeType.values().length ? 1 : 0) != 0);
    }

    private static class PlanNodeIdGenerator {
        private final Map<PlanNode, Integer> planNodeIds = new HashMap<PlanNode, Integer>();
        private int idCount;

        public String getNodeId(PlanNode from) {
            int nodeId;
            if (this.planNodeIds.containsKey(from)) {
                nodeId = this.planNodeIds.get(from);
            } else {
                ++this.idCount;
                this.planNodeIds.put(from, this.idCount);
                nodeId = this.idCount;
            }
            return "plannode_" + nodeId;
        }
    }

    private static class EdgePrinter
    extends InternalPlanVisitor<Void, Void> {
        private final StringBuilder output;
        private final Map<PlanFragmentId, PlanFragment> fragmentsById;
        private final PlanNodeIdGenerator idGenerator;

        public EdgePrinter(StringBuilder output, Map<PlanFragmentId, PlanFragment> fragmentsById, PlanNodeIdGenerator idGenerator) {
            this.output = output;
            this.fragmentsById = ImmutableMap.copyOf(fragmentsById);
            this.idGenerator = idGenerator;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            return this.visitBuildAndProbe(node, context, node.getBuild(), node.getProbe());
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            return this.visitBuildAndProbe(node, context, node.getBuild(), node.getProbe());
        }

        private Void visitBuildAndProbe(AbstractJoinNode node, Void context, PlanNode build, PlanNode probe) {
            this.printEdge(node, build, "Build");
            build.accept((PlanVisitor)this, (Object)context);
            this.printEdge(node, probe, "Probe");
            probe.accept((PlanVisitor)this, (Object)context);
            return null;
        }

        public Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                this.printEdge(node, child);
                child.accept((PlanVisitor)this, (Object)context);
            }
            return null;
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Void context) {
            for (PlanFragmentId planFragmentId : node.getSourceFragmentIds()) {
                PlanFragment target = this.fragmentsById.get(planFragmentId);
                this.printEdge(node, target.getRoot());
            }
            return null;
        }

        private void printEdge(PlanNode from, PlanNode to) {
            this.printEdge(from, to, "");
        }

        private void printEdge(PlanNode from, PlanNode to, String label) {
            String fromId = this.idGenerator.getNodeId(from);
            String toId = this.idGenerator.getNodeId(to);
            this.output.append(fromId).append(" -> ").append(toId).append(label.isEmpty() ? "" : String.format(" [label = \"%s\"]", label)).append(';').append('\n');
        }
    }

    private static class NodePrinter
    extends InternalPlanVisitor<Void, Void> {
        private static final int MAX_NAME_WIDTH = 100;
        private final StringBuilder output;
        private final PlanNodeIdGenerator idGenerator;
        private final Function<RowExpression, String> formatter;
        StatsAndCosts estimatedStatsAndCosts;

        public NodePrinter(StringBuilder output, PlanNodeIdGenerator idGenerator, StatsAndCosts estimatedStatsAndCosts, FunctionAndTypeManager functionAndTypeManager, Session session) {
            this.output = output;
            this.idGenerator = idGenerator;
            RowExpressionFormatter rowExpressionFormatter = new RowExpressionFormatter(functionAndTypeManager);
            ConnectorSession connectorSession = Objects.requireNonNull(session, "session is null").toConnectorSession();
            this.formatter = rowExpression -> rowExpressionFormatter.formatRowExpression(connectorSession, (RowExpression)rowExpression);
            this.estimatedStatsAndCosts = estimatedStatsAndCosts;
        }

        public Void visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException(String.format("Node %s does not have a Graphviz visitor", node.getClass().getName()));
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            ArrayList<String> columns = new ArrayList<String>();
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                columns.add(node.getColumnNames().get(i) + " := " + node.getColumns().get(i));
            }
            this.printNode(node, String.format("TableWriter[%s]", Joiner.on((String)", ").join(columns)), (String)NODE_COLORS.get((Object)NodeType.TABLE_WRITER));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitTableWriteMerge(TableWriterMergeNode node, Void context) {
            this.printNode(node, "TableWriterMerge", (String)NODE_COLORS.get((Object)NodeType.TABLE_WRITER_MERGE));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitStatisticsWriterNode(StatisticsWriterNode node, Void context) {
            this.printNode(node, String.format("StatisticsWriterNode[%s]", Joiner.on((String)", ").join(node.getOutputVariables())), (String)NODE_COLORS.get((Object)NodeType.ANALYZE_FINISH));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Void context) {
            this.printNode(node, String.format("TableFinish[%s]", Joiner.on((String)", ").join(node.getOutputVariables())), (String)NODE_COLORS.get((Object)NodeType.TABLE_FINISH));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Void context) {
            this.printNode(node, String.format("ExplainAnalyze[%s]", Joiner.on((String)", ").join(node.getOutputVariables())), (String)NODE_COLORS.get((Object)NodeType.EXPLAIN_ANALYZE));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitSample(SampleNode node, Void context) {
            this.printNode(node, String.format("Sample[type=%s, ratio=%f]", new Object[]{node.getSampleType(), node.getSampleRatio()}), (String)NODE_COLORS.get((Object)NodeType.SAMPLE));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitSort(SortNode node, Void context) {
            this.printNode(node, String.format("Sort[%s]", Joiner.on((String)", ").join((Iterable)node.getOrderingScheme().getOrderByVariables())), (String)NODE_COLORS.get((Object)NodeType.SORT));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Void visitMarkDistinct(MarkDistinctNode node, Void context) {
            this.printNode((PlanNode)node, String.format("MarkDistinct[%s]", node.getMarkerVariable()), String.format("%s => %s", node.getDistinctVariables(), node.getMarkerVariable()), (String)NODE_COLORS.get((Object)NodeType.MARK_DISTINCT));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.printNode(node, "Window", String.format("partition by = %s|order by = %s", Joiner.on((String)", ").join(node.getPartitionBy()), node.getOrderingScheme().map(orderingScheme -> Joiner.on((String)", ").join((Iterable)orderingScheme.getOrderByVariables())).orElse("")), (String)NODE_COLORS.get((Object)NodeType.WINDOW));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Void context) {
            this.printNode(node, "RowNumber", String.format("partition by = %s", Joiner.on((String)", ").join(node.getPartitionBy())), (String)NODE_COLORS.get((Object)NodeType.WINDOW));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            this.printNode(node, "TopNRowNumber", String.format("partition by = %s|order by = %s|n = %s", Joiner.on((String)", ").join(node.getPartitionBy()), Joiner.on((String)", ").join((Iterable)node.getOrderingScheme().getOrderByVariables()), node.getMaxRowCountPerPartition()), (String)NODE_COLORS.get((Object)NodeType.WINDOW));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Void visitUnion(UnionNode node, Void context) {
            this.printNode((PlanNode)node, "Union", (String)NODE_COLORS.get((Object)NodeType.UNION));
            for (PlanNode planNode : node.getSources()) {
                planNode.accept((PlanVisitor)this, (Object)context);
            }
            return null;
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Void context) {
            this.printNode(node, (node.getOrderingScheme().isPresent() ? "Merge" : "Exchange") + " 1:N", (String)NODE_COLORS.get((Object)NodeType.EXCHANGE));
            return null;
        }

        @Override
        public Void visitExchange(ExchangeNode node, Void context) {
            String columns = node.getType() == ExchangeNode.Type.REPARTITION ? Joiner.on((String)", ").join(node.getPartitioningScheme().getPartitioning().getArguments()) : Joiner.on((String)", ").join(node.getOutputVariables());
            this.printNode(node, String.format("ExchangeNode[%s]", new Object[]{node.getType()}), columns, (String)NODE_COLORS.get((Object)NodeType.EXCHANGE));
            for (PlanNode planNode : node.getSources()) {
                planNode.accept((PlanVisitor)this, (Object)context);
            }
            return null;
        }

        public Void visitAggregation(AggregationNode node, Void context) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : node.getAggregations().entrySet()) {
                builder.append(String.format("%s := %s\\n", entry.getKey(), this.formatAggregation((AggregationNode.Aggregation)entry.getValue())));
            }
            this.printNode((PlanNode)node, String.format("Aggregate[%s]", node.getStep()), builder.toString(), (String)NODE_COLORS.get((Object)NodeType.AGGREGATE));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        private String formatAggregation(AggregationNode.Aggregation aggregation) {
            return String.format("%s(%s)%s%s%s", aggregation.getCall().getDisplayName(), Joiner.on((String)",").join((Iterable)aggregation.getArguments().stream().map(RowExpression::toString).collect(ImmutableList.toImmutableList())), aggregation.getFilter().map(filter -> String.format(" WHERE %s", filter)).orElse(""), aggregation.getOrderBy().map(orderingScheme -> String.format(" ORDER BY %s", orderingScheme)).orElse(""), aggregation.getMask().map(mask -> String.format(" (mask = %s)", mask)).orElse(""));
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Void context) {
            List inputGroupingSetSymbols = node.getGroupingSets().stream().map(set -> "(" + Joiner.on((String)", ").join((Iterable)set.stream().map(symbol -> node.getGroupingColumns().get(symbol)).collect(Collectors.toList())) + ")").collect(Collectors.toList());
            this.printNode(node, "GroupId", Joiner.on((String)", ").join(inputGroupingSetSymbols), (String)NODE_COLORS.get((Object)NodeType.AGGREGATE));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Void visitFilter(FilterNode node, Void context) {
            String expression = this.formatter.apply(node.getPredicate());
            this.printNode((PlanNode)node, "Filter", expression, (String)NODE_COLORS.get((Object)NodeType.FILTER));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Void visitProject(ProjectNode node, Void context) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : node.getAssignments().entrySet()) {
                if (entry.getValue() instanceof VariableReferenceExpression && ((VariableReferenceExpression)entry.getValue()).getName().equals(((VariableReferenceExpression)entry.getKey()).getName())) continue;
                builder.append(String.format("%s := %s\\n", entry.getKey(), this.formatter.apply((RowExpression)entry.getValue())));
            }
            this.printNode((PlanNode)node, "Project", builder.toString(), (String)NODE_COLORS.get((Object)NodeType.PROJECT));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitUnnest(UnnestNode node, Void context) {
            if (!node.getOrdinalityVariable().isPresent()) {
                this.printNode(node, String.format("Unnest[%s]", node.getUnnestVariables().keySet()), (String)NODE_COLORS.get((Object)NodeType.UNNEST));
            } else {
                this.printNode(node, String.format("Unnest[%s (ordinality)]", node.getUnnestVariables().keySet()), (String)NODE_COLORS.get((Object)NodeType.UNNEST));
            }
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Void visitTopN(TopNNode node, Void context) {
            Iterable keys = Iterables.transform((Iterable)node.getOrderingScheme().getOrderByVariables(), input -> input + " " + node.getOrderingScheme().getOrdering(input));
            this.printNode((PlanNode)node, String.format("TopN[%s]", node.getCount()), Joiner.on((String)", ").join(keys), (String)NODE_COLORS.get((Object)NodeType.TOPN));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Void visitOutput(OutputNode node, Void context) {
            String columns = NodePrinter.getColumns(node);
            this.printNode((PlanNode)node, String.format("Output[%s]", columns), (String)NODE_COLORS.get((Object)NodeType.OUTPUT));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Void visitDistinctLimit(DistinctLimitNode node, Void context) {
            this.printNode((PlanNode)node, String.format("DistinctLimit[%s]", node.getLimit()), (String)NODE_COLORS.get((Object)NodeType.LIMIT));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Void visitLimit(LimitNode node, Void context) {
            this.printNode((PlanNode)node, String.format("Limit[%s]", node.getCount()), (String)NODE_COLORS.get((Object)NodeType.LIMIT));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Void visitTableScan(TableScanNode node, Void context) {
            this.printNode((PlanNode)node, String.format("TableScan | [%s]", node.getTable()), (String)NODE_COLORS.get((Object)NodeType.TABLESCAN));
            return null;
        }

        public Void visitValues(ValuesNode node, Void context) {
            if (node.getValuesNodeLabel().isPresent()) {
                this.printNode((PlanNode)node, String.format("Values converted from TableScan[%s]", node.getValuesNodeLabel().get()), (String)NODE_COLORS.get((Object)NodeType.TABLESCAN));
            } else {
                this.printNode((PlanNode)node, "Values", (String)NODE_COLORS.get((Object)NodeType.TABLESCAN));
            }
            return null;
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            this.printNode(node, "Scalar", (String)NODE_COLORS.get((Object)NodeType.PROJECT));
            return (Void)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(JoinNodeUtils.toExpression(clause));
            }
            String joinCriteria = Joiner.on((String)" AND ").join(joinExpressions);
            StringBuilder details = new StringBuilder(joinCriteria);
            if (!node.getDynamicFilters().isEmpty()) {
                details.append(", ");
                details.append(PlanPrinter.getDynamicFilterAssignments(node));
            }
            String distributionType = node.getDistributionType().isPresent() ? node.getDistributionType().get().toString() : "UNKNOWN";
            String joinType = node.isCrossJoin() ? "CrossJoin" : node.getType().getJoinLabel();
            String label = String.format("%s[%s]", joinType, distributionType);
            this.printNode(node, label, details.toString(), (String)NODE_COLORS.get((Object)NodeType.JOIN));
            node.getLeft().accept((PlanVisitor)this, (Object)context);
            node.getRight().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            String joinExpression = String.format("%s = %s", node.getSourceJoinVariable(), node.getFilteringSourceJoinVariable());
            StringBuilder details = new StringBuilder(joinExpression);
            if (!node.getDynamicFilters().isEmpty()) {
                details.append(", ");
                details.append(PlanPrinter.getDynamicFilterAssignments(node));
            }
            String label = String.format("SemiJoin[%s]", node.getDistributionType().isPresent() ? node.getDistributionType().get().toString() : "UNKNOWN");
            this.printNode(node, label, details.toString(), (String)NODE_COLORS.get((Object)NodeType.JOIN));
            node.getSource().accept((PlanVisitor)this, (Object)context);
            node.getFilteringSource().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Void context) {
            this.printNode(node, node.getType().getJoinLabel(), this.formatter.apply(node.getFilter()), (String)NODE_COLORS.get((Object)NodeType.JOIN));
            node.getLeft().accept((PlanVisitor)this, (Object)context);
            node.getRight().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitMergeJoin(MergeJoinNode node, Void context) {
            this.printNode(node, "MergeJoin", (String)NODE_COLORS.get((Object)NodeType.MERGE_JOIN));
            node.getLeft().accept((PlanVisitor)this, (Object)context);
            node.getRight().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Void context) {
            String parameters = Joiner.on((String)",").join(node.getCorrelation());
            this.printNode(node, "Apply", parameters, (String)NODE_COLORS.get((Object)NodeType.JOIN));
            node.getInput().accept((PlanVisitor)this, (Object)context);
            node.getSubquery().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Void context) {
            this.printNode(node, "AssignUniqueId", (String)NODE_COLORS.get((Object)NodeType.PROJECT));
            node.getSource().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitLateralJoin(LateralJoinNode node, Void context) {
            String parameters = Joiner.on((String)",").join(node.getCorrelation());
            this.printNode(node, "LateralJoin", parameters, (String)NODE_COLORS.get((Object)NodeType.JOIN));
            node.getInput().accept((PlanVisitor)this, (Object)context);
            node.getSubquery().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Void context) {
            this.printNode(node, String.format("IndexSource[%s]", node.getIndexHandle()), (String)NODE_COLORS.get((Object)NodeType.INDEX_SOURCE));
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Void context) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)ExpressionTreeUtils.createSymbolReference(clause.getProbe()), (Expression)ExpressionTreeUtils.createSymbolReference(clause.getIndex())));
            }
            String criteria = Joiner.on((String)" AND ").join(joinExpressions);
            String joinLabel = String.format("%sIndexJoin", node.getType().getJoinLabel());
            this.printNode(node, joinLabel, criteria, (String)NODE_COLORS.get((Object)NodeType.JOIN));
            node.getProbeSource().accept((PlanVisitor)this, (Object)context);
            node.getIndexSource().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        private void printNode(PlanNode node, String label, String color) {
            String nodeEstimate = this.addStatsEstimate(node);
            String nodeId = this.idGenerator.getNodeId(node);
            label = NodePrinter.escapeSpecialCharacters(label);
            nodeEstimate = NodePrinter.escapeSpecialCharacters(nodeEstimate);
            this.output.append(nodeId).append(String.format("[label=\"{%s|%s}\", style=\"rounded, filled\", shape=record, fillcolor=%s]", label, nodeEstimate, color)).append(';').append('\n');
        }

        private void printNode(PlanNode node, String label, String details, String color) {
            if (details.isEmpty()) {
                this.printNode(node, label, color);
            } else {
                String nodeEstimate = this.addStatsEstimate(node);
                String nodeId = this.idGenerator.getNodeId(node);
                label = NodePrinter.escapeSpecialCharacters(label);
                details = NodePrinter.escapeSpecialCharacters(details);
                nodeEstimate = NodePrinter.escapeSpecialCharacters(nodeEstimate);
                this.output.append(nodeId).append(String.format("[label=\"{%s|%s|%s}\", style=\"rounded, filled\", shape=record, fillcolor=%s]", label, details, nodeEstimate, color)).append(';').append('\n');
            }
        }

        private String addStatsEstimate(PlanNode node) {
            PlanNodeStatsEstimate stats = this.estimatedStatsAndCosts.getStats().getOrDefault(node.getId(), PlanNodeStatsEstimate.unknown());
            PlanCostEstimate cost = this.estimatedStatsAndCosts.getCosts().getOrDefault(node.getId(), PlanCostEstimate.unknown());
            StringBuilder output = new StringBuilder();
            output.append("Estimates: ");
            output.append(String.format("{rows: %s (%s), cpu: %s, memory: %s, network: %s}", TextRenderer.formatAsLong(stats.getOutputRowCount()), TextRenderer.formatEstimateAsDataSize(stats.getOutputSizeInBytes(node)), TextRenderer.formatDouble(cost.getCpuCost()), TextRenderer.formatDouble(cost.getMaxMemory()), TextRenderer.formatDouble(cost.getNetworkCost())));
            output.append("\n");
            return output.toString();
        }

        private static String getColumns(OutputNode node) {
            Iterator columnNames = node.getColumnNames().iterator();
            String columns = "";
            int nameWidth = 0;
            while (columnNames.hasNext()) {
                String columnName = (String)columnNames.next();
                columns = columns + columnName;
                nameWidth += columnName.length();
                if (columnNames.hasNext()) {
                    columns = columns + ", ";
                }
                if (nameWidth < 100) continue;
                columns = columns + "\\n";
                nameWidth = 0;
            }
            return columns;
        }

        private static String escapeSpecialCharacters(String label) {
            return label.replace("<", "\\<").replace(">", "\\>").replace("\"", "\\\"").replace("{", "\\{").replace("}", "\\}");
        }
    }

    private static enum NodeType {
        EXCHANGE,
        AGGREGATE,
        FILTER,
        PROJECT,
        TOPN,
        OUTPUT,
        LIMIT,
        TABLESCAN,
        VALUES,
        JOIN,
        MERGE_JOIN,
        SINK,
        WINDOW,
        UNION,
        SORT,
        SAMPLE,
        MARK_DISTINCT,
        TABLE_WRITER,
        TABLE_WRITER_MERGE,
        TABLE_FINISH,
        INDEX_SOURCE,
        UNNEST,
        ANALYZE_FINISH,
        EXPLAIN_ANALYZE;

    }
}

