/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.setdigest;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.type.setdigest.SetDigest;
import com.facebook.presto.type.setdigest.SetDigestState;
import com.facebook.presto.type.setdigest.SetDigestStateSerializer;
import io.airlift.slice.Slice;

@AggregationFunction(value="make_set_digest")
public final class BuildSetDigestAggregation {
    private static final SetDigestStateSerializer SERIALIZER = new SetDigestStateSerializer();

    private BuildSetDigestAggregation() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState SetDigestState state, @SqlType(value="T") long value) {
        if (state.getDigest() == null) {
            state.setDigest(new SetDigest());
        }
        state.getDigest().add(value);
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState SetDigestState state, @SqlType(value="T") Slice value) {
        if (state.getDigest() == null) {
            state.setDigest(new SetDigest());
        }
        state.getDigest().add(value);
    }

    @CombineFunction
    public static void combine(SetDigestState state, SetDigestState otherState) {
        if (state.getDigest() == null) {
            SetDigest copy = new SetDigest();
            copy.mergeWith(otherState.getDigest());
            state.setDigest(copy);
        } else {
            state.getDigest().mergeWith(otherState.getDigest());
        }
    }

    @OutputFunction(value="SetDigest")
    public static void output(SetDigestState state, BlockBuilder out) {
        SERIALIZER.serialize(state, out);
    }
}

