/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tracing;

import com.facebook.presto.spi.tracing.TracerProvider;
import com.facebook.presto.tracing.NoopTracerProvider;
import com.facebook.presto.tracing.SimpleTracerProvider;
import com.facebook.presto.tracing.TracingConfig;
import com.google.inject.Inject;
import java.util.Objects;
import javax.annotation.Nullable;

public class TracerProviderManager {
    private final String tracerType;
    private final boolean systemTracingEnabled;
    @Nullable
    private TracerProvider tracerProvider;

    @Inject
    public TracerProviderManager(TracingConfig config) {
        Objects.requireNonNull(config, "config is null");
        this.tracerType = config.getTracerType();
        boolean enableDistributedTracing = config.getEnableDistributedTracing();
        TracingConfig.DistributedTracingMode distributedTracingMode = config.getDistributedTracingMode();
        this.systemTracingEnabled = enableDistributedTracing && distributedTracingMode.name().equalsIgnoreCase(TracingConfig.DistributedTracingMode.ALWAYS_TRACE.name());
    }

    public void addTracerProviderFactory(TracerProvider provider) {
        if (!this.tracerType.equals(provider.getTracerType())) {
            throw new IllegalArgumentException(String.format("Plugin-configured tracer provider ('%s') does not match system-configured provider ('%s').", provider.getName(), this.tracerType));
        }
        if (this.systemTracingEnabled) {
            if (this.tracerProvider != null) {
                throw new IllegalArgumentException(String.format("Only a single plugin should set the tracer provider ('%s').", this.tracerProvider.getTracerType()));
            }
            this.tracerProvider = provider;
        }
    }

    public void loadTracerProvider() {
        if (this.tracerProvider != null) {
            return;
        }
        this.tracerProvider = this.tracerType.equals("simple") && this.systemTracingEnabled ? new SimpleTracerProvider() : new NoopTracerProvider();
    }

    public TracerProvider getTracerProvider() {
        if (this.tracerProvider != null) {
            return this.tracerProvider;
        }
        return new NoopTracerProvider();
    }
}

