/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tracing;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.tracing.Tracer;
import com.facebook.presto.tracing.SimpleTracerBlock;
import com.facebook.presto.tracing.SimpleTracerPoint;
import com.google.common.base.MoreObjects;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SimpleTracer
implements Tracer {
    public final Map<String, SimpleTracerBlock> blockMap = new ConcurrentHashMap<String, SimpleTracerBlock>();
    public final Map<String, SimpleTracerBlock> recorderBlockMap = new LinkedHashMap<String, SimpleTracerBlock>();
    public final List<SimpleTracerPoint> pointList = new CopyOnWriteArrayList<SimpleTracerPoint>();
    public final String traceToken;

    public SimpleTracer(String traceToken) {
        this.traceToken = traceToken;
        this.addPoint("Start tracing");
    }

    public void addPoint(String annotation) {
        this.pointList.add(new SimpleTracerPoint(annotation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlock(String blockName, String annotation) {
        if (this.blockMap.containsKey(blockName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DISTRIBUTED_TRACING_ERROR, "Duplicated block inserted: " + blockName);
        }
        SimpleTracerBlock block = new SimpleTracerBlock(annotation);
        this.blockMap.put(blockName, block);
        Map<String, SimpleTracerBlock> map = this.recorderBlockMap;
        synchronized (map) {
            this.recorderBlockMap.put(blockName, block);
        }
    }

    public void addPointToBlock(String blockName, String annotation) {
        if (!this.blockMap.containsKey(blockName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DISTRIBUTED_TRACING_ERROR, "Adding point to non-existing block: " + blockName);
        }
        this.blockMap.get(blockName).addPoint(new SimpleTracerPoint(annotation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBlock(String blockName, String annotation) {
        if (!this.blockMap.containsKey(blockName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DISTRIBUTED_TRACING_ERROR, "Trying to end a non-existing block: " + blockName);
        }
        this.blockMap.remove(blockName);
        Map<String, SimpleTracerBlock> map = this.recorderBlockMap;
        synchronized (map) {
            this.recorderBlockMap.get(blockName).end(annotation);
        }
    }

    public void endTrace(String annotation) {
        this.pointList.add(new SimpleTracerPoint(annotation));
    }

    public String getTracerId() {
        if (this.traceToken != null) {
            return this.traceToken;
        }
        return "com.facebook.presto";
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("points", this.pointList).add("blocks", this.recorderBlockMap).toString();
    }
}

