/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.spi.eventlistener.CTEInformation;
import com.facebook.presto.spi.eventlistener.PlanOptimizerInformation;
import com.facebook.presto.sql.planner.optimizations.OptimizerResult;
import com.facebook.presto.sql.planner.planPrinter.HashCollisionPlanNodeStats;
import com.facebook.presto.sql.planner.planPrinter.NodeRepresentation;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.facebook.presto.sql.planner.planPrinter.PlanRepresentation;
import com.facebook.presto.sql.planner.planPrinter.Renderer;
import com.facebook.presto.sql.planner.planPrinter.WindowOperatorStats;
import com.facebook.presto.sql.planner.planPrinter.WindowPlanNodeStats;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.units.DataSize;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TextRenderer
implements Renderer<String> {
    private final boolean verbose;
    private final int level;
    private final boolean verboseOptimizerInfo;

    public TextRenderer(boolean verbose, int level, boolean verboseOptimizerInfo) {
        this.verbose = verbose;
        this.level = level;
        this.verboseOptimizerInfo = verboseOptimizerInfo;
    }

    @Override
    public String render(PlanRepresentation plan) {
        StringBuilder output = new StringBuilder();
        String result = this.writeTextOutput(output, plan, this.level, plan.getRoot());
        if (this.verboseOptimizerInfo) {
            String optimizerInfo = this.optimizerInfoToText(plan.getPlanOptimizerInfo());
            String cteInformation = this.cteInformationToText(plan.getCteInformationList());
            String optimizerResults = this.optimizerResultsToText(plan.getPlanOptimizerResults());
            result = result + optimizerInfo;
            result = result + cteInformation;
            result = result + optimizerResults;
        }
        return result;
    }

    private String writeTextOutput(StringBuilder output, PlanRepresentation plan, int level, NodeRepresentation node) {
        String stats;
        output.append(TextRenderer.indentString(level)).append("- ").append(node.getName()).append(node.getPlanNodeIds().isEmpty() ? "" : String.format("[PlanNodeId %s]", Joiner.on((String)",").join(node.getPlanNodeIds()))).append(node.getSourceLocation().isPresent() ? "(" + node.getSourceLocation().get().toString() + ")" : "").append(node.getIdentifier()).append(" => [").append(node.getOutputs().stream().map(s -> s.getName() + ":" + s.getType().getDisplayName()).collect(Collectors.joining(", "))).append("]\n");
        String estimates = this.printEstimates(plan, node);
        if (!estimates.isEmpty()) {
            output.append(TextRenderer.indentMultilineString(estimates, level + 2));
        }
        if (!(stats = this.printStats(plan, node)).isEmpty()) {
            output.append(TextRenderer.indentMultilineString(stats, level + 2));
        }
        if (!node.getDetails().isEmpty()) {
            String details = TextRenderer.indentMultilineString(node.getDetails(), level + 2);
            output.append(details);
            if (!details.endsWith("\n")) {
                output.append('\n');
            }
        }
        List children = node.getChildren().stream().map(plan::getNode).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        for (NodeRepresentation child : children) {
            this.writeTextOutput(output, plan, level + 1, child);
        }
        return output.toString();
    }

    private String printStats(PlanRepresentation plan, NodeRepresentation node) {
        StringBuilder output = new StringBuilder();
        if (!(node.getStats().isPresent() && plan.getTotalCpuTime().isPresent() && plan.getTotalScheduledTime().isPresent())) {
            return "";
        }
        PlanNodeStats nodeStats = node.getStats().get();
        double scheduledTimeFraction = 100.0 * (double)nodeStats.getPlanNodeScheduledTime().toMillis() / (double)plan.getTotalScheduledTime().get().toMillis();
        double cpuTimeFraction = 100.0 * (double)nodeStats.getPlanNodeCpuTime().toMillis() / (double)plan.getTotalCpuTime().get().toMillis();
        output.append(String.format("CPU: %s (%s%%), Scheduled: %s (%s%%)", nodeStats.getPlanNodeCpuTime().convertToMostSuccinctTimeUnit(), TextRenderer.formatDouble(cpuTimeFraction), nodeStats.getPlanNodeScheduledTime().convertToMostSuccinctTimeUnit(), TextRenderer.formatDouble(scheduledTimeFraction)));
        output.append(String.format(", Output: %s (%s)%n", TextRenderer.formatPositions(nodeStats.getPlanNodeOutputPositions()), nodeStats.getPlanNodeOutputDataSize().toString()));
        this.printDistributions(output, nodeStats);
        if (nodeStats instanceof WindowPlanNodeStats) {
            this.printWindowOperatorStats(output, ((WindowPlanNodeStats)nodeStats).getWindowOperatorStats());
        }
        return output.toString();
    }

    private void printDistributions(StringBuilder output, PlanNodeStats stats) {
        Map<String, Double> inputAverages = stats.getOperatorInputPositionsAverages();
        Map<String, Double> inputStdDevs = stats.getOperatorInputPositionsStdDevs();
        Map<Object, Object> hashCollisionsAverages = Collections.emptyMap();
        Map<Object, Object> hashCollisionsStdDevs = Collections.emptyMap();
        Map<Object, Object> expectedHashCollisionsAverages = Collections.emptyMap();
        if (stats instanceof HashCollisionPlanNodeStats) {
            hashCollisionsAverages = ((HashCollisionPlanNodeStats)stats).getOperatorHashCollisionsAverages();
            hashCollisionsStdDevs = ((HashCollisionPlanNodeStats)stats).getOperatorHashCollisionsStdDevs();
            expectedHashCollisionsAverages = ((HashCollisionPlanNodeStats)stats).getOperatorExpectedCollisionsAverages();
        }
        Map<String, String> translatedOperatorTypes = TextRenderer.translateOperatorTypes(stats.getOperatorTypes());
        for (String operator : translatedOperatorTypes.keySet()) {
            String translatedOperatorType = translatedOperatorTypes.get(operator);
            double inputAverage = inputAverages.get(operator);
            output.append(translatedOperatorType);
            output.append(String.format(Locale.US, "Input avg.: %s rows, Input std.dev.: %s%%%n", TextRenderer.formatDouble(inputAverage), TextRenderer.formatDouble(100.0 * inputStdDevs.get(operator) / inputAverage)));
            double hashCollisionsAverage = hashCollisionsAverages.getOrDefault(operator, 0.0);
            double expectedHashCollisionsAverage = expectedHashCollisionsAverages.getOrDefault(operator, 0.0);
            if (hashCollisionsAverage == 0.0) continue;
            double hashCollisionsStdDevRatio = (Double)hashCollisionsStdDevs.get(operator) / hashCollisionsAverage;
            if (!translatedOperatorType.isEmpty()) {
                output.append(TextRenderer.indentString(2));
            }
            if (expectedHashCollisionsAverage != 0.0) {
                double hashCollisionsRatio = hashCollisionsAverage / expectedHashCollisionsAverage;
                output.append(String.format(Locale.US, "Collisions avg.: %s (%s%% est.), Collisions std.dev.: %s%%", TextRenderer.formatDouble(hashCollisionsAverage), TextRenderer.formatDouble(hashCollisionsRatio * 100.0), TextRenderer.formatDouble(hashCollisionsStdDevRatio * 100.0)));
            } else {
                output.append(String.format(Locale.US, "Collisions avg.: %s, Collisions std.dev.: %s%%", TextRenderer.formatDouble(hashCollisionsAverage), TextRenderer.formatDouble(hashCollisionsStdDevRatio * 100.0)));
            }
            output.append("\n");
        }
    }

    private void printWindowOperatorStats(StringBuilder output, WindowOperatorStats stats) {
        if (!this.verbose) {
            return;
        }
        output.append(String.format("Active Drivers: [ %d / %d ]%n", stats.getActiveDrivers(), stats.getTotalDrivers()));
        output.append(String.format("Index size: std.dev.: %s bytes , %s rows%n", TextRenderer.formatDouble(stats.getIndexSizeStdDev()), TextRenderer.formatDouble(stats.getIndexPositionsStdDev())));
        output.append(String.format("Index count per driver: std.dev.: %s%n", TextRenderer.formatDouble(stats.getIndexCountPerDriverStdDev())));
        output.append(String.format("Rows per driver: std.dev.: %s%n", TextRenderer.formatDouble(stats.getRowsPerDriverStdDev())));
        output.append(String.format("Size of partition: std.dev.: %s%n", TextRenderer.formatDouble(stats.getPartitionRowsStdDev())));
    }

    private static Map<String, String> translateOperatorTypes(Set<String> operators) {
        if (operators.size() == 1) {
            return ImmutableMap.of((Object)Iterables.getOnlyElement(operators), (Object)"");
        }
        if (operators.contains("LookupJoinOperator") && operators.contains("HashBuilderOperator")) {
            return ImmutableMap.of((Object)"LookupJoinOperator", (Object)"Left (probe) ", (Object)"HashBuilderOperator", (Object)"Right (build) ");
        }
        return ImmutableMap.of();
    }

    private String printEstimates(PlanRepresentation plan, NodeRepresentation node) {
        if (node.getEstimatedStats().stream().allMatch(PlanNodeStatsEstimate::isOutputRowCountUnknown) && node.getEstimatedCost().stream().allMatch(c -> c.equals(PlanCostEstimate.unknown()))) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        int estimateCount = node.getEstimatedStats().size();
        output.append("Estimates: ");
        for (int i = 0; i < estimateCount; ++i) {
            boolean hasHashtableStats;
            PlanNodeStatsEstimate stats = node.getEstimatedStats().get(i);
            PlanCostEstimate cost = node.getEstimatedCost().get(i);
            String formatStr = "{source: %s, rows: %s (%s), cpu: %s, memory: %s, network: %s%s%s}";
            boolean bl = hasHashtableStats = stats.getJoinNodeStatsEstimate().getJoinBuildKeyCount() > 0.0 || stats.getJoinNodeStatsEstimate().getNullJoinBuildKeyCount() > 0.0;
            if (hasHashtableStats) {
                formatStr = "{source: %s, rows: %s (%s), cpu: %s, memory: %s, network: %s, hashtable size: %s, hashtable null: %s}";
            }
            output.append(String.format(formatStr, stats.getSourceInfo().getClass().getSimpleName(), TextRenderer.formatAsLong(stats.getOutputRowCount()), TextRenderer.formatEstimateAsDataSize(stats.getOutputSizeInBytes(plan.getPlanNodeRoot())), TextRenderer.formatDouble(cost.getCpuCost()), TextRenderer.formatDouble(cost.getMaxMemory()), TextRenderer.formatDouble(cost.getNetworkCost()), hasHashtableStats ? TextRenderer.formatDouble(stats.getJoinNodeStatsEstimate().getJoinBuildKeyCount()) : "", hasHashtableStats ? TextRenderer.formatDouble(stats.getJoinNodeStatsEstimate().getNullJoinBuildKeyCount()) : ""));
            if (i >= estimateCount - 1) continue;
            output.append("/");
        }
        output.append("\n");
        return output.toString();
    }

    public static String formatEstimateAsDataSize(double value) {
        return Double.isNaN(value) ? "?" : DataSize.succinctBytes((long)((long)value)).toString();
    }

    public static String formatAsLong(double value) {
        if (Double.isFinite(value)) {
            return String.format(Locale.US, "%d", Math.round(value));
        }
        return "?";
    }

    public static String formatDouble(double value) {
        if (Double.isFinite(value)) {
            return String.format(Locale.US, "%.2f", value);
        }
        return "?";
    }

    static String formatPositions(long positions) {
        String noun = positions == 1L ? "row" : "rows";
        return positions + " " + noun;
    }

    static String indentString(int indent) {
        return Strings.repeat((String)"    ", (int)indent);
    }

    private static String indentMultilineString(String string, int level) {
        return string.replaceAll("(?m)^", TextRenderer.indentString(level));
    }

    private String optimizerInfoToText(List<PlanOptimizerInformation> planOptimizerInfo) {
        List applicableOptimizers = planOptimizerInfo.stream().filter(x -> !x.getOptimizerTriggered() && x.getOptimizerApplicable().isPresent() && (Boolean)x.getOptimizerApplicable().get() != false).map(x -> x.getOptimizerName()).collect(Collectors.toList());
        List triggeredOptimizers = planOptimizerInfo.stream().filter(x -> x.getOptimizerTriggered()).map(x -> x.getOptimizerName()).collect(Collectors.toList());
        String triggered = "Triggered optimizers: [" + String.join((CharSequence)", ", triggeredOptimizers) + "]\n";
        String applicable = "Applicable optimizers: [" + String.join((CharSequence)", ", applicableOptimizers) + "]\n";
        return triggered + applicable;
    }

    private String cteInformationToText(List<CTEInformation> cteInformationList) {
        List cteInfo = cteInformationList.stream().map(x -> x.getCteName() + ": " + x.getNumberOfReferences() + " (is_view: " + x.getIsView() + ")").collect(Collectors.toList());
        return "CTEInfo: [" + String.join((CharSequence)", ", cteInfo) + "]\n";
    }

    private String optimizerResultsToText(List<OptimizerResult> optimizerResults) {
        StringBuilder builder = new StringBuilder();
        optimizerResults.forEach(opt -> {
            builder.append(opt.getOptimizer() + " (before):\n");
            builder.append(opt.getOldNode() + "\n");
            builder.append(opt.getOptimizer() + " (after):\n");
            builder.append(opt.getNewNode() + "\n");
        });
        return builder.toString();
    }
}

