/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.Serialization;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.planPrinter.NodeRepresentation;
import com.facebook.presto.sql.planner.planPrinter.PlanRepresentation;
import com.facebook.presto.sql.planner.planPrinter.Renderer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Provider;

public class JsonRenderer
implements Renderer<String> {
    private static JsonCodec<JsonRenderedNode> codec = JsonCodec.jsonCodec(JsonRenderedNode.class);
    private static JsonCodec<Map<PlanFragmentId, JsonPlanFragment>> planMapCodec = JsonCodec.mapJsonCodec(PlanFragmentId.class, JsonPlanFragment.class);

    public JsonRenderer(FunctionAndTypeManager functionAndTypeManager) {
        JsonObjectMapperProvider provider = new JsonObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(VariableReferenceExpression.class, (Object)((Object)new Serialization.VariableReferenceExpressionSerializer())));
        provider.setKeyDeserializers((Map)ImmutableMap.of(VariableReferenceExpression.class, (Object)((Object)new Serialization.VariableReferenceExpressionDeserializer(functionAndTypeManager))));
        JsonCodecFactory codecFactory = new JsonCodecFactory((Provider)provider, true);
        codec = codecFactory.jsonCodec(JsonRenderedNode.class);
        planMapCodec = codecFactory.mapJsonCodec(PlanFragmentId.class, JsonPlanFragment.class);
    }

    @Override
    public String render(PlanRepresentation plan) {
        return codec.toJson((Object)this.renderJson(plan, plan.getRoot()));
    }

    public String render(Map<PlanFragmentId, JsonPlanFragment> fragmentJsonMap) {
        return planMapCodec.toJson(fragmentJsonMap);
    }

    @VisibleForTesting
    public JsonRenderedNode renderJson(PlanRepresentation plan, NodeRepresentation node) {
        List children = (List)node.getChildren().stream().map(plan::getNode).filter(Optional::isPresent).map(Optional::get).map(n -> this.renderJson(plan, (NodeRepresentation)n)).collect(ImmutableList.toImmutableList());
        return new JsonRenderedNode(node.getSourceLocation(), node.getId().toString(), node.getName(), node.getIdentifier(), node.getDetails(), children, (List)node.getRemoteSources().stream().map(PlanFragmentId::toString).collect(ImmutableList.toImmutableList()), node.getEstimatedStats());
    }

    public static class JsonPlanFragment {
        @JsonRawValue
        private final String plan;

        @JsonCreator
        public JsonPlanFragment(String plan) {
            this.plan = plan;
        }

        @JsonProperty
        public String getPlan() {
            return this.plan;
        }
    }

    public static class JsonRenderedNode {
        private final Optional<SourceLocation> sourceLocation;
        private final String id;
        private final String name;
        private final String identifier;
        private final String details;
        private final List<JsonRenderedNode> children;
        private final List<String> remoteSources;
        private final List<PlanNodeStatsEstimate> estimates;

        @JsonCreator
        public JsonRenderedNode(Optional<SourceLocation> sourceLocation, String id, String name, String identifier, String details, List<JsonRenderedNode> children, List<String> remoteSources, List<PlanNodeStatsEstimate> estimates) {
            this.sourceLocation = sourceLocation;
            this.id = Objects.requireNonNull(id, "id is null");
            this.name = Objects.requireNonNull(name, "name is null");
            this.identifier = Objects.requireNonNull(identifier, "identifier is null");
            this.details = Objects.requireNonNull(details, "details is null");
            this.children = Objects.requireNonNull(children, "children is null");
            this.remoteSources = Objects.requireNonNull(remoteSources, "id is null");
            this.estimates = Objects.requireNonNull(estimates, "estimate is null");
        }

        @JsonProperty
        public Optional<SourceLocation> getSourceLocation() {
            return this.sourceLocation;
        }

        @JsonProperty
        public String getId() {
            return this.id;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public String getIdentifier() {
            return this.identifier;
        }

        @JsonProperty
        public String getDetails() {
            return this.details;
        }

        @JsonProperty
        public List<JsonRenderedNode> getChildren() {
            return this.children;
        }

        @JsonProperty
        public List<String> getRemoteSources() {
            return this.remoteSources;
        }

        @JsonProperty
        public List<PlanNodeStatsEstimate> getEstimates() {
            return this.estimates;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            JsonRenderedNode other = (JsonRenderedNode)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.id, other.id) && Objects.equals(this.sourceLocation, other.sourceLocation) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.details, other.details) && Objects.equals(this.children, other.children) && Objects.equals(this.estimates, other.estimates) && Objects.equals(this.remoteSources, other.remoteSources);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.id, this.sourceLocation, this.identifier, this.details, this.children, this.estimates, this.remoteSources);
        }
    }
}

