/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.planPrinter.OperatorHashCollisionsStats;
import com.facebook.presto.sql.planner.planPrinter.OperatorInputStats;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class HashCollisionPlanNodeStats
extends PlanNodeStats {
    private final Map<String, OperatorHashCollisionsStats> operatorHashCollisionsStats;

    public HashCollisionPlanNodeStats(PlanNodeId planNodeId, Duration planNodeScheduledTime, Duration planNodeCpuTime, long planNodeInputPositions, DataSize planNodeInputDataSize, long planNodeRawInputPositions, DataSize planNodeRawInputDataSize, long planNodeOutputPositions, DataSize planNodeOutputDataSize, Map<String, OperatorInputStats> operatorInputStats, long planNodeNullJoinBuildKeyCount, long planNodeJoinBuildKeyCount, Map<String, OperatorHashCollisionsStats> operatorHashCollisionsStats) {
        super(planNodeId, planNodeScheduledTime, planNodeCpuTime, planNodeInputPositions, planNodeInputDataSize, planNodeRawInputPositions, planNodeRawInputDataSize, planNodeOutputPositions, planNodeOutputDataSize, operatorInputStats, planNodeNullJoinBuildKeyCount, planNodeJoinBuildKeyCount);
        this.operatorHashCollisionsStats = Objects.requireNonNull(operatorHashCollisionsStats, "operatorHashCollisionsStats is null");
    }

    public Map<String, Double> getOperatorHashCollisionsAverages() {
        return this.operatorHashCollisionsStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OperatorHashCollisionsStats)entry.getValue()).getWeightedHashCollisions() / (double)((OperatorInputStats)this.operatorInputStats.get(entry.getKey())).getInputPositions()));
    }

    public Map<String, Double> getOperatorHashCollisionsStdDevs() {
        return this.operatorHashCollisionsStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> HashCollisionPlanNodeStats.computedWeightedStdDev(((OperatorHashCollisionsStats)entry.getValue()).getWeightedSumSquaredHashCollisions(), ((OperatorHashCollisionsStats)entry.getValue()).getWeightedHashCollisions(), ((OperatorInputStats)this.operatorInputStats.get(entry.getKey())).getInputPositions())));
    }

    private static double computedWeightedStdDev(double sumSquared, double sum, double totalWeight) {
        double average = sum / totalWeight;
        double variance = (sumSquared - 2.0 * sum * average) / totalWeight + average * average;
        return Math.sqrt(Math.max(variance, 0.0));
    }

    public Map<String, Double> getOperatorExpectedCollisionsAverages() {
        return this.operatorHashCollisionsStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OperatorHashCollisionsStats)entry.getValue()).getWeightedExpectedHashCollisions() / (double)((OperatorInputStats)this.operatorInputStats.get(entry.getKey())).getInputPositions()));
    }

    @Override
    public PlanNodeStats mergeWith(PlanNodeStats other) {
        Preconditions.checkArgument((boolean)(other instanceof HashCollisionPlanNodeStats), (Object)"other is not an instanceof HashCollisionPlanNodeStats");
        PlanNodeStats merged = super.mergeWith(other);
        return new HashCollisionPlanNodeStats(merged.getPlanNodeId(), merged.getPlanNodeScheduledTime(), merged.getPlanNodeCpuTime(), merged.getPlanNodeInputPositions(), merged.getPlanNodeInputDataSize(), merged.getPlanNodeRawInputPositions(), merged.getPlanNodeRawInputDataSize(), merged.getPlanNodeOutputPositions(), merged.getPlanNodeOutputDataSize(), merged.operatorInputStats, merged.getPlanNodeNullJoinBuildKeyCount(), merged.getPlanNodeJoinBuildKeyCount(), this.operatorHashCollisionsStats);
    }
}

