/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RemoteSourceNode
extends InternalPlanNode {
    private final List<PlanFragmentId> sourceFragmentIds;
    private final List<VariableReferenceExpression> outputVariables;
    private final boolean ensureSourceOrdering;
    private final Optional<OrderingScheme> orderingScheme;
    private final ExchangeNode.Type exchangeType;

    public RemoteSourceNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, List<PlanFragmentId> sourceFragmentIds, List<VariableReferenceExpression> outputVariables, boolean ensureSourceOrdering, Optional<OrderingScheme> orderingScheme, ExchangeNode.Type exchangeType) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.sourceFragmentIds = sourceFragmentIds;
        this.outputVariables = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.ensureSourceOrdering = ensureSourceOrdering;
        this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.exchangeType = Objects.requireNonNull(exchangeType, "exchangeType is null");
    }

    @JsonCreator
    public RemoteSourceNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sourceFragmentIds") List<PlanFragmentId> sourceFragmentIds, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="ensureSourceOrdering") boolean ensureSourceOrdering, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme, @JsonProperty(value="exchangeType") ExchangeNode.Type exchangeType) {
        this(sourceLocation, id, Optional.empty(), sourceFragmentIds, outputVariables, ensureSourceOrdering, orderingScheme, exchangeType);
    }

    public RemoteSourceNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, PlanFragmentId sourceFragmentId, List<VariableReferenceExpression> outputVariables, boolean ensureSourceOrdering, Optional<OrderingScheme> orderingScheme, ExchangeNode.Type exchangeType) {
        this(sourceLocation, id, (List<PlanFragmentId>)ImmutableList.of((Object)sourceFragmentId), outputVariables, ensureSourceOrdering, orderingScheme, exchangeType);
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public List<PlanFragmentId> getSourceFragmentIds() {
        return this.sourceFragmentIds;
    }

    @JsonProperty
    public boolean isEnsureSourceOrdering() {
        return this.ensureSourceOrdering;
    }

    @JsonProperty
    public Optional<OrderingScheme> getOrderingScheme() {
        return this.orderingScheme;
    }

    @JsonProperty
    public ExchangeNode.Type getExchangeType() {
        return this.exchangeType;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitRemoteSource(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new RemoteSourceNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.sourceFragmentIds, this.outputVariables, this.ensureSourceOrdering, this.orderingScheme, this.exchangeType);
    }
}

