/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public class WindowFilterPushDown
implements PlanOptimizer {
    private final Metadata metadata;
    private final RowExpressionDomainTranslator domainTranslator;
    private final LogicalRowExpressions logicalRowExpressions;

    public WindowFilterPushDown(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.domainTranslator = new RowExpressionDomainTranslator(metadata);
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(metadata.getFunctionAndTypeManager()), (StandardFunctionResolution)new FunctionResolution(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()), (FunctionMetadataManager)metadata.getFunctionAndTypeManager());
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, this.metadata, this.domainTranslator, this.logicalRowExpressions, session), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final RowExpressionDomainTranslator domainTranslator;
        private final LogicalRowExpressions logicalRowExpressions;
        private final Session session;

        private Rewriter(PlanNodeIdAllocator idAllocator, Metadata metadata, RowExpressionDomainTranslator domainTranslator, LogicalRowExpressions logicalRowExpressions, Session session) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
            this.logicalRowExpressions = logicalRowExpressions;
            this.session = Objects.requireNonNull(session, "session is null");
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Preconditions.checkState((node.getWindowFunctions().size() == 1 ? 1 : 0) != 0, (Object)"WindowFilterPushdown requires that WindowNodes contain exactly one window function");
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            if (Rewriter.canReplaceWithRowNumber(node, this.metadata.getFunctionAndTypeManager())) {
                return new RowNumberNode(rewrittenSource.getSourceLocation(), this.idAllocator.getNextId(), rewrittenSource, node.getPartitionBy(), (VariableReferenceExpression)Iterables.getOnlyElement(node.getWindowFunctions().keySet()), Optional.empty(), false, Optional.empty());
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)rewrittenSource));
        }

        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (node.getCount() > Integer.MAX_VALUE) {
                return context.defaultRewrite((PlanNode)node);
            }
            PlanNode source = context.rewrite(node.getSource());
            int limit = Math.toIntExact(node.getCount());
            if (source instanceof RowNumberNode) {
                RowNumberNode rowNumberNode = Rewriter.mergeLimit((RowNumberNode)source, limit);
                if (rowNumberNode.getPartitionBy().isEmpty()) {
                    return rowNumberNode;
                }
                source = rowNumberNode;
            } else if (source instanceof WindowNode && Rewriter.canOptimizeWindowFunction((WindowNode)source, this.metadata.getFunctionAndTypeManager()) && SystemSessionProperties.isOptimizeTopNRowNumber(this.session)) {
                WindowNode windowNode = (WindowNode)source;
                Verify.verify((boolean)windowNode.getOrderingScheme().isPresent());
                TopNRowNumberNode topNRowNumberNode = this.convertToTopNRowNumber(windowNode, limit);
                if (windowNode.getPartitionBy().isEmpty()) {
                    return topNRowNumberNode;
                }
                source = topNRowNumberNode;
            }
            return ChildReplacer.replaceChildren((PlanNode)node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            WindowNode windowNode;
            VariableReferenceExpression rowNumberVariable;
            OptionalInt upperBound;
            PlanNode source = context.rewrite(node.getSource());
            TupleDomain tupleDomain = this.domainTranslator.fromPredicate(this.session.toConnectorSession(), node.getPredicate()).getTupleDomain();
            if (source instanceof RowNumberNode) {
                VariableReferenceExpression rowNumberVariable2 = ((RowNumberNode)source).getRowNumberVariable();
                OptionalInt upperBound2 = Rewriter.extractUpperBound((TupleDomain<VariableReferenceExpression>)tupleDomain, rowNumberVariable2);
                if (upperBound2.isPresent()) {
                    source = Rewriter.mergeLimit((RowNumberNode)source, upperBound2.getAsInt());
                    return this.rewriteFilterSource(node, source, rowNumberVariable2, upperBound2.getAsInt());
                }
            } else if (source instanceof WindowNode && Rewriter.canOptimizeWindowFunction((WindowNode)source, this.metadata.getFunctionAndTypeManager()) && SystemSessionProperties.isOptimizeTopNRowNumber(this.session) && (upperBound = Rewriter.extractUpperBound((TupleDomain<VariableReferenceExpression>)tupleDomain, rowNumberVariable = (VariableReferenceExpression)Iterables.getOnlyElement((windowNode = (WindowNode)source).getCreatedVariable()))).isPresent()) {
                source = this.convertToTopNRowNumber(windowNode, upperBound.getAsInt());
                return this.rewriteFilterSource(node, source, rowNumberVariable, upperBound.getAsInt());
            }
            return ChildReplacer.replaceChildren((PlanNode)node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        private PlanNode rewriteFilterSource(FilterNode filterNode, PlanNode source, VariableReferenceExpression rowNumberVariable, int upperBound) {
            DomainTranslator.ExtractionResult<VariableReferenceExpression> extractionResult = this.domainTranslator.fromPredicate(this.session.toConnectorSession(), filterNode.getPredicate());
            TupleDomain tupleDomain = extractionResult.getTupleDomain();
            if (!Rewriter.isEqualRange((TupleDomain<VariableReferenceExpression>)tupleDomain, rowNumberVariable, upperBound)) {
                return new FilterNode(filterNode.getSourceLocation(), filterNode.getId(), source, filterNode.getPredicate());
            }
            Map<VariableReferenceExpression, Domain> newDomains = ((Map)tupleDomain.getDomains().get()).entrySet().stream().filter(entry -> !((VariableReferenceExpression)entry.getKey()).equals((Object)rowNumberVariable)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            TupleDomain newTupleDomain = TupleDomain.withColumnDomains(newDomains);
            RowExpression newPredicate = this.logicalRowExpressions.combineConjuncts(new RowExpression[]{extractionResult.getRemainingExpression(), this.domainTranslator.toPredicate(newTupleDomain)});
            if (newPredicate.equals((Object)LogicalRowExpressions.TRUE_CONSTANT)) {
                return source;
            }
            return new FilterNode(filterNode.getSourceLocation(), filterNode.getId(), source, newPredicate);
        }

        private static boolean isEqualRange(TupleDomain<VariableReferenceExpression> tupleDomain, VariableReferenceExpression variable, long upperBound) {
            if (tupleDomain.isNone()) {
                return false;
            }
            Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(variable);
            return domain.getValues().equals(ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)domain.getType(), (Object)upperBound), (Range[])new Range[0]));
        }

        private static OptionalInt extractUpperBound(TupleDomain<VariableReferenceExpression> tupleDomain, VariableReferenceExpression variable) {
            if (tupleDomain.isNone()) {
                return OptionalInt.empty();
            }
            Domain rowNumberDomain = (Domain)((Map)tupleDomain.getDomains().get()).get(variable);
            if (rowNumberDomain == null) {
                return OptionalInt.empty();
            }
            ValueSet values = rowNumberDomain.getValues();
            if (values.isAll() || values.isNone() || values.getRanges().getRangeCount() <= 0) {
                return OptionalInt.empty();
            }
            Range span = values.getRanges().getSpan();
            if (span.isHighUnbounded()) {
                return OptionalInt.empty();
            }
            Verify.verify((boolean)rowNumberDomain.getType().equals(BigintType.BIGINT));
            long upperBound = (Long)span.getHighBoundedValue();
            if (span.getHigh().getBound() == Marker.Bound.BELOW) {
                --upperBound;
            }
            if (upperBound > 0L && upperBound <= Integer.MAX_VALUE) {
                return OptionalInt.of(Math.toIntExact(upperBound));
            }
            return OptionalInt.empty();
        }

        private static RowNumberNode mergeLimit(RowNumberNode node, int newRowCountPerPartition) {
            if (node.getMaxRowCountPerPartition().isPresent()) {
                newRowCountPerPartition = Math.min(node.getMaxRowCountPerPartition().get(), newRowCountPerPartition);
            }
            return new RowNumberNode(node.getSourceLocation(), node.getId(), node.getSource(), node.getPartitionBy(), node.getRowNumberVariable(), Optional.of(newRowCountPerPartition), false, node.getHashVariable());
        }

        private TopNRowNumberNode convertToTopNRowNumber(WindowNode windowNode, int limit) {
            return new TopNRowNumberNode(windowNode.getSourceLocation(), this.idAllocator.getNextId(), windowNode.getSource(), windowNode.getSpecification(), (VariableReferenceExpression)Iterables.getOnlyElement(windowNode.getCreatedVariable()), limit, false, Optional.empty());
        }

        private static boolean canReplaceWithRowNumber(WindowNode node, FunctionAndTypeManager functionAndTypeManager) {
            return Rewriter.canOptimizeWindowFunction(node, functionAndTypeManager) && !node.getOrderingScheme().isPresent();
        }

        private static boolean canOptimizeWindowFunction(WindowNode node, FunctionAndTypeManager functionAndTypeManager) {
            if (node.getWindowFunctions().size() != 1) {
                return false;
            }
            VariableReferenceExpression rowNumberVariable = (VariableReferenceExpression)Iterables.getOnlyElement(node.getWindowFunctions().keySet());
            return Rewriter.isRowNumberMetadata(functionAndTypeManager, functionAndTypeManager.getFunctionMetadata(node.getWindowFunctions().get(rowNumberVariable).getFunctionHandle()));
        }

        private static boolean isRowNumberMetadata(FunctionAndTypeManager functionAndTypeManager, FunctionMetadata functionMetadata) {
            FunctionHandle rowNumberFunction = functionAndTypeManager.lookupFunction("row_number", (List<TypeSignatureProvider>)ImmutableList.of());
            return functionMetadata.equals((Object)functionAndTypeManager.getFunctionMetadata(rowNumberFunction));
        }
    }
}

