/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.TypeProvider;

public interface PlanOptimizer {
    public PlanNode optimize(PlanNode var1, Session var2, TypeProvider var3, VariableAllocator var4, PlanNodeIdAllocator var5, WarningCollector var6);

    default public boolean isEnabled(Session session) {
        return true;
    }

    default public void setEnabledForTesting(boolean isSet) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean isApplicable(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        this.setEnabledForTesting(true);
        boolean isApplicable = false;
        try {
            PlanNode newPlan = this.optimize(plan, session, types, variableAllocator, idAllocator, warningCollector);
            isApplicable = !plan.equals(newPlan);
            return isApplicable;
        }
        finally {
            this.setEnabledForTesting(false);
            return isApplicable;
        }
    }
}

