/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PayloadJoinOptimizer
implements PlanOptimizer {
    private final Metadata metadata;
    private boolean isEnabledForTesting;

    public PayloadJoinOptimizer(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        FunctionAndTypeManager functionAndTypeManager = this.metadata.getFunctionAndTypeManager();
        if (this.isEnabled(session)) {
            PlanNode result = SimplePlanRewriter.rewriteWith(new Rewriter(session, this.metadata, types, functionAndTypeManager, idAllocator, variableAllocator), plan, new JoinContext());
            return result;
        }
        return plan;
    }

    @Override
    public void setEnabledForTesting(boolean isSet) {
        this.isEnabledForTesting = isSet;
    }

    @Override
    public boolean isEnabled(Session session) {
        return this.isEnabledForTesting || SystemSessionProperties.isOptimizePayloadJoins(session);
    }

    private static RowExpression zeroForType(Type type) {
        Preconditions.checkArgument((TypeUtils.isNumericType((Type)type) || type instanceof VarcharType ? 1 : 0) != 0, (Object)"join key should be of numeric or varchar type");
        if (TypeUtils.isNumericType((Type)type)) {
            return Expressions.constant(0L, (Type)BigintType.BIGINT);
        }
        return Expressions.constant(Slices.utf8Slice((String)""), (Type)VarcharType.VARCHAR);
    }

    private static class JoinContext {
        private final Set<VariableReferenceExpression> joinKeys = new HashSet<VariableReferenceExpression>();
        private Map<VariableReferenceExpression, VariableReferenceExpression> joinKeyMap;
        private Map<VariableReferenceExpression, RowExpression> projectionsToPush = new HashMap<VariableReferenceExpression, RowExpression>();
        int numJoins;
        PlanNode payloadNode;

        public Set<VariableReferenceExpression> getJoinKeys() {
            return this.joinKeys;
        }

        public void addKeys(ImmutableSet<VariableReferenceExpression> keys) {
            this.joinKeys.addAll((Collection<VariableReferenceExpression>)keys);
        }

        public Map<VariableReferenceExpression, RowExpression> getProjectionsToPush() {
            return this.projectionsToPush;
        }

        public void addProjectionsToPush(Map<VariableReferenceExpression, RowExpression> map) {
            this.projectionsToPush.putAll(map);
        }

        public Map<VariableReferenceExpression, VariableReferenceExpression> getJoinKeyMap() {
            return this.joinKeyMap;
        }

        public void setJoinKeyMap(Map<VariableReferenceExpression, VariableReferenceExpression> map) {
            this.joinKeyMap = map;
        }

        public PlanNode getPayloadNode() {
            return this.payloadNode;
        }

        public void setPayloadNode(PlanNode payloadNode) {
            this.payloadNode = payloadNode;
        }

        public int getNumJoins() {
            return this.numJoins;
        }

        public void incrementNumJoins() {
            ++this.numJoins;
        }

        public boolean needsPayloadRejoin() {
            return this.payloadNode != null;
        }
    }

    private static class Rewriter
    extends SimplePlanRewriter<JoinContext> {
        private final Session session;
        Metadata metadata;
        private final TypeProvider types;
        private final FunctionAndTypeManager functionAndTypeManager;
        private final PlanNodeIdAllocator planNodeIdAllocator;
        private final VariableAllocator variableAllocator;

        private Rewriter(Session session, Metadata metadata, TypeProvider types, FunctionAndTypeManager functionAndTypeManager, PlanNodeIdAllocator planNodeIdAllocator, VariableAllocator variableAllocator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
            this.planNodeIdAllocator = Objects.requireNonNull(planNodeIdAllocator, "planNodeIdAllocator is null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        }

        private Set<VariableReferenceExpression> extractPayloadColumns(ImmutableSet<VariableReferenceExpression> columns) {
            return (Set)columns.stream().filter(var -> var.getType() instanceof MapType || var.getType() instanceof ArrayType).collect(ImmutableSet.toImmutableSet());
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<JoinContext> context) {
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitJoin(JoinNode joinNode, SimplePlanRewriter.RewriteContext<JoinContext> context) {
            JoinContext joinContext = context.get();
            int numJoinKeys = joinContext.getJoinKeys().size();
            PlanNode leftNode = joinNode.getLeft();
            PlanNode rightNode = joinNode.getRight();
            boolean isTopJoin = numJoinKeys == 0;
            ImmutableSet leftColumns = (ImmutableSet)leftNode.getOutputVariables().stream().collect(ImmutableSet.toImmutableSet());
            Set<VariableReferenceExpression> joinKeys = this.extractJoinKeys(joinNode.getFilter(), joinNode.getCriteria());
            ImmutableSet leftJoinKeys = Sets.intersection(joinKeys, (Set)leftColumns).immutableCopy();
            if (!this.needsRewrite(joinNode.getType(), (ImmutableSet<VariableReferenceExpression>)leftColumns, (Set<VariableReferenceExpression>)leftJoinKeys)) {
                return context.defaultRewrite(joinNode, joinContext);
            }
            joinContext.addKeys((ImmutableSet<VariableReferenceExpression>)leftJoinKeys);
            joinContext.incrementNumJoins();
            PlanNode newLeftNode = context.rewrite(leftNode, joinContext);
            if (leftNode == newLeftNode) {
                newLeftNode = context.rewrite(leftNode, new JoinContext());
                return joinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)newLeftNode, (Object)rightNode));
            }
            List leftCols = newLeftNode.getOutputVariables();
            List rightCols = rightNode.getOutputVariables();
            List allCols = (List)Stream.concat(leftCols.stream(), rightCols.stream()).collect(ImmutableList.toImmutableList());
            JoinNode newJoinNode = new JoinNode(joinNode.getSourceLocation(), this.planNodeIdAllocator.getNextId(), joinNode.getType(), newLeftNode, rightNode, joinNode.getCriteria(), allCols, joinNode.getFilter(), joinNode.getLeftHashVariable(), joinNode.getRightHashVariable(), joinNode.getDistributionType(), joinNode.getDynamicFilters());
            if (isTopJoin && context.get().needsPayloadRejoin()) {
                PlanNode payloadJoin = this.transformJoin(newJoinNode, joinContext);
                if (!payloadJoin.getOutputVariables().containsAll(joinNode.getOutputVariables())) {
                    return joinNode;
                }
                return payloadJoin;
            }
            return newJoinNode;
        }

        private boolean needsRewrite(JoinNode.Type joinType, ImmutableSet<VariableReferenceExpression> leftColumns, Set<VariableReferenceExpression> joinKeys) {
            if (joinType == JoinNode.Type.LEFT && this.supportedJoinKeyTypes(joinKeys)) {
                Set<VariableReferenceExpression> leftPayloadColumns = this.extractPayloadColumns(leftColumns);
                return !leftPayloadColumns.isEmpty() && !leftPayloadColumns.containsAll(joinKeys);
            }
            return false;
        }

        public PlanNode visitProject(ProjectNode projectNode, SimplePlanRewriter.RewriteContext<JoinContext> context) {
            PlanNode newChild;
            if (PlannerUtils.isScanFilterProject((PlanNode)projectNode)) {
                return this.rewriteScanFilterProject((PlanNode)projectNode, context);
            }
            PlanNode child = projectNode.getSource();
            Set<VariableReferenceExpression> joinKeys = context.get().getJoinKeys();
            Assignments newAssignments = projectNode.getAssignments();
            if (!child.getOutputVariables().containsAll(joinKeys)) {
                Assignments.Builder assignments = Assignments.builder();
                HashMap<VariableReferenceExpression, RowExpression> pushableExpressions = new HashMap<VariableReferenceExpression, RowExpression>();
                projectNode.getAssignments().forEach((var, expr) -> {
                    if (joinKeys.contains(var) && !var.equals(expr)) {
                        assignments.put(var, (RowExpression)var);
                        pushableExpressions.put((VariableReferenceExpression)var, (RowExpression)expr);
                    } else {
                        assignments.put(var, expr);
                    }
                });
                newAssignments = assignments.build();
                context.get().addProjectionsToPush(pushableExpressions);
            }
            if (child.equals(newChild = context.rewrite(child, context.get()))) {
                return projectNode;
            }
            Set newChildOutputVarSet = (Set)newChild.getOutputVariables().stream().collect(ImmutableSet.toImmutableSet());
            Assignments newProjectAssighments = this.removeHiddenColumns(newAssignments, newChildOutputVarSet, context.get().getJoinKeys());
            ProjectNode newProjectNode = new ProjectNode(projectNode.getId(), newChild, newProjectAssighments);
            return this.validateProjectAssignments(newProjectNode) ? newProjectNode : projectNode;
        }

        public PlanNode visitFilter(FilterNode filterNode, SimplePlanRewriter.RewriteContext<JoinContext> context) {
            Set<VariableReferenceExpression> joinKeys = context.get().getJoinKeys();
            List<VariableReferenceExpression> predicateVars = VariablesExtractor.extractAll(filterNode.getPredicate());
            if (PlannerUtils.isScanFilterProject((PlanNode)filterNode)) {
                return this.rewriteScanFilterProject((PlanNode)filterNode, context);
            }
            if (joinKeys.isEmpty() || joinKeys.containsAll(predicateVars)) {
                return context.defaultRewrite((PlanNode)filterNode, context.get());
            }
            return filterNode;
        }

        public PlanNode visitTableScan(TableScanNode scanNode, SimplePlanRewriter.RewriteContext<JoinContext> context) {
            return this.rewriteScanFilterProject((PlanNode)scanNode, context);
        }

        private PlanNode rewriteScanFilterProject(PlanNode planNode, SimplePlanRewriter.RewriteContext<JoinContext> context) {
            Set<VariableReferenceExpression> joinKeys = context.get().getJoinKeys();
            if (joinKeys.size() == 0 || context.get().getNumJoins() < 2) {
                return planNode;
            }
            List outputCols = planNode.getOutputVariables();
            if (!ImmutableSet.copyOf((Collection)planNode.getOutputVariables()).containsAll(joinKeys)) {
                Map<VariableReferenceExpression, RowExpression> projectionsToPush = context.get().getProjectionsToPush();
                if (!outputCols.containsAll(VariablesExtractor.extractUnique(projectionsToPush.values()))) {
                    return planNode;
                }
                PlanNode newProjectNode = PlannerUtils.addProjections(planNode, this.planNodeIdAllocator, context.get().getProjectionsToPush());
                return this.constructDistinctKeysPlan(newProjectNode, context, joinKeys);
            }
            return this.constructDistinctKeysPlan(planNode, context, joinKeys);
        }

        private AggregationNode constructDistinctKeysPlan(PlanNode planNode, SimplePlanRewriter.RewriteContext<JoinContext> context, Set<VariableReferenceExpression> joinKeys) {
            List groupingKeys = (List)joinKeys.stream().collect(ImmutableList.toImmutableList());
            AggregationNode agg = new AggregationNode(planNode.getSourceLocation(), this.planNodeIdAllocator.getNextId(), planNode, (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)groupingKeys), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
            HashMap<VariableReferenceExpression, VariableReferenceExpression> varMap = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
            for (VariableReferenceExpression var : joinKeys) {
                VariableReferenceExpression newVar = this.variableAllocator.newVariable(var.getName(), var.getType());
                varMap.put(var, newVar);
            }
            context.get().setJoinKeyMap(new HashMap<VariableReferenceExpression, VariableReferenceExpression>(varMap));
            PlanNode planNodeCopy = PlannerUtils.clonePlanNode(planNode, this.session, this.metadata, this.planNodeIdAllocator, planNode.getOutputVariables(), varMap);
            context.get().setPayloadNode(planNodeCopy);
            return agg;
        }

        private PlanNode transformJoin(JoinNode keysNode, JoinContext context) {
            PlanNode payloadPlanNode = context.getPayloadNode();
            Set<VariableReferenceExpression> joinKeys = context.getJoinKeys();
            Map<VariableReferenceExpression, VariableReferenceExpression> joinKeyMap = context.getJoinKeyMap();
            Preconditions.checkState((null != payloadPlanNode ? 1 : 0) != 0, (Object)"Payload plannode not initialized");
            Preconditions.checkState((null != joinKeyMap ? 1 : 0) != 0, (Object)"joinkey map not initialized");
            FunctionResolution functionResolution = new FunctionResolution(this.functionAndTypeManager.getFunctionAndTypeResolver());
            Assignments.Builder assignments = Assignments.builder();
            ImmutableList.Builder coalesceComparisonBuilder = ImmutableList.builder();
            ImmutableList.Builder nullComparisonBuilder = ImmutableList.builder();
            List<VariableReferenceExpression> joinOutputCols = keysNode.getOutputVariables();
            for (VariableReferenceExpression var : joinOutputCols) {
                assignments.put(var, (RowExpression)var);
            }
            for (VariableReferenceExpression var : joinKeys) {
                VariableReferenceExpression newVar = joinKeyMap.get(var);
                VariableReferenceExpression isNullVar = this.variableAllocator.newVariable(var.getName() + "_NULL", (Type)BooleanType.BOOLEAN);
                assignments.put(isNullVar, (RowExpression)Expressions.specialForm(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)var)));
                CallExpression coalesceComp = PlannerUtils.equalityPredicate(functionResolution, this.coalesceToZero((RowExpression)newVar), this.coalesceToZero((RowExpression)var));
                CallExpression nullComp = PlannerUtils.equalityPredicate(functionResolution, (RowExpression)Expressions.specialForm(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)newVar)), (RowExpression)isNullVar);
                nullComparisonBuilder.add((Object)nullComp);
                coalesceComparisonBuilder.add((Object)coalesceComp);
            }
            ProjectNode projectNode = new ProjectNode(this.planNodeIdAllocator.getNextId(), (PlanNode)keysNode, assignments.build());
            List resultOutputCols = (List)Stream.concat(payloadPlanNode.getOutputVariables().stream(), projectNode.getOutputVariables().stream()).collect(ImmutableList.toImmutableList());
            List joinCriteria = (List)Stream.concat(nullComparisonBuilder.build().stream(), coalesceComparisonBuilder.build().stream()).collect(ImmutableList.toImmutableList());
            return new JoinNode(keysNode.getSourceLocation(), this.planNodeIdAllocator.getNextId(), JoinNode.Type.LEFT, payloadPlanNode, (PlanNode)projectNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of(), resultOutputCols, Optional.of(LogicalRowExpressions.and((Collection)joinCriteria)), keysNode.getLeftHashVariable(), keysNode.getRightHashVariable(), keysNode.getDistributionType(), keysNode.getDynamicFilters());
        }

        private Assignments removeHiddenColumns(Assignments newAssignments, Set<VariableReferenceExpression> newChildOutputVarSet, Set<VariableReferenceExpression> joinKeys) {
            Map<VariableReferenceExpression, RowExpression> newAssignmentsMap = newAssignments.entrySet().stream().filter(assignment -> newChildOutputVarSet.containsAll(VariablesExtractor.extractUnique((RowExpression)assignment.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Set<VariableReferenceExpression> outputKeys = newAssignmentsMap.keySet();
            Map joinKeyMap = joinKeys.stream().filter(key -> !outputKeys.contains(key) && newChildOutputVarSet.contains(key)).collect(Collectors.toMap(Function.identity(), Function.identity()));
            newAssignmentsMap.putAll(joinKeyMap);
            return new Assignments(newAssignmentsMap);
        }

        private boolean validateProjectAssignments(ProjectNode projectNode) {
            Assignments assignments = projectNode.getAssignments();
            PlanNode input = projectNode.getSource();
            ImmutableSet inputColsSet = (ImmutableSet)input.getOutputVariables().stream().collect(ImmutableSet.toImmutableSet());
            for (Map.Entry assignment : assignments.entrySet()) {
                RowExpression expr = (RowExpression)assignment.getValue();
                if (inputColsSet.containsAll(VariablesExtractor.extractUnique(expr))) continue;
                return false;
            }
            return true;
        }

        private RowExpression coalesceToZero(RowExpression var) {
            RowExpression zero = PayloadJoinOptimizer.zeroForType(var.getType());
            return PlannerUtils.coalesce((List<RowExpression>)ImmutableList.of((Object)var, (Object)zero));
        }

        private Set<VariableReferenceExpression> extractJoinKeys(Optional<RowExpression> filter, List<JoinNode.EquiJoinClause> criteria) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            criteria.forEach(v -> {
                builder.add((Object)v.getLeft());
                builder.add((Object)v.getRight());
            });
            if (filter.isPresent()) {
                builder.addAll(VariablesExtractor.extractAll(filter.get()));
            }
            return builder.build();
        }

        private boolean supportedJoinKeyTypes(Set<VariableReferenceExpression> joinKeys) {
            return joinKeys.stream().allMatch(key -> key.getType() instanceof VarcharType || TypeUtils.isNumericType((Type)key.getType()));
        }
    }
}

