/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.FragmentTableScanCounter;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.PickTableLayout;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PreferredProperties;
import com.facebook.presto.sql.planner.optimizations.PropertyDerivations;
import com.facebook.presto.sql.planner.optimizations.SetOperationNodeUtils;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AddExchanges
implements PlanOptimizer {
    private final SqlParser parser;
    private final Metadata metadata;
    private final PartitioningProviderManager partitioningProviderManager;

    public AddExchanges(Metadata metadata, SqlParser parser, PartitioningProviderManager partitioningProviderManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.parser = Objects.requireNonNull(parser, "parser is null");
        this.partitioningProviderManager = Objects.requireNonNull(partitioningProviderManager, "partitioningProviderManager is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        PlanWithProperties result = new Rewriter(idAllocator, variableAllocator, session, this.partitioningProviderManager).accept(plan, PreferredProperties.any());
        return result.getNode();
    }

    private boolean canPushdownPartialMerge(PlanNode node, FeaturesConfig.PartialMergePushdownStrategy strategy) {
        switch (strategy) {
            case NONE: {
                return false;
            }
            case PUSH_THROUGH_LOW_MEMORY_OPERATORS: {
                return this.canPushdownPartialMergeThroughLowMemoryOperators(node);
            }
        }
        throw new UnsupportedOperationException("Unsupported PartialMergePushdownStrategy: " + (Object)((Object)strategy));
    }

    private boolean canPushdownPartialMergeThroughLowMemoryOperators(PlanNode node) {
        if (node instanceof TableScanNode) {
            return true;
        }
        if (node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE_MATERIALIZED) {
            return true;
        }
        if (node instanceof JoinNode || node instanceof AggregationNode || node instanceof SemiJoinNode) {
            return false;
        }
        return node.getSources().stream().allMatch(this::canPushdownPartialMergeThroughLowMemoryOperators);
    }

    public static Map<VariableReferenceExpression, VariableReferenceExpression> computeIdentityTranslations(Assignments assignments) {
        HashMap<VariableReferenceExpression, VariableReferenceExpression> outputToInput = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        for (Map.Entry assignment : assignments.getMap().entrySet()) {
            if (!(assignment.getValue() instanceof VariableReferenceExpression)) continue;
            outputToInput.put((VariableReferenceExpression)assignment.getKey(), (VariableReferenceExpression)assignment.getValue());
        }
        return outputToInput;
    }

    @VisibleForTesting
    static Comparator<ActualProperties> streamingExecutionPreference(PreferredProperties preferred) {
        LoadingCache matchCache = CacheBuilder.newBuilder().build(CacheLoader.from(actualProperties -> LocalProperties.match(actualProperties, preferred.getLocalProperties())));
        return (actual1, actual2) -> {
            List matchLayout1 = (List)matchCache.getUnchecked(actual1.getLocalProperties());
            List matchLayout2 = (List)matchCache.getUnchecked(actual2.getLocalProperties());
            return ComparisonChain.start().compareTrueFirst(AddExchanges.hasLocalOptimization(preferred.getLocalProperties(), matchLayout1), AddExchanges.hasLocalOptimization(preferred.getLocalProperties(), matchLayout2)).compareTrueFirst(AddExchanges.meetsPartitioningRequirements(preferred, actual1), AddExchanges.meetsPartitioningRequirements(preferred, actual2)).compare((Object)matchLayout1, (Object)matchLayout2, AddExchanges.matchedLayoutPreference()).result();
        };
    }

    private static <T> boolean hasLocalOptimization(List<LocalProperty<T>> desiredLayout, List<Optional<LocalProperty<T>>> matchResult) {
        Preconditions.checkArgument((desiredLayout.size() == matchResult.size() ? 1 : 0) != 0);
        if (matchResult.isEmpty()) {
            return false;
        }
        return !matchResult.get(0).equals(Optional.of(desiredLayout.get(0)));
    }

    private static boolean meetsPartitioningRequirements(PreferredProperties preferred, ActualProperties actual) {
        if (!preferred.getGlobalProperties().isPresent()) {
            return true;
        }
        PreferredProperties.Global preferredGlobal = preferred.getGlobalProperties().get();
        if (!preferredGlobal.isDistributed()) {
            return actual.isSingleNode();
        }
        if (!preferredGlobal.getPartitioningProperties().isPresent()) {
            return !actual.isSingleNode();
        }
        return actual.isStreamPartitionedOn(preferredGlobal.getPartitioningProperties().get().getPartitioningColumns(), false);
    }

    private static <T> Comparator<List<Optional<LocalProperty<T>>>> matchedLayoutPreference() {
        return (matchLayout1, matchLayout2) -> {
            Iterator match1Iterator = matchLayout1.iterator();
            Iterator match2Iterator = matchLayout2.iterator();
            while (match1Iterator.hasNext() && match2Iterator.hasNext()) {
                Optional match1 = (Optional)match1Iterator.next();
                Optional match2 = (Optional)match2Iterator.next();
                if (match1.isPresent() && match2.isPresent()) {
                    return Integer.compare(((LocalProperty)match1.get()).getColumns().size(), ((LocalProperty)match2.get()).getColumns().size());
                }
                if (match1.isPresent()) {
                    return 1;
                }
                if (!match2.isPresent()) continue;
                return -1;
            }
            Preconditions.checkState((!match1Iterator.hasNext() && !match2Iterator.hasNext() ? 1 : 0) != 0);
            return 0;
        };
    }

    private static boolean isSameOrSystemCompatiblePartitions(List<PartitioningHandle> partitioningHandles) {
        for (int i = 0; i < partitioningHandles.size() - 1; ++i) {
            PartitioningHandle second;
            PartitioningHandle first = partitioningHandles.get(i);
            if (first.equals(second = partitioningHandles.get(i + 1)) || SystemPartitioningHandle.isCompatibleSystemPartitioning(first, second)) continue;
            return false;
        }
        return true;
    }

    private static List<PartitioningHandle> extractRemoteExchangePartitioningHandles(List<PlanNode> nodes) {
        ImmutableList.Builder handles = ImmutableList.builder();
        nodes.forEach(node -> {
            Void cfr_ignored_0 = (Void)node.accept((PlanVisitor)new ExchangePartitioningHandleExtractor(), (Object)handles);
        });
        return handles.build();
    }

    private static class ExchangePartitioningHandleExtractor
    extends InternalPlanVisitor<Void, ImmutableList.Builder<PartitioningHandle>> {
        private ExchangePartitioningHandleExtractor() {
        }

        @Override
        public Void visitExchange(ExchangeNode node, ImmutableList.Builder<PartitioningHandle> handles) {
            Preconditions.checkArgument((boolean)node.getScope().isRemote(), (String)"scope is expected to be remote: %s", (Object)((Object)node.getScope()));
            handles.add((Object)node.getPartitioningScheme().getPartitioning().getHandle());
            return null;
        }

        public Void visitPlan(PlanNode node, ImmutableList.Builder<PartitioningHandle> handles) {
            for (PlanNode source : node.getSources()) {
                source.accept((PlanVisitor)this, handles);
            }
            return null;
        }
    }

    @VisibleForTesting
    static class PlanWithProperties {
        private final PlanNode node;
        private final ActualProperties properties;

        public PlanWithProperties(PlanNode node) {
            this(node, ActualProperties.builder().build());
        }

        public PlanWithProperties(PlanNode node, ActualProperties properties) {
            this.node = node;
            this.properties = properties;
        }

        public PlanNode getNode() {
            return this.node;
        }

        public ActualProperties getProperties() {
            return this.properties;
        }
    }

    private class Rewriter
    extends InternalPlanVisitor<PlanWithProperties, PreferredProperties> {
        private final PlanNodeIdAllocator idAllocator;
        private final VariableAllocator variableAllocator;
        private final TypeProvider types;
        private final Session session;
        private final boolean distributedIndexJoins;
        private final boolean preferStreamingOperators;
        private final boolean redistributeWrites;
        private final boolean scaleWriters;
        private final boolean preferDistributedUnion;
        private final FeaturesConfig.PartialMergePushdownStrategy partialMergePushdownStrategy;
        private final String partitioningProviderCatalog;
        private final int hashPartitionCount;
        private final QueryManagerConfig.ExchangeMaterializationStrategy exchangeMaterializationStrategy;
        private final PartitioningProviderManager partitioningProviderManager;

        public Rewriter(PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, Session session, PartitioningProviderManager partitioningProviderManager) {
            this.idAllocator = idAllocator;
            this.variableAllocator = variableAllocator;
            this.types = TypeProvider.viewOf(variableAllocator.getVariables());
            this.session = session;
            this.distributedIndexJoins = SystemSessionProperties.isDistributedIndexJoinEnabled(session);
            this.redistributeWrites = SystemSessionProperties.isRedistributeWrites(session);
            this.scaleWriters = SystemSessionProperties.isScaleWriters(session);
            this.preferDistributedUnion = SystemSessionProperties.isPreferDistributedUnion(session);
            this.partialMergePushdownStrategy = SystemSessionProperties.getPartialMergePushdownStrategy(session);
            this.preferStreamingOperators = SystemSessionProperties.preferStreamingOperators(session);
            this.partitioningProviderCatalog = SystemSessionProperties.getPartitioningProviderCatalog(session);
            this.hashPartitionCount = SystemSessionProperties.getHashPartitionCount(session);
            this.exchangeMaterializationStrategy = SystemSessionProperties.getExchangeMaterializationStrategy(session);
            this.partitioningProviderManager = Objects.requireNonNull(partitioningProviderManager, "partitioningProviderManager is null");
        }

        public PlanWithProperties visitPlan(PlanNode node, PreferredProperties preferredProperties) {
            return this.rebaseAndDeriveProperties(node, this.planChild(node, preferredProperties));
        }

        public PlanWithProperties visitProject(ProjectNode node, PreferredProperties preferredProperties) {
            Map<VariableReferenceExpression, VariableReferenceExpression> identities = AddExchanges.computeIdentityTranslations(node.getAssignments());
            PreferredProperties translatedPreferred = preferredProperties.translate(symbol -> Optional.ofNullable(identities.get(symbol)));
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild((PlanNode)node, translatedPreferred));
        }

        public PlanWithProperties visitOutput(OutputNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild((PlanNode)node, PreferredProperties.undistributed());
            if (!child.getProperties().isSingleNode() && SystemSessionProperties.isForceSingleNodeOutput(this.session)) {
                child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        public PlanWithProperties visitAggregation(AggregationNode node, PreferredProperties parentPreferredProperties) {
            PlanWithProperties child;
            PreferredProperties preferredProperties;
            ImmutableSet partitioningRequirement = ImmutableSet.copyOf((Collection)node.getGroupingKeys());
            boolean preferSingleNode = AggregationUtils.hasSingleNodeExecutionPreference(node, AddExchanges.this.metadata.getFunctionAndTypeManager());
            boolean hasMixedGroupingSets = node.hasEmptyGroupingSet() && node.hasNonEmptyGroupingSet();
            PreferredProperties preferredProperties2 = preferredProperties = preferSingleNode ? PreferredProperties.undistributed() : PreferredProperties.any();
            if (!node.getGroupingKeys().isEmpty() && !hasMixedGroupingSets) {
                FeaturesConfig.AggregationPartitioningMergingStrategy aggregationPartitioningMergingStrategy = SystemSessionProperties.getAggregationPartitioningMergingStrategy(this.session);
                preferredProperties = PreferredProperties.partitionedWithLocal((Set<VariableReferenceExpression>)partitioningRequirement, LocalProperties.grouped(node.getGroupingKeys())).mergeWithParent(parentPreferredProperties, this.shouldAggregationMergePartitionPreferences(aggregationPartitioningMergingStrategy));
                if (aggregationPartitioningMergingStrategy.isAdoptingMergedPreference()) {
                    Preconditions.checkState((preferredProperties.getGlobalProperties().isPresent() && preferredProperties.getGlobalProperties().get().getPartitioningProperties().isPresent() ? 1 : 0) != 0);
                    partitioningRequirement = ImmutableSet.copyOf(preferredProperties.getGlobalProperties().get().getPartitioningProperties().get().getPartitioningColumns());
                }
            }
            if ((child = this.planChild((PlanNode)node, preferredProperties)).getProperties().isSingleNode()) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (preferSingleNode) {
                child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            } else if (hasMixedGroupingSets || !this.isStreamPartitionedOn(child.getProperties(), (Collection<VariableReferenceExpression>)partitioningRequirement) && !this.isNodePartitionedOn(child.getProperties(), (Collection<VariableReferenceExpression>)partitioningRequirement)) {
                child = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(child.getNode(), false), child.getNode(), this.createPartitioning((Collection<VariableReferenceExpression>)partitioningRequirement), node.getHashVariable()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitGroupId(GroupIdNode node, PreferredProperties preferredProperties) {
            PreferredProperties childPreference = preferredProperties.translate(this.translateGroupIdVariables(node));
            PlanWithProperties child = this.planChild(node, childPreference);
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        private Function<VariableReferenceExpression, Optional<VariableReferenceExpression>> translateGroupIdVariables(GroupIdNode node) {
            return variable -> {
                if (node.getAggregationArguments().contains(variable)) {
                    return Optional.of(variable);
                }
                if (node.getCommonGroupingColumns().contains(variable)) {
                    return Optional.of(node.getGroupingColumns().get(variable));
                }
                return Optional.empty();
            };
        }

        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, PreferredProperties preferredProperties) {
            PreferredProperties preferredChildProperties = PreferredProperties.partitionedWithLocal((Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)node.getDistinctVariables()), LocalProperties.grouped(node.getDistinctVariables())).mergeWithParent(preferredProperties, !SystemSessionProperties.isExactPartitioningPreferred(this.session));
            PlanWithProperties child = this.accept(node.getSource(), preferredChildProperties);
            if (child.getProperties().isSingleNode() || !this.isStreamPartitionedOn(child.getProperties(), node.getDistinctVariables())) {
                child = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), SystemSessionProperties.isUseStreamingExchangeForMarkDistinctEnabled(this.session) ? ExchangeNode.Scope.REMOTE_STREAMING : this.selectExchangeScopeForPartitionedRemoteExchange(child.getNode(), false), child.getNode(), this.createPartitioning(node.getDistinctVariables()), node.getHashVariable()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, PreferredProperties preferredProperties) {
            ArrayList<GroupingProperty> desiredProperties = new ArrayList<GroupingProperty>();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            node.getOrderingScheme().ifPresent(orderingScheme -> orderingScheme.getOrderByVariables().stream().map(variable -> new SortingProperty(variable, orderingScheme.getOrdering(variable))).forEach(desiredProperties::add));
            PlanWithProperties child = this.planChild(node, PreferredProperties.partitionedWithLocal((Set<VariableReferenceExpression>)ImmutableSet.copyOf(node.getPartitionBy()), desiredProperties).mergeWithParent(preferredProperties, !SystemSessionProperties.isExactPartitioningPreferred(this.session)));
            if (!this.isStreamPartitionedOn(child.getProperties(), node.getPartitionBy()) && !this.isNodePartitionedOn(child.getProperties(), node.getPartitionBy())) {
                child = node.getPartitionBy().isEmpty() ? this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties()) : this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(child.getNode(), false), child.getNode(), this.createPartitioning(node.getPartitionBy()), node.getHashVariable()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, PreferredProperties preferredProperties) {
            Preconditions.checkArgument((!node.isPartial() ? 1 : 0) != 0, (Object)"RowNumberNode should not be partial before adding exchange");
            if (node.getPartitionBy().isEmpty()) {
                PlanWithProperties child = this.planChild(node, PreferredProperties.undistributed());
                if (!child.getProperties().isSingleNode()) {
                    if (node.getMaxRowCountPerPartition().isPresent() && SystemSessionProperties.isAddPartialNodeForRowNumberWithLimit(this.session)) {
                        child = this.withDerivedProperties((PlanNode)new RowNumberNode(node.getSourceLocation(), this.idAllocator.getNextId(), child.getNode(), node.getPartitionBy(), this.variableAllocator.newVariable(node.getRowNumberVariable()), node.getMaxRowCountPerPartition(), true, node.getHashVariable()), child.getProperties());
                    }
                    child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
                }
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            PlanWithProperties child = this.planChild(node, PreferredProperties.partitionedWithLocal((Set<VariableReferenceExpression>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy())).mergeWithParent(preferredProperties, !SystemSessionProperties.isExactPartitioningPreferred(this.session)));
            if (!this.isStreamPartitionedOn(child.getProperties(), node.getPartitionBy()) && !this.isNodePartitionedOn(child.getProperties(), node.getPartitionBy())) {
                if (node.getMaxRowCountPerPartition().isPresent() && SystemSessionProperties.isAddPartialNodeForRowNumberWithLimit(this.session)) {
                    child = this.withDerivedProperties((PlanNode)new RowNumberNode(node.getSourceLocation(), this.idAllocator.getNextId(), child.getNode(), node.getPartitionBy(), this.variableAllocator.newVariable(node.getRowNumberVariable()), node.getMaxRowCountPerPartition(), true, node.getHashVariable()), child.getProperties());
                }
                child = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(child.getNode(), false), child.getNode(), this.createPartitioning(node.getPartitionBy()), node.getHashVariable()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTopNRowNumber(TopNRowNumberNode node, PreferredProperties preferredProperties) {
            Function<PlanNode, PlanNode> addExchange;
            PreferredProperties preferredChildProperties;
            if (node.getPartitionBy().isEmpty()) {
                preferredChildProperties = PreferredProperties.any();
                addExchange = partial -> ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, partial);
            } else {
                preferredChildProperties = PreferredProperties.partitionedWithLocal((Set<VariableReferenceExpression>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy())).mergeWithParent(preferredProperties, !SystemSessionProperties.isExactPartitioningPreferred(this.session));
                addExchange = partial -> ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange((PlanNode)partial, false), partial, this.createPartitioning(node.getPartitionBy()), node.getHashVariable());
            }
            PlanWithProperties child = this.planChild(node, preferredChildProperties);
            if (!this.isStreamPartitionedOn(child.getProperties(), node.getPartitionBy()) && !this.isNodePartitionedOn(child.getProperties(), node.getPartitionBy())) {
                child = this.withDerivedProperties((PlanNode)new TopNRowNumberNode(node.getSourceLocation(), this.idAllocator.getNextId(), child.getNode(), node.getSpecification(), node.getRowNumberVariable(), node.getMaxRowCountPerPartition(), true, node.getHashVariable()), child.getProperties());
                child = this.withDerivedProperties(addExchange.apply(child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        public PlanWithProperties visitTopN(TopNNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child;
            switch (node.getStep()) {
                case SINGLE: 
                case FINAL: {
                    child = this.planChild((PlanNode)node, PreferredProperties.undistributed());
                    if (child.getProperties().isSingleNode()) break;
                    child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
                    break;
                }
                case PARTIAL: {
                    child = this.planChild((PlanNode)node, PreferredProperties.any());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported step for TopN [%s]", node.getStep()));
                }
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitSort(SortNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.undistributed());
            if (child.getProperties().isSingleNode()) {
                ArrayList desiredProperties = new ArrayList();
                for (VariableReferenceExpression variable : node.getOrderingScheme().getOrderByVariables()) {
                    desiredProperties.add(new SortingProperty((Object)variable, node.getOrderingScheme().getOrdering(variable)));
                }
                if (LocalProperties.match(child.getProperties().getLocalProperties(), desiredProperties).stream().noneMatch(Optional::isPresent)) {
                    return this.rebaseAndDeriveProperties((PlanNode)node, child);
                }
            }
            if (SystemSessionProperties.isDistributedSortEnabled(this.session)) {
                child = this.planChild(node, PreferredProperties.any());
                ExchangeNode source = ExchangeNode.roundRobinExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode());
                return this.withDerivedProperties((PlanNode)ExchangeNode.mergingExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, new SortNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, node.getOrderingScheme(), true), node.getOrderingScheme()), child.getProperties());
            }
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        public PlanWithProperties visitLimit(LimitNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild((PlanNode)node, PreferredProperties.any());
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties((PlanNode)new LimitNode(child.getNode().getSourceLocation(), this.idAllocator.getNextId(), child.getNode(), node.getCount(), LimitNode.Step.PARTIAL), child.getProperties());
                child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild((PlanNode)node, PreferredProperties.any());
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)new DistinctLimitNode(child.getNode().getSourceLocation(), this.idAllocator.getNextId(), child.getNode(), node.getLimit(), true, node.getDistinctVariables(), node.getHashVariable(), node.getTimeoutMillis())), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        public PlanWithProperties visitFilter(FilterNode node, PreferredProperties preferredProperties) {
            if (node.getSource() instanceof TableScanNode && AddExchanges.this.metadata.isLegacyGetLayoutSupported(this.session, ((TableScanNode)node.getSource()).getTable())) {
                return this.planTableScan((TableScanNode)node.getSource(), node.getPredicate());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild((PlanNode)node, preferredProperties));
        }

        public PlanWithProperties visitTableScan(TableScanNode node, PreferredProperties preferredProperties) {
            return this.planTableScan(node, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
        }

        @Override
        public PlanWithProperties visitTableWriter(TableWriterNode node, PreferredProperties preferredProperties) {
            PlanWithProperties source = this.accept(node.getSource(), preferredProperties);
            Optional<PartitioningScheme> shufflePartitioningScheme = node.getTablePartitioningScheme();
            if (!shufflePartitioningScheme.isPresent()) {
                shufflePartitioningScheme = node.getPreferredShufflePartitioningScheme();
            }
            if (!shufflePartitioningScheme.isPresent()) {
                if (this.scaleWriters) {
                    shufflePartitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION, ImmutableList.of()), source.getNode().getOutputVariables()));
                } else if (this.redistributeWrites) {
                    shufflePartitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, ImmutableList.of()), source.getNode().getOutputVariables()));
                }
            }
            if (!(!shufflePartitioningScheme.isPresent() || source.getProperties().isCompatibleTablePartitioningWith(shufflePartitioningScheme.get().getPartitioning(), false, AddExchanges.this.metadata, this.session) || source.getProperties().isRefinedPartitioningOver(shufflePartitioningScheme.get().getPartitioning(), false, AddExchanges.this.metadata, this.session) && AddExchanges.this.canPushdownPartialMerge(source.getNode(), this.partialMergePushdownStrategy))) {
                PartitioningScheme exchangePartitioningScheme = shufflePartitioningScheme.get();
                if (node.getTablePartitioningScheme().isPresent() && SystemSessionProperties.isPrestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled(this.session)) {
                    int writerThreadsPerNode = SystemSessionProperties.getTaskPartitionedWriterCount(this.session);
                    int bucketCount = this.getBucketCount(node.getTablePartitioningScheme().get().getPartitioning().getHandle());
                    int[] bucketToPartition = new int[bucketCount];
                    for (int i = 0; i < bucketCount; ++i) {
                        bucketToPartition[i] = i / writerThreadsPerNode;
                    }
                    exchangePartitioningScheme = exchangePartitioningScheme.withBucketToPartition(Optional.of(bucketToPartition));
                }
                source = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, source.getNode(), exchangePartitioningScheme), source.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, source);
        }

        private int getBucketCount(PartitioningHandle partitioning) {
            ConnectorNodePartitioningProvider partitioningProvider = this.getPartitioningProvider(partitioning);
            return partitioningProvider.getBucketCount((ConnectorTransactionHandle)partitioning.getTransactionHandle().orElse(null), this.session.toConnectorSession(), partitioning.getConnectorHandle());
        }

        private ConnectorNodePartitioningProvider getPartitioningProvider(PartitioningHandle partitioning) {
            ConnectorId connectorId = partitioning.getConnectorId().orElseThrow(() -> new IllegalArgumentException("Unexpected partitioning: " + partitioning));
            return this.partitioningProviderManager.getPartitioningProvider(connectorId);
        }

        private PlanWithProperties planTableScan(TableScanNode node, RowExpression predicate) {
            PlanNode plan = PickTableLayout.pushPredicateIntoTableScan(node, predicate, true, this.session, this.idAllocator, AddExchanges.this.metadata);
            return new PlanWithProperties(plan, this.derivePropertiesRecursively(plan));
        }

        public PlanWithProperties visitValues(ValuesNode node, PreferredProperties preferredProperties) {
            return new PlanWithProperties((PlanNode)node, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        @Override
        public PlanWithProperties visitExplainAnalyze(ExplainAnalyzeNode node, PreferredProperties preferredProperties) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType() == ExchangeNode.Type.GATHER) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitStatisticsWriterNode(StatisticsWriterNode node, PreferredProperties context) {
            PlanWithProperties child = this.planChild(node, PreferredProperties.any());
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType().equals((Object)ExchangeNode.Type.GATHER)) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (!child.getProperties().isCoordinatorOnly()) {
                child = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTableFinish(TableFinishNode node, PreferredProperties preferredProperties) {
            ExchangeNode gather;
            PlanNode child = this.planChild(node, PreferredProperties.any()).getNode();
            if (child instanceof ExchangeNode) {
                ExchangeNode exchangeNode = (ExchangeNode)child;
                gather = new ExchangeNode(exchangeNode.getSourceLocation(), this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE_STREAMING, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of()), exchangeNode.getOutputVariables()), exchangeNode.getSources(), exchangeNode.getInputs(), true, Optional.empty());
            } else {
                gather = ExchangeNode.ensureSourceOrderingGatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, child);
            }
            return this.withDerivedProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)((Object)gather))), (List<ActualProperties>)ImmutableList.of());
        }

        private <T> SetMultimap<T, T> createMapping(List<T> keys, List<T> values) {
            Preconditions.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (Object)"Inputs must have the same size");
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (int i = 0; i < keys.size(); ++i) {
                builder.put(keys.get(i), values.get(i));
            }
            return builder.build();
        }

        private <T> Function<T, Optional<T>> createTranslator(SetMultimap<T, T> inputToOutput) {
            return input -> inputToOutput.get(input).stream().findAny();
        }

        private <T> Function<T, T> createDirectTranslator(SetMultimap<T, T> inputToOutput) {
            return input -> inputToOutput.get(input).iterator().next();
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, PreferredProperties preferredProperties) {
            List leftVariables = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).collect(ImmutableList.toImmutableList());
            List rightVariables = (List)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).collect(ImmutableList.toImmutableList());
            JoinNode.DistributionType distributionType = node.getDistributionType().orElseThrow(() -> new IllegalArgumentException("distributionType not yet set"));
            if (distributionType == JoinNode.DistributionType.REPLICATED) {
                PlanWithProperties left = this.accept(node.getLeft(), PreferredProperties.any());
                if (!node.getCriteria().isEmpty() && this.isNodePartitionedOn(left.getProperties(), leftVariables) && !left.getProperties().isSingleNode()) {
                    return this.planPartitionedJoin(node, leftVariables, rightVariables, left);
                }
                return this.planReplicatedJoin(node, left);
            }
            return this.planPartitionedJoin(node, leftVariables, rightVariables);
        }

        private PlanWithProperties planPartitionedJoin(JoinNode node, List<VariableReferenceExpression> leftVariables, List<VariableReferenceExpression> rightVariables) {
            return this.planPartitionedJoin(node, leftVariables, rightVariables, this.accept(node.getLeft(), PreferredProperties.partitioned((Set<VariableReferenceExpression>)ImmutableSet.copyOf(leftVariables))));
        }

        /*
         * Unable to fully structure code
         */
        private PlanWithProperties planPartitionedJoin(JoinNode node, List<VariableReferenceExpression> leftVariables, List<VariableReferenceExpression> rightVariables, PlanWithProperties left) {
            rightToLeft = this.createMapping(rightVariables, leftVariables);
            leftToRight = this.createMapping(leftVariables, rightVariables);
            if (this.isNodePartitionedOn(left.getProperties(), leftVariables) && !left.getProperties().isSingleNode()) {
                rightPartitioning = left.getProperties().translateVariable(this.createTranslator(leftToRight)).getNodePartitioning().get();
                right = this.accept(node.getRight(), PreferredProperties.partitioned(rightPartitioning));
                if (!right.getProperties().isCompatibleTablePartitioningWith(left.getProperties(), (Function<VariableReferenceExpression, Set<VariableReferenceExpression>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)Ljava/util/Set;)(rightToLeft), AddExchanges.access$100(AddExchanges.this), this.session)) {
                    if (!right.getProperties().isRefinedPartitioningOver(left.getProperties(), (Function<VariableReferenceExpression, Set<VariableReferenceExpression>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)Ljava/util/Set;)(rightToLeft), AddExchanges.access$100(AddExchanges.this), this.session) || !AddExchanges.access$200(AddExchanges.this, right.getNode(), this.partialMergePushdownStrategy)) {
                        right = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(right.getNode(), false), right.getNode(), new PartitioningScheme(rightPartitioning, right.getNode().getOutputVariables())), right.getProperties());
                    }
                }
            } else {
                right = this.accept(node.getRight(), PreferredProperties.partitioned((Set<VariableReferenceExpression>)ImmutableSet.copyOf(rightVariables)));
                if (this.isNodePartitionedOn(right.getProperties(), rightVariables) && !right.getProperties().isSingleNode()) {
                    leftPartitioning = right.getProperties().translateVariable(this.createTranslator(rightToLeft)).getNodePartitioning().get();
                    left = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(left.getNode(), false), left.getNode(), new PartitioningScheme(leftPartitioning, left.getNode().getOutputVariables())), left.getProperties());
                } else {
                    left = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(left.getNode(), false), left.getNode(), this.createPartitioning(leftVariables), Optional.empty()), left.getProperties());
                    right = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(right.getNode(), false), right.getNode(), this.createPartitioning(rightVariables), Optional.empty()), right.getProperties());
                }
            }
            if (left.getProperties().isCompatibleTablePartitioningWith(right.getProperties(), (Function<VariableReferenceExpression, Set<VariableReferenceExpression>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)Ljava/util/Set;)(leftToRight), AddExchanges.access$100(AddExchanges.this), this.session)) ** GOTO lbl-1000
            if (right.getProperties().isRefinedPartitioningOver(left.getProperties(), (Function<VariableReferenceExpression, Set<VariableReferenceExpression>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)Ljava/util/Set;)(rightToLeft), AddExchanges.access$100(AddExchanges.this), this.session) && AddExchanges.access$200(AddExchanges.this, right.getNode(), this.partialMergePushdownStrategy)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            Verify.verify((boolean)v0);
            if (!SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleTableScans(new PlanNode[]{left.getNode(), right.getNode()})) {
                rightPartitioning = left.getProperties().translateVariable(this.createTranslator(leftToRight)).getNodePartitioning().get();
                right = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(right.getNode(), false), right.getNode(), new PartitioningScheme(rightPartitioning, right.getNode().getOutputVariables())), right.getProperties());
            }
            return this.buildJoin(node, left, right, JoinNode.DistributionType.PARTITIONED);
        }

        private PlanWithProperties planReplicatedJoin(JoinNode node, PlanWithProperties left) {
            PlanWithProperties right = this.accept(node.getRight(), PreferredProperties.any());
            if (left.getProperties().isSingleNode()) {
                if (!right.getProperties().isSingleNode() || !SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleTableScans(left.getNode(), right.getNode())) {
                    right = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode()), right.getProperties());
                }
            } else {
                right = this.withDerivedProperties((PlanNode)ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode()), right.getProperties());
            }
            return this.buildJoin(node, left, right, JoinNode.DistributionType.REPLICATED);
        }

        private PlanWithProperties buildJoin(JoinNode node, PlanWithProperties newLeft, PlanWithProperties newRight, JoinNode.DistributionType newDistributionType) {
            JoinNode result = new JoinNode(node.getSourceLocation(), node.getId(), node.getType(), newLeft.getNode(), newRight.getNode(), node.getCriteria(), node.getOutputVariables(), node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable(), Optional.of(newDistributionType), node.getDynamicFilters());
            return new PlanWithProperties(result, this.deriveProperties((PlanNode)result, (List<ActualProperties>)ImmutableList.of((Object)newLeft.getProperties(), (Object)newRight.getProperties())));
        }

        @Override
        public PlanWithProperties visitSpatialJoin(SpatialJoinNode node, PreferredProperties preferredProperties) {
            SpatialJoinNode.DistributionType distributionType = node.getDistributionType();
            PlanWithProperties left = this.accept(node.getLeft(), PreferredProperties.any());
            PlanWithProperties right = this.accept(node.getRight(), PreferredProperties.any());
            if (distributionType == SpatialJoinNode.DistributionType.REPLICATED) {
                if (left.getProperties().isSingleNode()) {
                    if (!right.getProperties().isSingleNode()) {
                        right = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode()), right.getProperties());
                    }
                } else {
                    right = this.withDerivedProperties((PlanNode)ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode()), right.getProperties());
                }
            } else {
                left = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, left.getNode(), this.createPartitioning((Collection<VariableReferenceExpression>)ImmutableList.of((Object)node.getLeftPartitionVariable().get())), Optional.empty()), left.getProperties());
                right = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, right.getNode(), this.createPartitioning((Collection<VariableReferenceExpression>)ImmutableList.of((Object)node.getRightPartitionVariable().get())), Optional.empty()), right.getProperties());
            }
            PlanNode newJoinNode = node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)left.getNode(), (Object)right.getNode()));
            return new PlanWithProperties(newJoinNode, this.deriveProperties(newJoinNode, (List<ActualProperties>)ImmutableList.of((Object)left.getProperties(), (Object)right.getProperties())));
        }

        @Override
        public PlanWithProperties visitUnnest(UnnestNode node, PreferredProperties preferredProperties) {
            PreferredProperties translatedPreferred = preferredProperties.translate(variable -> node.getReplicateVariables().contains(variable) ? Optional.of(variable) : Optional.empty());
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, translatedPreferred));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, PreferredProperties preferredProperties) {
            block13: {
                block12: {
                    distributionType = node.getDistributionType().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$visitSemiJoin$11(), ()Ljava/lang/IllegalArgumentException;)());
                    if (distributionType != SemiJoinNode.DistributionType.PARTITIONED) break block12;
                    sourceVariables = ImmutableList.of((Object)node.getSourceJoinVariable());
                    filteringSourceVariables = ImmutableList.of((Object)node.getFilteringSourceJoinVariable());
                    sourceToFiltering = this.createMapping((List<T>)sourceVariables, (List<T>)filteringSourceVariables);
                    filteringToSource = this.createMapping((List<T>)filteringSourceVariables, (List<T>)sourceVariables);
                    source = this.accept(node.getSource(), PreferredProperties.partitioned((Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)sourceVariables)));
                    if (this.isNodePartitionedOn(source.getProperties(), (Collection<VariableReferenceExpression>)sourceVariables) && !source.getProperties().isSingleNode()) {
                        filteringPartitioning = source.getProperties().translateVariable(this.createTranslator(sourceToFiltering)).getNodePartitioning().get();
                        filteringSource = this.accept(node.getFilteringSource(), PreferredProperties.partitionedWithNullsAndAnyReplicated(filteringPartitioning));
                        if (!source.getProperties().withReplicatedNulls(true).isCompatibleTablePartitioningWith(filteringSource.getProperties(), (Function<VariableReferenceExpression, Set<VariableReferenceExpression>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)Ljava/util/Set;)(sourceToFiltering), AddExchanges.access$100(AddExchanges.this), this.session)) {
                            if (!filteringSource.getProperties().withReplicatedNulls(true).isRefinedPartitioningOver(source.getProperties(), (Function<VariableReferenceExpression, Set<VariableReferenceExpression>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)Ljava/util/Set;)(filteringToSource), AddExchanges.access$100(AddExchanges.this), this.session) || !AddExchanges.access$200(AddExchanges.this, filteringSource.getNode(), this.partialMergePushdownStrategy)) {
                                filteringSource = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode(), new PartitioningScheme(filteringPartitioning, filteringSource.getNode().getOutputVariables(), Optional.empty(), true, Optional.empty())), filteringSource.getProperties());
                            }
                        }
                    } else {
                        filteringSource = this.accept(node.getFilteringSource(), PreferredProperties.partitionedWithNullsAndAnyReplicated((Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)filteringSourceVariables)));
                        if (filteringSource.getProperties().isNodePartitionedOn((Collection<VariableReferenceExpression>)filteringSourceVariables, true, SystemSessionProperties.isExactPartitioningPreferred(this.session)) && !filteringSource.getProperties().isSingleNode()) {
                            sourcePartitioning = filteringSource.getProperties().translateVariable(this.createTranslator(filteringToSource)).getNodePartitioning().get();
                            source = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, source.getNode(), new PartitioningScheme(sourcePartitioning, source.getNode().getOutputVariables())), source.getProperties());
                        } else {
                            source = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, source.getNode(), this.createPartitioning((Collection<VariableReferenceExpression>)sourceVariables), Optional.empty()), source.getProperties());
                            filteringSource = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode(), this.createPartitioning((Collection<VariableReferenceExpression>)filteringSourceVariables), Optional.empty(), true), filteringSource.getProperties());
                        }
                    }
                    if (source.getProperties().withReplicatedNulls(true).isCompatibleTablePartitioningWith(filteringSource.getProperties(), (Function<VariableReferenceExpression, Set<VariableReferenceExpression>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)Ljava/util/Set;)(sourceToFiltering), AddExchanges.access$100(AddExchanges.this), this.session)) ** GOTO lbl-1000
                    if (filteringSource.getProperties().withReplicatedNulls(true).isRefinedPartitioningOver(source.getProperties(), (Function<VariableReferenceExpression, Set<VariableReferenceExpression>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lcom/facebook/presto/spi/relation/VariableReferenceExpression;)Ljava/util/Set;)(filteringToSource), AddExchanges.access$100(AddExchanges.this), this.session) && AddExchanges.access$200(AddExchanges.this, filteringSource.getNode(), this.partialMergePushdownStrategy)) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                    Verify.verify((boolean)v0);
                    if (!SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleTableScans(new PlanNode[]{source.getNode(), filteringSource.getNode()})) {
                        filteringPartitioning = source.getProperties().translateVariable(this.createTranslator(sourceToFiltering)).getNodePartitioning().get();
                        filteringSource = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode(), new PartitioningScheme(filteringPartitioning, filteringSource.getNode().getOutputVariables(), Optional.empty(), true, Optional.empty())), filteringSource.getProperties());
                    }
                    break block13;
                }
                source = this.accept(node.getSource(), PreferredProperties.any());
                filteringSource = this.accept(node.getFilteringSource(), PreferredProperties.any());
                if (source.getProperties().isSingleNode()) {
                    if (!filteringSource.getProperties().isSingleNode() || !SystemSessionProperties.isColocatedJoinEnabled(this.session) && FragmentTableScanCounter.hasMultipleTableScans(new PlanNode[]{source.getNode(), filteringSource.getNode()})) {
                        filteringSource = this.withDerivedProperties((PlanNode)ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode()), filteringSource.getProperties());
                    }
                } else {
                    filteringSource = this.withDerivedProperties((PlanNode)ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, filteringSource.getNode()), filteringSource.getProperties());
                }
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, (List<PlanWithProperties>)ImmutableList.of((Object)source, (Object)filteringSource));
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, PreferredProperties preferredProperties) {
            List joinColumns = (List)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getProbe).collect(ImmutableList.toImmutableList());
            Object desiredLocalProperties = preferredProperties.getLocalProperties().isEmpty() ? LocalProperties.grouped(joinColumns) : ImmutableList.of();
            PlanWithProperties probeSource = this.accept(node.getProbeSource(), PreferredProperties.partitionedWithLocal((Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)joinColumns), (List<? extends LocalProperty<VariableReferenceExpression>>)desiredLocalProperties).mergeWithParent(preferredProperties, true));
            ActualProperties probeProperties = probeSource.getProperties();
            PlanWithProperties indexSource = this.accept(node.getIndexSource(), PreferredProperties.any());
            if (this.shouldRepartitionForIndexJoin(joinColumns, preferredProperties, probeProperties)) {
                probeSource = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, probeSource.getNode(), this.createPartitioning(joinColumns), node.getProbeHashVariable()), probeProperties);
            }
            PlanNode result = ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)probeSource.getNode(), (Object)node.getIndexSource()));
            return new PlanWithProperties(result, this.deriveProperties(result, (List<ActualProperties>)ImmutableList.of((Object)probeSource.getProperties(), (Object)indexSource.getProperties())));
        }

        private boolean shouldRepartitionForIndexJoin(List<VariableReferenceExpression> joinColumns, PreferredProperties parentPreferredProperties, ActualProperties probeProperties) {
            if (!this.distributedIndexJoins) {
                return false;
            }
            if (probeProperties.isSingleNode()) {
                return false;
            }
            Optional<Boolean> parentPartitioningPreferences = parentPreferredProperties.getGlobalProperties().flatMap(PreferredProperties.Global::getPartitioningProperties);
            boolean parentAlreadyPartitionedOnChild = parentPartitioningPreferences.map(partitioning -> probeProperties.isStreamPartitionedOn(partitioning.getPartitioningColumns(), false)).orElse(false);
            if (this.preferStreamingOperators && parentAlreadyPartitionedOnChild) {
                return false;
            }
            if (!probeProperties.isStreamPartitionedOn(joinColumns, false)) {
                return true;
            }
            return probeProperties.isEffectivelySingleStream() && probeProperties.isStreamRepartitionEffective(joinColumns);
        }

        @Override
        public PlanWithProperties visitIndexSource(IndexSourceNode node, PreferredProperties preferredProperties) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        private Function<VariableReferenceExpression, Optional<VariableReferenceExpression>> outputToInputTranslator(UnionNode node, int sourceIndex) {
            return variable -> Optional.of(((List)node.getVariableMapping().get(variable)).get(sourceIndex));
        }

        private Partitioning selectUnionPartitioning(UnionNode node, PreferredProperties.PartitioningProperties parentPreference) {
            if (parentPreference.getPartitioning().isPresent()) {
                return parentPreference.getPartitioning().get();
            }
            boolean nullsAndAnyReplicated = parentPreference.isNullsAndAnyReplicated();
            for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                PreferredProperties.PartitioningProperties childPartitioning = parentPreference.translateVariable(this.outputToInputTranslator(node, sourceIndex)).get();
                PreferredProperties childPreferred = PreferredProperties.builder().global(PreferredProperties.Global.distributed(childPartitioning.withNullsAndAnyReplicated(nullsAndAnyReplicated))).build();
                PlanWithProperties child = this.accept((PlanNode)node.getSources().get(sourceIndex), childPreferred);
                if (!child.getProperties().isNodePartitionedOn(childPartitioning.getPartitioningColumns(), nullsAndAnyReplicated, SystemSessionProperties.isExactPartitioningPreferred(this.session)) || child.getProperties().isSingleNode()) continue;
                Function<VariableReferenceExpression, Optional<VariableReferenceExpression>> childToParent = this.createTranslator(this.createMapping(node.sourceOutputLayout(sourceIndex), node.getOutputVariables()));
                return child.getProperties().translateVariable(childToParent).getNodePartitioning().get();
            }
            return this.createPartitioning((Collection<VariableReferenceExpression>)ImmutableList.copyOf(parentPreference.getPartitioningColumns()));
        }

        public PlanWithProperties visitUnion(UnionNode node, PreferredProperties parentPreference) {
            Object result;
            Optional<PreferredProperties.Global> parentPartitioningPreference = parentPreference.getGlobalProperties();
            if (parentPartitioningPreference.isPresent() && parentPartitioningPreference.get().isDistributed() && parentPartitioningPreference.get().getPartitioningProperties().isPresent()) {
                PreferredProperties.PartitioningProperties parentPartitioningProperties = parentPartitioningPreference.get().getPartitioningProperties().get();
                boolean nullsAndAnyReplicated = parentPartitioningProperties.isNullsAndAnyReplicated();
                Partitioning desiredParentPartitioning = this.selectUnionPartitioning(node, parentPartitioningProperties);
                ImmutableList.Builder partitionedSources = ImmutableList.builder();
                ImmutableListMultimap.Builder outputToSourcesMapping = ImmutableListMultimap.builder();
                for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                    Partitioning childPartitioning = desiredParentPartitioning.translateVariable(this.createDirectTranslator(this.createMapping(node.getOutputVariables(), node.sourceOutputLayout(sourceIndex))));
                    PreferredProperties childPreferred = PreferredProperties.builder().global(PreferredProperties.Global.distributed(PreferredProperties.PartitioningProperties.partitioned(childPartitioning).withNullsAndAnyReplicated(nullsAndAnyReplicated))).build();
                    PlanWithProperties source = this.accept((PlanNode)node.getSources().get(sourceIndex), childPreferred);
                    if (!(source.getProperties().isCompatibleTablePartitioningWith(childPartitioning, nullsAndAnyReplicated, AddExchanges.this.metadata, this.session) || source.getProperties().isRefinedPartitioningOver(childPartitioning, nullsAndAnyReplicated, AddExchanges.this.metadata, this.session) && AddExchanges.this.canPushdownPartialMerge(source.getNode(), this.partialMergePushdownStrategy))) {
                        source = this.withDerivedProperties((PlanNode)ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), this.selectExchangeScopeForPartitionedRemoteExchange(source.getNode(), nullsAndAnyReplicated), source.getNode(), new PartitioningScheme(childPartitioning, source.getNode().getOutputVariables(), Optional.empty(), nullsAndAnyReplicated, Optional.empty())), source.getProperties());
                    }
                    partitionedSources.add((Object)source.getNode());
                    for (int column = 0; column < node.getOutputVariables().size(); ++column) {
                        outputToSourcesMapping.put(node.getOutputVariables().get(column), node.sourceOutputLayout(sourceIndex).get(column));
                    }
                }
                ImmutableListMultimap outputsToInputs = outputToSourcesMapping.build();
                UnionNode newNode = new UnionNode(node.getSourceLocation(), node.getId(), (List)partitionedSources.build(), (List)ImmutableList.copyOf((Collection)outputsToInputs.keySet()), SetOperationNodeUtils.fromListMultimap((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)outputsToInputs));
                return new PlanWithProperties((PlanNode)newNode, ActualProperties.builder().global(ActualProperties.Global.partitionedOn(desiredParentPartitioning, Optional.of(desiredParentPartitioning))).build().withReplicatedNulls(parentPartitioningProperties.isNullsAndAnyReplicated()));
            }
            ArrayList<PlanNode> singleNodeChildren = new ArrayList<PlanNode>();
            ArrayList<List> singleNodeOutputLayouts = new ArrayList<List>();
            ArrayList<PlanNode> distributedChildren = new ArrayList<PlanNode>();
            ArrayList<List<VariableReferenceExpression>> distributedOutputLayouts = new ArrayList<List<VariableReferenceExpression>>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanWithProperties child = this.accept((PlanNode)node.getSources().get(i), PreferredProperties.any());
                if (child.getProperties().isSingleNode()) {
                    singleNodeChildren.add(child.getNode());
                    singleNodeOutputLayouts.add(node.sourceOutputLayout(i));
                    continue;
                }
                distributedChildren.add(child.getNode());
                distributedOutputLayouts.add(node.sourceOutputLayout(i));
            }
            if (!distributedChildren.isEmpty() && singleNodeChildren.isEmpty()) {
                if (!parentPartitioningPreference.isPresent() || parentPartitioningPreference.get().isDistributed()) {
                    if (FragmentTableScanCounter.getNumberOfTableScans(distributedChildren) == 0 && AddExchanges.isSameOrSystemCompatiblePartitions(AddExchanges.extractRemoteExchangePartitioningHandles(distributedChildren))) {
                        return new PlanWithProperties(node.replaceChildren(distributedChildren));
                    }
                    if (this.preferDistributedUnion) {
                        return new PlanWithProperties(new ExchangeNode(node.getSourceLocation(), this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.REMOTE_STREAMING, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, ImmutableList.of()), node.getOutputVariables()), distributedChildren, distributedOutputLayouts, false, Optional.empty()));
                    }
                }
                result = new ExchangeNode(node.getSourceLocation(), this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE_STREAMING, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of()), node.getOutputVariables()), distributedChildren, distributedOutputLayouts, false, Optional.empty());
            } else if (!singleNodeChildren.isEmpty()) {
                if (!distributedChildren.isEmpty()) {
                    List exchangeOutputLayout = (List)node.getOutputVariables().stream().map(arg_0 -> ((VariableAllocator)this.variableAllocator).newVariable(arg_0)).collect(ImmutableList.toImmutableList());
                    ExchangeNode result2 = new ExchangeNode(node.getSourceLocation(), this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.REMOTE_STREAMING, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, ImmutableList.of()), exchangeOutputLayout), distributedChildren, distributedOutputLayouts, false, Optional.empty());
                    singleNodeChildren.add(result2);
                    singleNodeOutputLayouts.add(exchangeOutputLayout);
                }
                ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
                for (int i = 0; i < node.getOutputVariables().size(); ++i) {
                    for (List outputLayout : singleNodeOutputLayouts) {
                        mappings.put(node.getOutputVariables().get(i), outputLayout.get(i));
                    }
                }
                ImmutableListMultimap outputsToInputs = mappings.build();
                result = new UnionNode(node.getSourceLocation(), node.getId(), singleNodeChildren, (List)ImmutableList.copyOf((Collection)outputsToInputs.keySet()), SetOperationNodeUtils.fromListMultimap((ListMultimap<VariableReferenceExpression, VariableReferenceExpression>)outputsToInputs));
            } else {
                throw new IllegalStateException("both singleNodeChildren distributedChildren are empty");
            }
            return new PlanWithProperties((PlanNode)result, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        @Override
        public PlanWithProperties visitApply(ApplyNode node, PreferredProperties preferredProperties) {
            throw new IllegalStateException("Unexpected node: " + ((Object)((Object)node)).getClass().getName());
        }

        @Override
        public PlanWithProperties visitLateralJoin(LateralJoinNode node, PreferredProperties preferredProperties) {
            throw new IllegalStateException("Unexpected node: " + ((Object)((Object)node)).getClass().getName());
        }

        private PlanWithProperties planChild(PlanNode node, PreferredProperties preferredProperties) {
            return this.accept((PlanNode)Iterables.getOnlyElement((Iterable)node.getSources()), preferredProperties);
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, PlanWithProperties child) {
            return this.withDerivedProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)child.getNode())), child.getProperties());
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, List<PlanWithProperties> children) {
            PlanNode result = node.replaceChildren(children.stream().map(PlanWithProperties::getNode).collect(Collectors.toList()));
            return new PlanWithProperties(result, this.deriveProperties(result, children.stream().map(PlanWithProperties::getProperties).collect(Collectors.toList())));
        }

        private PlanWithProperties withDerivedProperties(PlanNode node, List<ActualProperties> inputProperties) {
            return new PlanWithProperties(node, this.deriveProperties(node, inputProperties));
        }

        private PlanWithProperties withDerivedProperties(PlanNode node, ActualProperties inputProperties) {
            return new PlanWithProperties(node, this.deriveProperties(node, inputProperties));
        }

        private ActualProperties deriveProperties(PlanNode result, ActualProperties inputProperties) {
            return this.deriveProperties(result, (List<ActualProperties>)ImmutableList.of((Object)inputProperties));
        }

        private ActualProperties deriveProperties(PlanNode result, List<ActualProperties> inputProperties) {
            ActualProperties outputProperties = PropertyDerivations.deriveProperties(result, inputProperties, AddExchanges.this.metadata, this.session, this.types, AddExchanges.this.parser);
            Verify.verify((result instanceof SemiJoinNode || inputProperties.stream().noneMatch(ActualProperties::isNullsAndAnyReplicated) || outputProperties.isNullsAndAnyReplicated() ? 1 : 0) != 0, (String)"SemiJoinNode is the only node that can strip null replication", (Object[])new Object[0]);
            return outputProperties;
        }

        private ActualProperties derivePropertiesRecursively(PlanNode result) {
            return PropertyDerivations.derivePropertiesRecursively(result, AddExchanges.this.metadata, this.session, this.types, AddExchanges.this.parser);
        }

        private PlanWithProperties accept(PlanNode plan, PreferredProperties context) {
            PlanWithProperties result = (PlanWithProperties)plan.accept((PlanVisitor)this, (Object)context);
            return new PlanWithProperties(result.getNode().assignStatsEquivalentPlanNode(plan.getStatsEquivalentPlanNode()), result.getProperties());
        }

        private Partitioning createPartitioning(Collection<VariableReferenceExpression> partitioningColumns) {
            if ("system".equals(this.partitioningProviderCatalog)) {
                return Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, ImmutableList.copyOf(partitioningColumns));
            }
            List partitioningTypes = (List)partitioningColumns.stream().map(VariableReferenceExpression::getType).collect(ImmutableList.toImmutableList());
            try {
                PartitioningHandle partitioningHandle = AddExchanges.this.metadata.getPartitioningHandleForExchange(this.session, this.partitioningProviderCatalog, this.hashPartitionCount, partitioningTypes);
                return Partitioning.create(partitioningHandle, partitioningColumns);
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode())) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Catalog \"%s\" cannot be used as a partitioning provider: %s", this.partitioningProviderCatalog, e.getMessage()), (Throwable)e);
                }
                throw e;
            }
        }

        private ExchangeNode.Scope selectExchangeScopeForPartitionedRemoteExchange(PlanNode exchangeSource, boolean nullsAndAnyReplicated) {
            if (nullsAndAnyReplicated || exchangeSource.getOutputVariables().isEmpty()) {
                return ExchangeNode.Scope.REMOTE_STREAMING;
            }
            switch (this.exchangeMaterializationStrategy) {
                case ALL: {
                    return ExchangeNode.Scope.REMOTE_MATERIALIZED;
                }
                case NONE: {
                    return ExchangeNode.Scope.REMOTE_STREAMING;
                }
            }
            throw new IllegalStateException("Unexpected exchange materialization strategy: " + (Object)((Object)this.exchangeMaterializationStrategy));
        }

        private boolean isNodePartitionedOn(ActualProperties properties, Collection<VariableReferenceExpression> columns) {
            return properties.isNodePartitionedOn(columns, SystemSessionProperties.isExactPartitioningPreferred(this.session));
        }

        private boolean isStreamPartitionedOn(ActualProperties properties, Collection<VariableReferenceExpression> columns) {
            return properties.isStreamPartitionedOn(columns, SystemSessionProperties.isExactPartitioningPreferred(this.session));
        }

        private boolean shouldAggregationMergePartitionPreferences(FeaturesConfig.AggregationPartitioningMergingStrategy aggregationPartitioningMergingStrategy) {
            if (SystemSessionProperties.isExactPartitioningPreferred(this.session)) {
                return false;
            }
            return aggregationPartitioningMergingStrategy.isMergingWithParent();
        }

        private static /* synthetic */ IllegalArgumentException lambda$visitSemiJoin$11() {
            return new IllegalArgumentException("distributionType not yet set");
        }
    }
}

