/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TransformCorrelatedScalarSubquery
implements Rule<LateralJoinNode> {
    private static final Pattern<LateralJoinNode> PATTERN = Patterns.lateralJoin().with(Pattern.nonEmpty(Patterns.LateralJoin.correlation()));
    private final FunctionAndTypeResolver functionAndTypeResolver;

    public TransformCorrelatedScalarSubquery(FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        this.functionAndTypeResolver = functionAndTypeManager.getFunctionAndTypeResolver();
    }

    @Override
    public Pattern getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LateralJoinNode lateralJoinNode, Captures captures, Rule.Context context) {
        PlanNode subquery = context.getLookup().resolve(lateralJoinNode.getSubquery());
        if (!PlanNodeSearcher.searchFrom(subquery, context.getLookup()).where(EnforceSingleRowNode.class::isInstance).recurseOnlyWhen(ProjectNode.class::isInstance).matches()) {
            return Rule.Result.empty();
        }
        PlanNode rewrittenSubquery = PlanNodeSearcher.searchFrom(subquery, context.getLookup()).where(EnforceSingleRowNode.class::isInstance).recurseOnlyWhen(ProjectNode.class::isInstance).removeFirst();
        if (QueryCardinalityUtil.isAtMostScalar(rewrittenSubquery, context.getLookup())) {
            return Rule.Result.ofPlanNode(new LateralJoinNode(lateralJoinNode.getSourceLocation(), context.getIdAllocator().getNextId(), lateralJoinNode.getInput(), rewrittenSubquery, lateralJoinNode.getCorrelation(), lateralJoinNode.getType(), lateralJoinNode.getOriginSubqueryError()));
        }
        VariableReferenceExpression unique = context.getVariableAllocator().newVariable("unique", (Type)BigintType.BIGINT);
        LateralJoinNode rewrittenLateralJoinNode = new LateralJoinNode(lateralJoinNode.getSourceLocation(), context.getIdAllocator().getNextId(), new AssignUniqueId(lateralJoinNode.getSourceLocation(), context.getIdAllocator().getNextId(), lateralJoinNode.getInput(), unique), rewrittenSubquery, lateralJoinNode.getCorrelation(), lateralJoinNode.getType(), lateralJoinNode.getOriginSubqueryError());
        VariableReferenceExpression isDistinct = context.getVariableAllocator().newVariable("is_distinct", (Type)BooleanType.BOOLEAN);
        MarkDistinctNode markDistinctNode = new MarkDistinctNode(rewrittenLateralJoinNode.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)rewrittenLateralJoinNode, isDistinct, rewrittenLateralJoinNode.getInput().getOutputVariables(), Optional.empty());
        CallExpression fail = Expressions.call("fail", this.functionAndTypeResolver.lookupFunction("fail", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR})), (Type)UnknownType.UNKNOWN, new RowExpression[]{new ConstantExpression((Object)StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode(), (Type)IntegerType.INTEGER), new ConstantExpression((Object)Slices.utf8Slice((String)"Scalar sub-query has returned multiple rows"), (Type)VarcharType.VARCHAR)});
        FilterNode filterNode = new FilterNode(markDistinctNode.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)markDistinctNode, Expressions.buildSwitch((RowExpression)isDistinct, (List<RowExpression>)ImmutableList.of((Object)Expressions.specialForm(SpecialFormExpression.Form.WHEN, (Type)BooleanType.BOOLEAN, new RowExpression[]{LogicalRowExpressions.TRUE_CONSTANT, LogicalRowExpressions.TRUE_CONSTANT})), Optional.of(Expressions.call(CastType.CAST.name(), this.functionAndTypeResolver.lookupCast("CAST", (Type)UnknownType.UNKNOWN, (Type)BooleanType.BOOLEAN), (Type)BooleanType.BOOLEAN, new RowExpression[]{fail})), (Type)BooleanType.BOOLEAN));
        return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)filterNode, AssignmentUtils.identityAssignments(lateralJoinNode.getOutputVariables())));
    }
}

