/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RemoveRedundantAggregateDistinct
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(RemoveRedundantAggregateDistinct::hasAggregations);

    private static boolean hasAggregations(AggregationNode node) {
        return ((GroupReference)node.getSource()).getLogicalProperties().isPresent() && !node.getAggregations().isEmpty();
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        ImmutableMap.Builder aggregationsBuilder = ImmutableMap.builder();
        for (Map.Entry agg : node.getAggregations().entrySet()) {
            Set varAndGroupingKeySet = Stream.concat(node.getGroupingKeys().stream().map(VariableReferenceExpression.class::cast), ((AggregationNode.Aggregation)agg.getValue()).getArguments().stream().map(VariableReferenceExpression.class::cast)).collect(Collectors.toSet());
            if (((AggregationNode.Aggregation)agg.getValue()).isDistinct() && ((GroupReference)node.getSource()).getLogicalProperties().get().isDistinct(varAndGroupingKeySet)) {
                aggregationsBuilder.put(agg.getKey(), (Object)AggregationNode.Aggregation.removeDistinct((AggregationNode.Aggregation)((AggregationNode.Aggregation)agg.getValue())));
                continue;
            }
            aggregationsBuilder.put(agg);
        }
        ImmutableMap newAggregations = aggregationsBuilder.build();
        if (newAggregations.equals(node.getAggregations())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode((PlanNode)new AggregationNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getSource(), (Map)newAggregations, node.getGroupingSets(), node.getPreGroupedVariables(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable()));
    }
}

