/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.util.MoreLists;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PruneValuesColumns
extends ProjectOffPushDownRule<ValuesNode> {
    public PruneValuesColumns() {
        super(Patterns.values());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, ValuesNode valuesNode, Set<VariableReferenceExpression> referencedOutputs) {
        List<VariableReferenceExpression> newOutputs = MoreLists.filteredCopy(valuesNode.getOutputVariables(), referencedOutputs::contains);
        List<VariableReferenceExpression> newOutputVariables = MoreLists.filteredCopy(valuesNode.getOutputVariables(), referencedOutputs::contains);
        int[] mapping = new int[newOutputs.size()];
        for (int i = 0; i < mapping.length; ++i) {
            mapping[i] = valuesNode.getOutputVariables().indexOf(newOutputs.get(i));
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (List row : valuesNode.getRows()) {
            rowsBuilder.add(Arrays.stream(mapping).mapToObj(row::get).collect(Collectors.toList()));
        }
        return Optional.of(new ValuesNode(valuesNode.getSourceLocation(), valuesNode.getId(), newOutputVariables, (List)rowsBuilder.build(), valuesNode.getValuesNodeLabel()));
    }
}

