/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PruneCrossJoinColumns
extends ProjectOffPushDownRule<JoinNode> {
    public PruneCrossJoinColumns() {
        super(Patterns.join().matching(JoinNode::isCrossJoin));
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, JoinNode joinNode, Set<VariableReferenceExpression> referencedOutputs) {
        Optional<PlanNode> newLeft = Util.restrictOutputs(idAllocator, joinNode.getLeft(), referencedOutputs);
        Optional<PlanNode> newRight = Util.restrictOutputs(idAllocator, joinNode.getRight(), referencedOutputs);
        if (!newLeft.isPresent() && !newRight.isPresent()) {
            return Optional.empty();
        }
        ImmutableList.Builder outputVariableBuilder = ImmutableList.builder();
        outputVariableBuilder.addAll((Iterable)newLeft.orElse(joinNode.getLeft()).getOutputVariables());
        outputVariableBuilder.addAll((Iterable)newRight.orElse(joinNode.getRight()).getOutputVariables());
        return Optional.of(new JoinNode(joinNode.getSourceLocation(), idAllocator.getNextId(), joinNode.getType(), newLeft.orElse(joinNode.getLeft()), newRight.orElse(joinNode.getRight()), joinNode.getCriteria(), (List<VariableReferenceExpression>)outputVariableBuilder.build(), joinNode.getFilter(), joinNode.getLeftHashVariable(), joinNode.getRightHashVariable(), joinNode.getDistributionType(), joinNode.getDynamicFilters()));
    }
}

