/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MergeDuplicateAggregation
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();
    private final FunctionAndTypeManager functionAndTypeManager;

    public MergeDuplicateAggregation(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = functionAndTypeManager;
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        if (!SystemSessionProperties.isMergeDuplicateAggregationsEnabled(context.getSession())) {
            return Rule.Result.empty();
        }
        Map aggregationToVariableList = node.getAggregations().entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        ImmutableMap.Builder variablesToMergeBuilder = ImmutableMap.builder();
        for (Map.Entry entry : aggregationToVariableList.entrySet()) {
            List variableToSameAggregation = entry.getValue();
            if (variableToSameAggregation.size() <= 1 || !this.functionAndTypeManager.getFunctionMetadata(entry.getKey().getFunctionHandle()).isDeterministic()) continue;
            for (int i = 1; i < variableToSameAggregation.size(); ++i) {
                variablesToMergeBuilder.put(variableToSameAggregation.get(i), variableToSameAggregation.get(0));
            }
        }
        ImmutableMap variablesToMerge = variablesToMergeBuilder.build();
        if (variablesToMerge.isEmpty()) {
            return Rule.Result.empty();
        }
        Map aggregations = (Map)node.getAggregations().entrySet().stream().filter(x -> !variablesToMerge.containsKey(x.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Assignments.Builder assignments = Assignments.builder();
        assignments.putAll(AssignmentUtils.identityAssignments((Collection)node.getOutputVariables().stream().filter(x -> !variablesToMerge.containsKey(x)).collect(ImmutableList.toImmutableList())));
        assignments.putAll(variablesToMerge.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)new AggregationNode(node.getSourceLocation(), node.getId(), node.getSource(), aggregations, node.getGroupingSets(), node.getPreGroupedVariables(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable()), assignments.build(), ProjectNode.Locality.LOCAL));
    }
}

