/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class LambdaCaptureDesugaringRowExpressionRewriter {
    public static RowExpression rewrite(RowExpression expression, VariableAllocator variableAllocator) {
        return RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new Visitor(variableAllocator), (RowExpression)expression, (Object)new Context());
    }

    private LambdaCaptureDesugaringRowExpressionRewriter() {
    }

    private static class Context {
        final LinkedHashSet<VariableReferenceExpression> referencedVariables;

        public Context() {
            this(new LinkedHashSet<VariableReferenceExpression>());
        }

        private Context(LinkedHashSet<VariableReferenceExpression> referencedVariables) {
            this.referencedVariables = referencedVariables;
        }

        public LinkedHashSet<VariableReferenceExpression> getReferencedVariables() {
            return this.referencedVariables;
        }

        public Context withReferencedVariables(LinkedHashSet<VariableReferenceExpression> variables) {
            return new Context(variables);
        }
    }

    private static class Visitor
    extends RowExpressionRewriter<Context> {
        private final VariableAllocator variableAllocator;

        public Visitor(VariableAllocator variableAllocator) {
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        }

        public RowExpression rewriteLambda(LambdaDefinitionExpression node, Context context, RowExpressionTreeRewriter<Context> treeRewriter) {
            LinkedHashSet<VariableReferenceExpression> referencedVariables = new LinkedHashSet<VariableReferenceExpression>();
            RowExpression rewrittenBody = treeRewriter.rewrite(node.getBody(), (Object)context.withReferencedVariables(referencedVariables));
            List lambdaArgumentNames = node.getArguments();
            Set captureVariables = (Set)referencedVariables.stream().filter(variable -> !lambdaArgumentNames.contains(variable.getName())).collect(ImmutableSet.toImmutableSet());
            ImmutableMap.Builder captureVariableToExtraVariable = ImmutableMap.builder();
            ImmutableList.Builder newLambdaArguments = ImmutableList.builder();
            ImmutableList.Builder newLambdaArgumentsType = ImmutableList.builder();
            for (VariableReferenceExpression captureVariable : captureVariables) {
                VariableReferenceExpression extraVariable = this.variableAllocator.newVariable(captureVariable);
                captureVariableToExtraVariable.put((Object)captureVariable, (Object)extraVariable);
                newLambdaArguments.add((Object)extraVariable.getName());
                newLambdaArgumentsType.add((Object)extraVariable.getType());
            }
            newLambdaArguments.addAll((Iterable)node.getArguments());
            newLambdaArgumentsType.addAll((Iterable)node.getArgumentTypes());
            ImmutableMap variablesMap = captureVariableToExtraVariable.build();
            Function<VariableReferenceExpression, RowExpression> variableMapping = variable -> (VariableReferenceExpression)variablesMap.getOrDefault(variable, variable);
            LambdaDefinitionExpression rewrittenExpression = new LambdaDefinitionExpression(node.getSourceLocation(), (List)newLambdaArgumentsType.build(), (List)newLambdaArguments.build(), RowExpressionVariableInliner.inlineVariables(variableMapping, rewrittenBody));
            if (!captureVariables.isEmpty()) {
                rewrittenExpression = Expressions.specialForm(SpecialFormExpression.Form.BIND, node.getType(), (List)Stream.concat(captureVariables.stream(), Stream.of(rewrittenExpression)).collect(ImmutableList.toImmutableList()));
            }
            context.getReferencedVariables().addAll(captureVariables);
            return rewrittenExpression;
        }

        public RowExpression rewriteVariableReference(VariableReferenceExpression node, Context context, RowExpressionTreeRewriter<Context> treeRewriter) {
            context.getReferencedVariables().add(node);
            return null;
        }
    }
}

