/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.matching.PropertyPattern;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class GatherAndMergeWindows {
    private GatherAndMergeWindows() {
    }

    public static Set<Rule<?>> rules() {
        return (Set)IntStream.range(0, 5).boxed().flatMap(numProjects -> Stream.of(new MergeAdjacentWindowsOverProjects((int)numProjects), new SwapAdjacentWindowsBySpecifications((int)numProjects))).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<VariableReferenceExpression> extractUnique(Assignments assignments) {
        Collection expressions = assignments.getExpressions();
        return VariablesExtractor.extractUnique(expressions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean dependsOn(WindowNode parent, WindowNode child) {
        if (parent.getPartitionBy().stream().anyMatch(child.getCreatedVariable()::contains)) return true;
        if (parent.getOrderingScheme().isPresent()) {
            if (parent.getOrderingScheme().get().getOrderByVariables().stream().anyMatch(child.getCreatedVariable()::contains)) return true;
        }
        if (parent.getWindowFunctions().values().stream().map(function -> VariablesExtractor.extractUnique(function.getFunctionCall().getArguments())).flatMap(Collection::stream).anyMatch(child.getCreatedVariable()::contains)) return true;
        if (!parent.getWindowFunctions().values().stream().map(function -> function.getFrame()).map(frame -> ImmutableList.of(frame.getStartValue(), frame.getEndValue(), frame.getSortKeyCoercedForFrameStartComparison(), frame.getSortKeyCoercedForFrameEndComparison())).flatMap(Collection::stream).anyMatch(x -> x.isPresent() && child.getCreatedVariable().contains(x.get()))) return false;
        return true;
    }

    public static class SwapAdjacentWindowsBySpecifications
    extends ManipulateAdjacentWindowsOverProjects {
        public SwapAdjacentWindowsBySpecifications(int numProjects) {
            super(numProjects);
        }

        @Override
        protected Optional<PlanNode> manipulateAdjacentWindowNodes(WindowNode parent, WindowNode child, Rule.Context context) {
            if (SwapAdjacentWindowsBySpecifications.compare(parent, child) < 0 && !GatherAndMergeWindows.dependsOn(parent, child)) {
                PlanNode transposedWindows = Util.transpose(parent, child);
                return Optional.of(Util.restrictOutputs(context.getIdAllocator(), transposedWindows, (Set<VariableReferenceExpression>)ImmutableSet.copyOf(parent.getOutputVariables())).orElse(transposedWindows));
            }
            return Optional.empty();
        }

        private static int compare(WindowNode o1, WindowNode o2) {
            int comparison = SwapAdjacentWindowsBySpecifications.comparePartitionBy(o1, o2);
            if (comparison != 0) {
                return comparison;
            }
            comparison = SwapAdjacentWindowsBySpecifications.compareOrderBy(o1, o2);
            if (comparison != 0) {
                return comparison;
            }
            return o1.getId().toString().compareTo(o2.getId().toString());
        }

        private static int comparePartitionBy(WindowNode o1, WindowNode o2) {
            Iterator<VariableReferenceExpression> iterator1 = o1.getPartitionBy().iterator();
            Iterator<VariableReferenceExpression> iterator2 = o2.getPartitionBy().iterator();
            while (iterator1.hasNext() && iterator2.hasNext()) {
                VariableReferenceExpression variable2;
                VariableReferenceExpression variable1 = iterator1.next();
                int partitionByComparison = variable1.compareTo(variable2 = iterator2.next());
                if (partitionByComparison == 0) continue;
                return partitionByComparison;
            }
            if (iterator1.hasNext()) {
                return 1;
            }
            if (iterator2.hasNext()) {
                return -1;
            }
            return 0;
        }

        private static int compareOrderBy(WindowNode o1, WindowNode o2) {
            if (!o1.getOrderingScheme().isPresent() && !o2.getOrderingScheme().isPresent()) {
                return 0;
            }
            if (o1.getOrderingScheme().isPresent() && !o2.getOrderingScheme().isPresent()) {
                return 1;
            }
            if (!o1.getOrderingScheme().isPresent() && o2.getOrderingScheme().isPresent()) {
                return -1;
            }
            OrderingScheme o1OrderingScheme = o1.getOrderingScheme().get();
            OrderingScheme o2OrderingScheme = o2.getOrderingScheme().get();
            Iterator iterator1 = o1OrderingScheme.getOrderByVariables().iterator();
            Iterator iterator2 = o2OrderingScheme.getOrderByVariables().iterator();
            while (iterator1.hasNext() && iterator2.hasNext()) {
                VariableReferenceExpression variable2;
                VariableReferenceExpression variable1 = (VariableReferenceExpression)iterator1.next();
                int orderByComparison = variable1.compareTo(variable2 = (VariableReferenceExpression)iterator2.next());
                if (orderByComparison != 0) {
                    return orderByComparison;
                }
                int sortOrderComparison = o1OrderingScheme.getOrdering(variable1).compareTo((Enum)o2OrderingScheme.getOrdering(variable2));
                if (sortOrderComparison == 0) continue;
                return sortOrderComparison;
            }
            if (iterator1.hasNext()) {
                return 1;
            }
            if (iterator2.hasNext()) {
                return -1;
            }
            return 0;
        }
    }

    public static class MergeAdjacentWindowsOverProjects
    extends ManipulateAdjacentWindowsOverProjects {
        public MergeAdjacentWindowsOverProjects(int numProjects) {
            super(numProjects);
        }

        @Override
        protected Optional<PlanNode> manipulateAdjacentWindowNodes(WindowNode parent, WindowNode child, Rule.Context context) {
            if (!child.getSpecification().equals(parent.getSpecification()) || GatherAndMergeWindows.dependsOn(parent, child)) {
                return Optional.empty();
            }
            ImmutableMap.Builder functionsBuilder = ImmutableMap.builder();
            functionsBuilder.putAll(parent.getWindowFunctions());
            functionsBuilder.putAll(child.getWindowFunctions());
            WindowNode mergedWindowNode = new WindowNode(parent.getSourceLocation(), parent.getId(), child.getSource(), parent.getSpecification(), (Map<VariableReferenceExpression, WindowNode.Function>)functionsBuilder.build(), parent.getHashVariable(), parent.getPrePartitionedInputs(), parent.getPreSortedOrderPrefix());
            return Optional.of(Util.restrictOutputs(context.getIdAllocator(), mergedWindowNode, (Set<VariableReferenceExpression>)ImmutableSet.copyOf(parent.getOutputVariables())).orElse(mergedWindowNode));
        }
    }

    private static abstract class ManipulateAdjacentWindowsOverProjects
    implements Rule<WindowNode> {
        private final Capture<WindowNode> childCapture = Capture.newCapture();
        private final List<Capture<ProjectNode>> projectCaptures;
        private final Pattern<WindowNode> pattern;

        protected ManipulateAdjacentWindowsOverProjects(int numProjects) {
            PropertyPattern childPattern = Patterns.source().matching(Patterns.window().capturedAs(this.childCapture));
            ImmutableList.Builder projectCapturesBuilder = ImmutableList.builder();
            for (int i = 0; i < numProjects; ++i) {
                Capture projectCapture = Capture.newCapture();
                projectCapturesBuilder.add((Object)projectCapture);
                childPattern = Patterns.source().matching(Patterns.project().capturedAs(projectCapture).with(childPattern));
            }
            this.projectCaptures = projectCapturesBuilder.build();
            this.pattern = Patterns.window().with(childPattern);
        }

        @Override
        public Pattern<WindowNode> getPattern() {
            return this.pattern;
        }

        @Override
        public Rule.Result apply(WindowNode parent, Captures captures, Rule.Context context) {
            List projects = (List)this.projectCaptures.stream().map(arg_0 -> ((Captures)captures).get(arg_0)).collect(ImmutableList.toImmutableList());
            return ManipulateAdjacentWindowsOverProjects.pullWindowNodeAboveProjects((WindowNode)((Object)captures.get(this.childCapture)), projects).flatMap(newChild -> this.manipulateAdjacentWindowNodes(parent, (WindowNode)((Object)newChild), context)).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
        }

        protected abstract Optional<PlanNode> manipulateAdjacentWindowNodes(WindowNode var1, WindowNode var2, Rule.Context var3);

        protected static Optional<WindowNode> pullWindowNodeAboveProjects(WindowNode target, List<ProjectNode> projects) {
            if (projects.isEmpty()) {
                return Optional.of(target);
            }
            PlanNode targetChild = target.getSource();
            ImmutableSet targetInputs = ImmutableSet.copyOf((Collection)targetChild.getOutputVariables());
            ImmutableSet targetOutputs = ImmutableSet.copyOf(target.getOutputVariables());
            PlanNode newTargetChild = targetChild;
            for (ProjectNode project : projects) {
                ImmutableSet newTargetChildOutputs = ImmutableSet.copyOf((Collection)newTargetChild.getOutputVariables());
                Map assignmentsWithoutTargetOutputIdentities = Maps.filterKeys((Map)project.getAssignments().getMap(), arg_0 -> ManipulateAdjacentWindowsOverProjects.lambda$pullWindowNodeAboveProjects$1(project, (Set)targetOutputs, arg_0));
                if (targetInputs.stream().anyMatch(assignmentsWithoutTargetOutputIdentities::containsKey)) {
                    return Optional.empty();
                }
                Assignments newAssignments = Assignments.builder().putAll(assignmentsWithoutTargetOutputIdentities).putAll(AssignmentUtils.identityAssignments((Collection<VariableReferenceExpression>)targetInputs)).build();
                if (!newTargetChildOutputs.containsAll(GatherAndMergeWindows.extractUnique(newAssignments))) {
                    return Optional.empty();
                }
                newTargetChild = new ProjectNode(project.getSourceLocation(), project.getId(), newTargetChild, newAssignments, project.getLocality());
            }
            WindowNode newTarget = (WindowNode)target.replaceChildren((List<PlanNode>)ImmutableList.of((Object)newTargetChild));
            ImmutableSet newTargetOutputs = ImmutableSet.copyOf(newTarget.getOutputVariables());
            if (!newTargetOutputs.containsAll(projects.get(projects.size() - 1).getOutputVariables())) {
                return Optional.empty();
            }
            return Optional.of(newTarget);
        }

        private static /* synthetic */ boolean lambda$pullWindowNodeAboveProjects$1(ProjectNode project, Set targetOutputs, VariableReferenceExpression output) {
            return !AssignmentUtils.isIdentity(project.getAssignments(), output) || !targetOutputs.contains(output);
        }
    }
}

