/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.sql.planner.iterative.properties.EquivalenceClassProperty;
import com.facebook.presto.sql.planner.iterative.properties.Key;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesImpl;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class KeyProperty {
    private final Set<Key> keys;

    public KeyProperty() {
        this.keys = ImmutableSet.of();
    }

    public KeyProperty(Set<Key> keys) {
        this.keys = ImmutableSet.copyOf((Collection)Objects.requireNonNull(keys, "keys is null"));
    }

    public KeyProperty(KeyProperty keyProperty) {
        this.keys = keyProperty.getKeys();
    }

    public Set<Key> getKeys() {
        return this.keys;
    }

    public boolean moreGeneral(KeyProperty otherKeyProperty) {
        return this.keys.isEmpty() && otherKeyProperty.keys.isEmpty() || otherKeyProperty.keys.stream().allMatch(this::satisfiesKeyRequirement);
    }

    public boolean satisfiesKeyRequirement(Key keyRequirement) {
        return this.keys.stream().anyMatch(k -> k.keySatisifiesRequirement(keyRequirement));
    }

    public static KeyProperty combineKeys(KeyProperty thisKeyProperty, KeyProperty otherKeyProperty) {
        return KeyProperty.combineKeys(thisKeyProperty.keys, otherKeyProperty.keys);
    }

    public static KeyProperty combineKeys(Set<Key> thisKeys, Set<Key> otherKeys) {
        Set<Key> newKeys = new HashSet<Key>(thisKeys);
        for (Key key : otherKeys) {
            newKeys = KeyProperty.combineKey(newKeys, key);
        }
        return new KeyProperty(newKeys);
    }

    public static Set<Key> combineKey(Set<Key> keys, Key newKey) {
        HashSet<Key> combinedKeys = new HashSet<Key>(keys);
        for (Key key : keys) {
            if (key.keySatisifiesRequirement(newKey)) {
                return keys;
            }
            if (!newKey.keySatisifiesRequirement(key)) continue;
            combinedKeys.remove(key);
        }
        combinedKeys.add(newKey);
        return combinedKeys;
    }

    public static Optional<KeyProperty> getNormalizedKeyProperty(KeyProperty keyProperty, EquivalenceClassProperty equivalenceClassProperty) {
        Set<Key> newKeys = new HashSet<Key>();
        for (Key key : keyProperty.keys) {
            Optional<Key> normalizedKey = Key.getNormalizedKey(key, equivalenceClassProperty);
            if (!normalizedKey.isPresent()) {
                return Optional.empty();
            }
            newKeys = KeyProperty.combineKey(newKeys, normalizedKey.get());
        }
        return Optional.of(new KeyProperty(newKeys));
    }

    public KeyProperty project(LogicalPropertiesImpl.InverseVariableMappingsWithEquivalence inverseVariableMappings) {
        Set<Key> newKeys = new HashSet<Key>();
        for (Key key : this.keys) {
            Optional<Key> projectedKey = key.project(inverseVariableMappings);
            if (!projectedKey.isPresent()) continue;
            newKeys = KeyProperty.combineKey(newKeys, projectedKey.get());
        }
        return new KeyProperty(newKeys);
    }

    public static KeyProperty concatKeyProperty(KeyProperty thisKeyProperty, KeyProperty toConcatKeyProp) {
        Set<Key> newKeys = new HashSet<Key>();
        for (Key thisKey : thisKeyProperty.keys) {
            for (Key toConcatKey : toConcatKeyProp.keys) {
                newKeys = KeyProperty.combineKey(newKeys, Key.concatKeys(thisKey, toConcatKey));
            }
        }
        return new KeyProperty(newKeys);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keys", (Object)this.keys.stream().map(Key::toString).collect(Collectors.joining(","))).toString();
    }
}

