/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import java.util.Objects;
import java.util.Optional;

public interface Rule<T> {
    public Pattern<T> getPattern();

    default public boolean isEnabled(Session session) {
        return true;
    }

    public Result apply(T var1, Captures var2, Context var3);

    public static final class Result {
        private final Optional<PlanNode> transformedPlan;

        public static Result empty() {
            return new Result(Optional.empty());
        }

        public static Result ofPlanNode(PlanNode transformedPlan) {
            return new Result(Optional.of(transformedPlan));
        }

        private Result(Optional<PlanNode> transformedPlan) {
            this.transformedPlan = Objects.requireNonNull(transformedPlan, "transformedPlan is null");
        }

        public Optional<PlanNode> getTransformedPlan() {
            return this.transformedPlan;
        }

        public boolean isEmpty() {
            return !this.transformedPlan.isPresent();
        }
    }

    public static interface Context {
        public Lookup getLookup();

        public PlanNodeIdAllocator getIdAllocator();

        public VariableAllocator getVariableAllocator();

        public Session getSession();

        public StatsProvider getStatsProvider();

        public CostProvider getCostProvider();

        public void checkTimeoutNotExhausted();

        public WarningCollector getWarningCollector();

        public Optional<LogicalPropertiesProvider> getLogicalPropertiesProvider();
    }
}

