/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PlannerUtils {
    public static final long INITIAL_HASH_VALUE = 0L;
    public static final String HASH_CODE = OperatorType.HASH_CODE.getFunctionName().getObjectName();

    private PlannerUtils() {
    }

    public static SortOrder toSortOrder(SortItem sortItem) {
        if (sortItem.getOrdering() == SortItem.Ordering.ASCENDING) {
            if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
                return SortOrder.ASC_NULLS_FIRST;
            }
            return SortOrder.ASC_NULLS_LAST;
        }
        if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
            return SortOrder.DESC_NULLS_FIRST;
        }
        return SortOrder.DESC_NULLS_LAST;
    }

    public static OrderingScheme toOrderingScheme(OrderBy orderBy, TypeProvider types) {
        return PlannerUtils.toOrderingScheme((List)orderBy.getSortItems().stream().map(SortItem::getSortKey).map(item -> {
            Preconditions.checkArgument((boolean)(item instanceof SymbolReference), (Object)"Sort items in order by must be symbol reference");
            return Expressions.variable(ExpressionTreeUtils.getSourceLocation((Node)item), ((SymbolReference)item).getName(), types.get((Expression)item));
        }).collect(ImmutableList.toImmutableList()), (List)orderBy.getSortItems().stream().map(PlannerUtils::toSortOrder).collect(ImmutableList.toImmutableList()));
    }

    public static OrderingScheme toOrderingScheme(List<VariableReferenceExpression> orderingSymbols, List<SortOrder> sortOrders) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet keysSeen = new HashSet();
        Streams.forEachPair(orderingSymbols.stream(), sortOrders.stream(), (variable, sortOrder) -> {
            if (!keysSeen.contains(variable)) {
                keysSeen.add(variable);
                builder.add((Object)new Ordering(variable, sortOrder));
            }
        });
        return new OrderingScheme((List)builder.build());
    }

    public static VariableReferenceExpression toVariableReference(Expression expression, TypeProvider types) {
        Preconditions.checkArgument((boolean)(expression instanceof SymbolReference));
        return Expressions.variable(ExpressionTreeUtils.getSourceLocation((Node)expression), ((SymbolReference)expression).getName(), types.get(expression));
    }

    public static Type createMapType(FunctionAndTypeManager functionAndTypeManager, Type keyType, Type valueType) {
        MethodHandle keyNativeEquals = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{keyType, keyType}))).getMethodHandle();
        MethodHandle keyNativeHashCode = functionAndTypeManager.getJavaScalarFunctionImplementation(functionAndTypeManager.resolveOperator(OperatorType.HASH_CODE, TypeSignatureProvider.fromTypes((Type[])new Type[]{keyType}))).getMethodHandle();
        return new MapType(keyType, valueType, keyNativeEquals, keyNativeHashCode);
    }

    public static RowExpression orNullHashCode(RowExpression expression) {
        Preconditions.checkArgument((boolean)BigintType.BIGINT.equals((Object)expression.getType()), (Object)"expression should be BIGINT type");
        return new SpecialFormExpression(expression.getSourceLocation(), SpecialFormExpression.Form.COALESCE, (Type)BigintType.BIGINT, new RowExpression[]{expression, Expressions.constant(0L, (Type)BigintType.BIGINT)});
    }

    public static Optional<RowExpression> getHashExpression(FunctionAndTypeManager functionAndTypeManager, List<VariableReferenceExpression> variables) {
        if (variables.isEmpty()) {
            return Optional.empty();
        }
        ConstantExpression result = Expressions.constant(0L, (Type)BigintType.BIGINT);
        for (VariableReferenceExpression variable : variables) {
            CallExpression hashField = Expressions.call(functionAndTypeManager, HASH_CODE, (Type)BigintType.BIGINT, new RowExpression[]{variable});
            hashField = PlannerUtils.orNullHashCode((RowExpression)hashField);
            result = Expressions.call(functionAndTypeManager, "combine_hash", (Type)BigintType.BIGINT, new RowExpression[]{result, hashField});
        }
        return Optional.of(result);
    }

    public static PlanNode addProjections(PlanNode source, PlanNodeIdAllocator planNodeIdAllocator, Map<VariableReferenceExpression, RowExpression> variableMap) {
        Assignments.Builder assignments = Assignments.builder();
        for (VariableReferenceExpression variableReferenceExpression : source.getOutputVariables()) {
            assignments.put(variableReferenceExpression, (RowExpression)variableReferenceExpression);
        }
        variableMap.forEach((arg_0, arg_1) -> ((Assignments.Builder)assignments).put(arg_0, arg_1));
        return new ProjectNode(source.getSourceLocation(), planNodeIdAllocator.getNextId(), source, assignments.build(), ProjectNode.Locality.LOCAL);
    }

    public static PlanNode restrictOutput(PlanNode source, PlanNodeIdAllocator planNodeIdAllocator, List<VariableReferenceExpression> outputVariables) {
        Assignments.Builder assignments = Assignments.builder();
        for (VariableReferenceExpression variableReferenceExpression : outputVariables) {
            assignments.put(variableReferenceExpression, (RowExpression)variableReferenceExpression);
        }
        return new ProjectNode(source.getSourceLocation(), planNodeIdAllocator.getNextId(), source, assignments.build(), ProjectNode.Locality.LOCAL);
    }

    public static PlanNode projectExpressions(PlanNode source, PlanNodeIdAllocator planNodeIdAllocator, VariableAllocator variableAllocator, List<? extends RowExpression> expressions, List<VariableReferenceExpression> variableMap) {
        Assignments.Builder assignments = Assignments.builder();
        Preconditions.checkArgument((variableMap.isEmpty() || variableMap.size() == expressions.size() ? 1 : 0) != 0);
        int i = 0;
        for (RowExpression rowExpression : expressions) {
            VariableReferenceExpression variable = variableMap.isEmpty() ? variableAllocator.newVariable(rowExpression) : variableMap.get(i++);
            assignments.put(variable, rowExpression);
        }
        return new ProjectNode(source.getSourceLocation(), planNodeIdAllocator.getNextId(), source, assignments.build(), ProjectNode.Locality.LOCAL);
    }

    public static PlanNode addProjections(PlanNode source, PlanNodeIdAllocator planNodeIdAllocator, VariableAllocator variableAllocator, List<RowExpression> expressions, List<VariableReferenceExpression> variablesToUse) {
        Assignments.Builder assignments = Assignments.builder();
        for (VariableReferenceExpression variableReferenceExpression : source.getOutputVariables()) {
            assignments.put(variableReferenceExpression, (RowExpression)variableReferenceExpression);
        }
        Preconditions.checkState((variablesToUse.isEmpty() || variablesToUse.size() == expressions.size() ? 1 : 0) != 0);
        for (int i = 0; i < expressions.size(); ++i) {
            RowExpression expression = expressions.get(i);
            VariableReferenceExpression variable = variablesToUse.isEmpty() ? variableAllocator.newVariable(expression) : variablesToUse.get(i);
            assignments.put(variable, expression);
        }
        return new ProjectNode(source.getSourceLocation(), planNodeIdAllocator.getNextId(), source, assignments.build(), ProjectNode.Locality.LOCAL);
    }

    public static PlanNode addAggregation(PlanNode planNode, FunctionAndTypeManager functionAndTypeManager, PlanNodeIdAllocator planNodeIdAllocator, VariableAllocator variableAllocator, String aggregationFunction, Type type, List<VariableReferenceExpression> groupingKeys, VariableReferenceExpression resultVariable, RowExpression ... args) {
        CallExpression callExpression = Expressions.call(functionAndTypeManager, aggregationFunction, type, args);
        ImmutableMap aggregationMap = ImmutableMap.of((Object)resultVariable, (Object)new AggregationNode.Aggregation(callExpression, Optional.empty(), Optional.empty(), false, Optional.empty()));
        AggregationNode.GroupingSetDescriptor groupingSetDescriptor = new AggregationNode.GroupingSetDescriptor(groupingKeys, 1, (Set)ImmutableSet.of((Object)1));
        return PlannerUtils.projectExpressions((PlanNode)new AggregationNode(Optional.empty(), planNodeIdAllocator.getNextId(), planNode, (Map)aggregationMap, groupingSetDescriptor, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), planNodeIdAllocator, variableAllocator, (List<? extends RowExpression>)ImmutableList.of((Object)resultVariable), (List<VariableReferenceExpression>)ImmutableList.of());
    }

    private static PlanNode cloneFilterNode(FilterNode filterNode, Session session, Metadata metadata, PlanNodeIdAllocator planNodeIdAllocator, List<VariableReferenceExpression> variablesToKeep, Map<VariableReferenceExpression, VariableReferenceExpression> varMap, PlanNodeIdAllocator idAllocator) {
        PlanNode newSource = PlannerUtils.clonePlanNode(filterNode.getSource(), session, metadata, planNodeIdAllocator, variablesToKeep, varMap);
        return new FilterNode(filterNode.getSourceLocation(), idAllocator.getNextId(), newSource, RowExpressionVariableInliner.inlineVariables(varMap, filterNode.getPredicate()));
    }

    private static PlanNode cloneProjectNode(ProjectNode projectNode, Session session, Metadata metadata, PlanNodeIdAllocator planNodeIdAllocator, List<VariableReferenceExpression> fieldsToKeep, Map<VariableReferenceExpression, VariableReferenceExpression> varMap, PlanNodeIdAllocator idAllocator) {
        PlanNode newSource = PlannerUtils.clonePlanNode(projectNode.getSource(), session, metadata, planNodeIdAllocator, fieldsToKeep, varMap);
        Assignments.Builder newAssignments = Assignments.builder();
        for (Map.Entry entry : projectNode.getAssignments().entrySet()) {
            VariableReferenceExpression var = (VariableReferenceExpression)entry.getKey();
            if (!varMap.containsKey(var)) {
                varMap.put(var, var);
            }
            newAssignments.put(varMap.getOrDefault(var, var), RowExpressionVariableInliner.inlineVariables(varMap, (RowExpression)entry.getValue()));
        }
        return new ProjectNode(idAllocator.getNextId(), newSource, newAssignments.build());
    }

    private static TableScanNode cloneTableScan(TableScanNode scanNode, Session session, Metadata metadata, PlanNodeIdAllocator planNodeIdAllocator, List<VariableReferenceExpression> fieldsToKeep, Map<VariableReferenceExpression, VariableReferenceExpression> varMap) {
        Map assignments = scanNode.getAssignments();
        TableLayout scanLayout = metadata.getLayout(session, scanNode.getTable());
        ImmutableList.Builder outputVariablesBuilder = ImmutableList.builder();
        ImmutableMap.Builder assignmentsBuilder = ImmutableMap.builder();
        for (VariableReferenceExpression var : scanNode.getOutputVariables()) {
            VariableReferenceExpression newVar = varMap.getOrDefault(var, var);
            outputVariablesBuilder.add((Object)newVar);
            assignmentsBuilder.put((Object)newVar, assignments.get(var));
            varMap.putIfAbsent(var, newVar);
        }
        ImmutableList newOutputVariables = outputVariablesBuilder.build();
        ImmutableMap newAssignments = assignmentsBuilder.build();
        return new TableScanNode(scanNode.getSourceLocation(), planNodeIdAllocator.getNextId(), scanLayout.getNewTableHandle(), (List)newOutputVariables, (Map)newAssignments, scanNode.getTableConstraints(), scanLayout.getPredicate(), scanNode.getEnforcedConstraint());
    }

    public static PlanNode clonePlanNode(PlanNode planNode, Session session, Metadata metadata, PlanNodeIdAllocator planNodeIdAllocator, List<VariableReferenceExpression> fieldsToKeep, Map<VariableReferenceExpression, VariableReferenceExpression> varMap) {
        if (planNode instanceof TableScanNode) {
            TableScanNode scanNode = (TableScanNode)planNode;
            return PlannerUtils.cloneTableScan(scanNode, session, metadata, planNodeIdAllocator, fieldsToKeep, varMap);
        }
        if (planNode instanceof FilterNode) {
            return PlannerUtils.cloneFilterNode((FilterNode)planNode, session, metadata, planNodeIdAllocator, fieldsToKeep, varMap, planNodeIdAllocator);
        }
        if (planNode instanceof ProjectNode) {
            return PlannerUtils.cloneProjectNode((ProjectNode)planNode, session, metadata, planNodeIdAllocator, fieldsToKeep, varMap, planNodeIdAllocator);
        }
        Preconditions.checkState((boolean)false, (Object)("Currently cannot clone: " + planNode.getClass().getName() + " nodes."));
        return null;
    }

    public static String getPlanString(PlanNode planNode, Session session, TypeProvider types, Metadata metadata, boolean isVerboseOptimizerInfoEnabled) {
        return PlanPrinter.textLogicalPlan(planNode, types, StatsAndCosts.empty(), metadata.getFunctionAndTypeManager(), session, 0, false, isVerboseOptimizerInfoEnabled);
    }

    private static String getNameHint(Expression expression) {
        String nameHint = "expr";
        if (expression instanceof Identifier) {
            nameHint = ((Identifier)expression).getValue();
        } else if (expression instanceof FunctionCall) {
            nameHint = ((FunctionCall)expression).getName().getSuffix();
        } else if (expression instanceof SymbolReference) {
            nameHint = ((SymbolReference)expression).getName();
        } else if (expression instanceof GroupingOperation) {
            nameHint = "grouping";
        }
        return nameHint;
    }

    public static VariableReferenceExpression newVariable(VariableAllocator variableAllocator, Expression expression, Type type, String suffix) {
        return variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)expression), PlannerUtils.getNameHint(expression), type, suffix);
    }

    public static VariableReferenceExpression newVariable(VariableAllocator variableAllocator, Expression expression, Type type) {
        return variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)expression), PlannerUtils.getNameHint(expression), type, null);
    }

    public static VariableReferenceExpression newVariable(VariableAllocator variableAllocator, Field field) {
        return variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation(field.getNodeLocation()), field.getName().orElse("field"), field.getType(), null);
    }

    public static VariableReferenceExpression newVariable(VariableAllocator variableAllocator, Optional<SourceLocation> sourceLocation, Field field) {
        return variableAllocator.newVariable(sourceLocation, field.getName().orElse("field"), field.getType(), null);
    }

    public static VariableReferenceExpression toVariableReference(VariableAllocator variableAllocator, Expression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof SymbolReference), (Object)("Unexpected expression: " + expression));
        String name = ((SymbolReference)expression).getName();
        return variableAllocator.getVariableReferenceExpression(ExpressionTreeUtils.getSourceLocation((Node)expression), name);
    }

    public static Optional<TableScanNode> getTableScanNodeWithOnlyFilterAndProject(PlanNode source) {
        if (source instanceof FilterNode) {
            return PlannerUtils.getTableScanNodeWithOnlyFilterAndProject(((FilterNode)source).getSource());
        }
        if (source instanceof ProjectNode) {
            return PlannerUtils.getTableScanNodeWithOnlyFilterAndProject(((ProjectNode)source).getSource());
        }
        if (source instanceof TableScanNode) {
            return Optional.of((TableScanNode)source);
        }
        return Optional.empty();
    }

    public static boolean isFilterAboveTableScan(PlanNode node) {
        return node instanceof FilterNode && ((FilterNode)node).getSource() instanceof TableScanNode;
    }

    public static boolean isProjectAboveTableScan(PlanNode node) {
        return node instanceof ProjectNode && ((ProjectNode)node).getSource() instanceof TableScanNode;
    }

    public static boolean isScanFilterProject(PlanNode node) {
        return node instanceof TableScanNode || node instanceof ProjectNode && PlannerUtils.isScanFilterProject(((ProjectNode)node).getSource()) || node instanceof FilterNode && PlannerUtils.isScanFilterProject(((FilterNode)node).getSource());
    }

    public static CallExpression equalityPredicate(FunctionResolution functionResolution, RowExpression leftExpr, RowExpression rightExpr) {
        return new CallExpression(OperatorType.EQUAL.name(), functionResolution.comparisonFunction(ComparisonExpression.Operator.EQUAL, (Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), (Type)BooleanType.BOOLEAN, Arrays.asList(leftExpr, rightExpr));
    }

    public static RowExpression coalesce(List<RowExpression> expressions) {
        return new SpecialFormExpression(SpecialFormExpression.Form.COALESCE, expressions.get(0).getType(), expressions);
    }

    public static boolean isSupportedArrayContainsFilter(FunctionResolution functionResolution, RowExpression filterExpression, List<VariableReferenceExpression> left, List<VariableReferenceExpression> right) {
        CallExpression callExpression;
        ImmutableList supportedTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR, (Object)DateType.DATE);
        if (filterExpression instanceof CallExpression && functionResolution.isArrayContainsFunction((callExpression = (CallExpression)filterExpression).getFunctionHandle())) {
            RowExpression array = (RowExpression)callExpression.getArguments().get(0);
            RowExpression element = (RowExpression)callExpression.getArguments().get(1);
            Preconditions.checkState((array.getType() instanceof ArrayType && ((ArrayType)array.getType()).getElementType().equals(element.getType()) ? 1 : 0) != 0);
            List<VariableReferenceExpression> arrayExpressionColumns = VariablesExtractor.extractAll(array);
            boolean isSupportedType = supportedTypes.contains(element.getType()) || element.getType() instanceof VarcharType;
            return isSupportedType && (left.contains(array) && right.contains(element) || right.contains(array) && left.contains(element));
        }
        return false;
    }

    public static boolean isNegationExpression(FunctionResolution functionResolution, RowExpression expression) {
        return expression instanceof CallExpression && functionResolution.isNotFunction(((CallExpression)expression).getFunctionHandle());
    }

    public static boolean isBroadcastJoin(JoinNode joinNode) {
        return joinNode.getDistributionType().isPresent() && joinNode.getDistributionType().get() == JoinNode.DistributionType.REPLICATED;
    }
}

