/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.sql.planner.CanonicalPlan;
import com.facebook.presto.sql.planner.CanonicalPlanWithInfo;
import com.facebook.presto.sql.planner.PlanCanonicalInfoProvider;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Traverser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PlanNodeCanonicalInfo {
    private final String hash;
    private final List<PlanStatistics> inputTableStatistics;

    @JsonCreator
    public PlanNodeCanonicalInfo(@JsonProperty(value="hash") String hash, @JsonProperty(value="inputTableStatistics") List<PlanStatistics> inputTableStatistics) {
        this.hash = Objects.requireNonNull(hash, "hash is null");
        this.inputTableStatistics = Objects.requireNonNull(inputTableStatistics, "inputTableStatistics is null");
    }

    @JsonProperty
    public String getHash() {
        return this.hash;
    }

    @JsonProperty
    public List<PlanStatistics> getInputTableStatistics() {
        return this.inputTableStatistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNodeCanonicalInfo that = (PlanNodeCanonicalInfo)o;
        return this.hash == that.hash && this.inputTableStatistics.equals(that.inputTableStatistics);
    }

    public int hashCode() {
        return Objects.hash(System.identityHashCode(this.hash), this.inputTableStatistics);
    }

    public static List<CanonicalPlanWithInfo> getCanonicalInfo(Session session, PlanNode root, PlanCanonicalInfoProvider planCanonicalInfoProvider) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (PlanCanonicalizationStrategy strategy : PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList()) {
            for (PlanNode node : Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root)) {
                if (!node.getStatsEquivalentPlanNode().isPresent()) continue;
                PlanNode statsEquivalentPlanNode = (PlanNode)node.getStatsEquivalentPlanNode().get();
                Optional<String> hash = planCanonicalInfoProvider.hash(session, statsEquivalentPlanNode, strategy);
                Optional<List<PlanStatistics>> inputTableStatistics = planCanonicalInfoProvider.getInputTableStatistics(session, statsEquivalentPlanNode);
                if (!hash.isPresent() || !inputTableStatistics.isPresent()) continue;
                result.add((Object)new CanonicalPlanWithInfo(new CanonicalPlan(statsEquivalentPlanNode, strategy), new PlanNodeCanonicalInfo(hash.get(), inputTableStatistics.get())));
            }
        }
        return result.build();
    }
}

