/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.SqlPlannerContext;
import com.facebook.presto.sql.planner.TranslateExpressionsUtil;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

class PlanBuilder {
    private final TranslationMap translations;
    private final PlanNode root;

    public PlanBuilder(TranslationMap translations, PlanNode root) {
        Objects.requireNonNull(translations, "translations is null");
        Objects.requireNonNull(root, "root is null");
        this.translations = translations;
        this.root = root;
    }

    public TranslationMap copyTranslations() {
        TranslationMap translations = new TranslationMap(this.getRelationPlan(), this.getAnalysis(), this.getTranslations().getLambdaDeclarationToVariableMap());
        translations.copyMappingsFrom(this.getTranslations());
        return translations;
    }

    private Analysis getAnalysis() {
        return this.translations.getAnalysis();
    }

    public PlanBuilder withNewRoot(PlanNode root) {
        return new PlanBuilder(this.translations, root);
    }

    public RelationPlan getRelationPlan() {
        return this.translations.getRelationPlan();
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public boolean canTranslate(Expression expression) {
        return this.translations.containsSymbol(expression);
    }

    public VariableReferenceExpression translate(Expression expression) {
        return this.translations.get(expression);
    }

    public VariableReferenceExpression translateToVariable(Expression expression) {
        return this.translations.get(expression);
    }

    public Expression rewrite(Expression expression) {
        return this.translations.rewrite(expression);
    }

    public TranslationMap getTranslations() {
        return this.translations;
    }

    public PlanBuilder appendProjections(Iterable<Expression> expressions, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Session session, Metadata metadata, SqlParser sqlParser, Analysis analysis, SqlPlannerContext context) {
        TranslationMap translations = this.copyTranslations();
        Assignments.Builder projections = Assignments.builder();
        for (VariableReferenceExpression variable : this.getRoot().getOutputVariables()) {
            projections.put(variable, (RowExpression)variable);
        }
        ImmutableMap.Builder newTranslations = ImmutableMap.builder();
        for (Expression expression : expressions) {
            VariableReferenceExpression variable = PlannerUtils.newVariable(variableAllocator, expression, this.getAnalysis().getTypeWithCoercions(expression));
            projections.put(variable, this.rowExpression(translations.rewrite(expression), context, session, metadata, sqlParser, analysis, variableAllocator));
            newTranslations.put((Object)variable, (Object)expression);
        }
        for (Map.Entry entry : newTranslations.build().entrySet()) {
            translations.put((Expression)entry.getValue(), (VariableReferenceExpression)entry.getKey());
        }
        return new PlanBuilder(translations, (PlanNode)new ProjectNode(idAllocator.getNextId(), this.getRoot(), projections.build()));
    }

    private RowExpression rowExpression(Expression expression, SqlPlannerContext context, Session session, Metadata metadata, SqlParser sqlParser, Analysis analysis, VariableAllocator variableAllocator) {
        return TranslateExpressionsUtil.toRowExpression(expression, metadata, session, sqlParser, variableAllocator, analysis, context.getTranslatorContext());
    }
}

