/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PropertyDerivations;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Partitioning {
    private final PartitioningHandle handle;
    private final List<RowExpression> arguments;

    private Partitioning(PartitioningHandle handle, List<RowExpression> arguments) {
        this.handle = Objects.requireNonNull(handle, "handle is null");
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
    }

    public static <T extends RowExpression> Partitioning create(PartitioningHandle handle, Collection<T> columns) {
        return new Partitioning(handle, (List)columns.stream().map(RowExpression.class::cast).collect(ImmutableList.toImmutableList()));
    }

    @JsonCreator
    public static Partitioning jsonCreate(@JsonProperty(value="handle") PartitioningHandle handle, @JsonProperty(value="arguments") List<RowExpression> arguments) {
        return new Partitioning(handle, arguments);
    }

    @JsonProperty
    public PartitioningHandle getHandle() {
        return this.handle;
    }

    @JsonProperty
    public List<RowExpression> getArguments() {
        return this.arguments;
    }

    public Set<VariableReferenceExpression> getVariableReferences() {
        return (Set)this.arguments.stream().filter(VariableReferenceExpression.class::isInstance).map(VariableReferenceExpression.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    @Deprecated
    public boolean isCompatibleWith(Partitioning right, Metadata metadata, Session session) {
        if (!this.handle.equals(right.handle) && !metadata.getCommonPartitioning(session, this.handle, right.handle).isPresent()) {
            return false;
        }
        return this.arguments.equals(right.arguments);
    }

    @Deprecated
    public boolean isCompatibleWith(Partitioning right, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> leftToRightMappings, Function<VariableReferenceExpression, Optional<ConstantExpression>> leftConstantMapping, Function<VariableReferenceExpression, Optional<ConstantExpression>> rightConstantMapping, Metadata metadata, Session session) {
        if (!this.handle.equals(right.handle) && !metadata.getCommonPartitioning(session, this.handle, right.handle).isPresent()) {
            return false;
        }
        if (this.arguments.size() != right.arguments.size()) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            RowExpression rightArgument;
            RowExpression leftArgument = this.arguments.get(i);
            if (Partitioning.isPartitionedWith(leftArgument, leftConstantMapping, rightArgument = right.arguments.get(i), rightConstantMapping, leftToRightMappings)) continue;
            return false;
        }
        return true;
    }

    public boolean isRefinedPartitioningOver(Partitioning right, Metadata metadata, Session session) {
        if (!this.handle.equals(right.handle) && !metadata.isRefinedPartitioningOver(session, this.handle, right.handle)) {
            return false;
        }
        return this.arguments.equals(right.arguments);
    }

    public boolean isRefinedPartitioningOver(Partitioning right, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> leftToRightMappings, Function<VariableReferenceExpression, Optional<ConstantExpression>> leftConstantMapping, Function<VariableReferenceExpression, Optional<ConstantExpression>> rightConstantMapping, Metadata metadata, Session session) {
        if (!metadata.isRefinedPartitioningOver(session, this.handle, right.handle)) {
            return false;
        }
        if (this.arguments.size() != right.arguments.size()) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            RowExpression rightArgument;
            RowExpression leftArgument = this.arguments.get(i);
            if (Partitioning.isPartitionedWith(leftArgument, leftConstantMapping, rightArgument = right.arguments.get(i), rightConstantMapping, leftToRightMappings)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPartitionedWith(RowExpression leftArgument, Function<VariableReferenceExpression, Optional<ConstantExpression>> leftConstantMapping, RowExpression rightArgument, Function<VariableReferenceExpression, Optional<ConstantExpression>> rightConstantMapping, Function<VariableReferenceExpression, Set<VariableReferenceExpression>> leftToRightMappings) {
        if (leftArgument instanceof VariableReferenceExpression) {
            if (rightArgument instanceof VariableReferenceExpression) {
                Set<VariableReferenceExpression> mappedColumns = leftToRightMappings.apply((VariableReferenceExpression)leftArgument);
                return mappedColumns.contains(rightArgument);
            }
            if (rightArgument instanceof ConstantExpression) {
                Optional<ConstantExpression> leftConstant = leftConstantMapping.apply((VariableReferenceExpression)leftArgument);
                return leftConstant.isPresent() && leftConstant.get().equals((Object)rightArgument);
            }
            return false;
        }
        if (leftArgument instanceof ConstantExpression) {
            if (rightArgument instanceof ConstantExpression) {
                return leftArgument.equals((Object)rightArgument);
            }
            if (rightArgument instanceof VariableReferenceExpression) {
                Optional<ConstantExpression> rightConstant = rightConstantMapping.apply((VariableReferenceExpression)rightArgument);
                return rightConstant.isPresent() && rightConstant.get().equals((Object)leftArgument);
            }
            return false;
        }
        return false;
    }

    public boolean isPartitionedOn(Collection<VariableReferenceExpression> columns, Set<VariableReferenceExpression> knownConstants) {
        for (RowExpression argument : this.arguments) {
            if (argument instanceof ConstantExpression) continue;
            if (!(argument instanceof VariableReferenceExpression)) {
                return false;
            }
            if (knownConstants.contains(argument) || columns.contains(argument)) continue;
            return false;
        }
        return true;
    }

    public boolean isPartitionedOnExactly(Collection<VariableReferenceExpression> columns, Set<VariableReferenceExpression> knownConstants) {
        HashSet<VariableReferenceExpression> toCheck = new HashSet<VariableReferenceExpression>();
        for (RowExpression argument : this.arguments) {
            if (argument instanceof ConstantExpression) continue;
            if (!(argument instanceof VariableReferenceExpression)) {
                return false;
            }
            if (knownConstants.contains(argument)) continue;
            toCheck.add((VariableReferenceExpression)argument);
        }
        return ImmutableSet.copyOf(columns).equals(toCheck);
    }

    public boolean isEffectivelySinglePartition(Set<VariableReferenceExpression> knownConstants) {
        return this.isPartitionedOn((Collection<VariableReferenceExpression>)ImmutableSet.of(), knownConstants);
    }

    public boolean isRepartitionEffective(Collection<VariableReferenceExpression> keys, Set<VariableReferenceExpression> knownConstants) {
        Set keysWithoutConstants = (Set)keys.stream().filter(variable -> !knownConstants.contains(variable)).collect(ImmutableSet.toImmutableSet());
        Set nonConstantArgs = (Set)this.arguments.stream().filter(VariableReferenceExpression.class::isInstance).map(VariableReferenceExpression.class::cast).filter(variable -> !knownConstants.contains(variable)).collect(ImmutableSet.toImmutableSet());
        return !nonConstantArgs.equals(keysWithoutConstants);
    }

    public Partitioning translateVariable(Function<VariableReferenceExpression, VariableReferenceExpression> translator) {
        return new Partitioning(this.handle, (List)this.arguments.stream().map(argument -> {
            if (argument instanceof VariableReferenceExpression) {
                return (RowExpression)translator.apply((VariableReferenceExpression)argument);
            }
            return argument;
        }).collect(ImmutableList.toImmutableList()));
    }

    public Optional<Partitioning> translateVariableToRowExpression(Function<VariableReferenceExpression, Optional<RowExpression>> translator) {
        ImmutableList.Builder newArguments = ImmutableList.builder();
        for (RowExpression argument : this.arguments) {
            if (argument instanceof ConstantExpression) {
                newArguments.add((Object)argument);
                continue;
            }
            if (argument instanceof VariableReferenceExpression) {
                Optional<RowExpression> newArgument = translator.apply((VariableReferenceExpression)argument);
                if (!newArgument.isPresent()) {
                    return Optional.empty();
                }
                newArguments.add((Object)newArgument.get());
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(new Partitioning(this.handle, (List<RowExpression>)newArguments.build()));
    }

    public Optional<Partitioning> translateToCoalesce(Partitioning other, Metadata metadata, Session session) {
        Preconditions.checkArgument((boolean)PropertyDerivations.arePartitionHandlesCompatibleForCoalesce(this.handle, other.handle, metadata, session), (String)"incompatible partitioning handles: cannot coalesce %s and %s", (Object)this.handle, (Object)other.handle);
        Preconditions.checkArgument((this.arguments.size() == other.arguments.size() ? 1 : 0) != 0, (String)"incompatible number of partitioning arguments: %s != %s", (int)this.arguments.size(), (int)other.arguments.size());
        ImmutableList.Builder arguments = ImmutableList.builder();
        for (int i = 0; i < this.arguments.size(); ++i) {
            RowExpression leftArgument = this.arguments.get(i);
            RowExpression rightArgument = other.arguments.get(i);
            if (leftArgument instanceof ConstantExpression) {
                arguments.add((Object)leftArgument);
                continue;
            }
            if (rightArgument instanceof ConstantExpression) {
                arguments.add((Object)rightArgument);
                continue;
            }
            if (leftArgument instanceof VariableReferenceExpression && rightArgument instanceof VariableReferenceExpression) {
                VariableReferenceExpression leftVariable = (VariableReferenceExpression)leftArgument;
                VariableReferenceExpression rightVariable = (VariableReferenceExpression)rightArgument;
                Preconditions.checkArgument((boolean)leftVariable.getType().equals(rightVariable.getType()), (String)"incompatible types: %s != %s", (Object)leftVariable.getType(), (Object)rightVariable.getType());
                arguments.add((Object)new SpecialFormExpression(SpecialFormExpression.Form.COALESCE, leftVariable.getType(), (List)ImmutableList.of((Object)leftVariable, (Object)rightVariable)));
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(new Partitioning(metadata.isRefinedPartitioningOver(session, other.handle, this.handle) ? this.handle : other.handle, (List<RowExpression>)arguments.build()));
    }

    public Optional<Partitioning> translateRowExpression(Map<VariableReferenceExpression, RowExpression> inputToOutputMappings, Map<VariableReferenceExpression, RowExpression> assignments, TypeProvider types) {
        ImmutableList.Builder newArguments = ImmutableList.builder();
        for (RowExpression argument : this.arguments) {
            if (argument instanceof ConstantExpression) {
                newArguments.add((Object)argument);
                continue;
            }
            if (argument instanceof VariableReferenceExpression) {
                if (!inputToOutputMappings.containsKey(argument)) {
                    return Optional.empty();
                }
                newArguments.add((Object)inputToOutputMappings.get(argument));
                continue;
            }
            Preconditions.checkArgument((argument instanceof SpecialFormExpression && ((SpecialFormExpression)argument).getForm().equals((Object)SpecialFormExpression.Form.COALESCE) ? 1 : 0) != 0, (Object)String.format("Expect argument to be COALESCE but get %s", argument));
            ImmutableSet coalesceArguments = ImmutableSet.copyOf((Collection)((SpecialFormExpression)argument).getArguments());
            Preconditions.checkArgument((boolean)coalesceArguments.stream().allMatch(VariableReferenceExpression.class::isInstance), (Object)String.format("Expect arguments of COALESCE to be VariableReferenceExpression but get %s", coalesceArguments));
            VariableReferenceExpression translated = null;
            for (Map.Entry<VariableReferenceExpression, RowExpression> entry : assignments.entrySet()) {
                if (!(entry.getValue() instanceof SpecialFormExpression) || !((SpecialFormExpression)entry.getValue()).getForm().equals((Object)SpecialFormExpression.Form.COALESCE)) continue;
                ImmutableSet assignmentArguments = ImmutableSet.copyOf((Collection)((SpecialFormExpression)entry.getValue()).getArguments());
                if (!assignmentArguments.stream().allMatch(VariableReferenceExpression.class::isInstance) || !assignmentArguments.equals(coalesceArguments)) continue;
                translated = entry.getKey();
                break;
            }
            if (translated == null) {
                return Optional.empty();
            }
            newArguments.add(translated);
        }
        return Optional.of(new Partitioning(this.handle, (List<RowExpression>)newArguments.build()));
    }

    public Partitioning withAlternativePartitioningHandle(PartitioningHandle partitioningHandle) {
        return new Partitioning(partitioningHandle, this.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.handle, this.arguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Partitioning other = (Partitioning)obj;
        return Objects.equals(this.handle, other.handle) && Objects.equals(this.arguments, other.arguments);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("handle", (Object)this.handle).add("arguments", this.arguments).toString();
    }
}

