/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.AbstractJoinNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class LocalDynamicFilter {
    private final Multimap<String, DynamicFilters.DynamicFilterPlaceholder> probeVariables;
    private final Map<String, Integer> buildChannels;
    private final SettableFuture<TupleDomain<VariableReferenceExpression>> resultFuture;
    private final int partitionCount;
    private final List<TupleDomain<String>> partitions;

    public LocalDynamicFilter(Multimap<String, DynamicFilters.DynamicFilterPlaceholder> probeVariables, Map<String, Integer> buildChannels, int partitionCount) {
        this.probeVariables = Objects.requireNonNull(probeVariables, "probeVariables is null");
        this.buildChannels = Objects.requireNonNull(buildChannels, "buildChannels is null");
        Verify.verify((boolean)probeVariables.keySet().equals(buildChannels.keySet()), (String)"probeVariables and buildChannels must have same keys", (Object[])new Object[0]);
        this.resultFuture = SettableFuture.create();
        this.partitionCount = partitionCount;
        this.partitions = new ArrayList<TupleDomain<String>>(partitionCount);
    }

    private synchronized void addPartition(TupleDomain<String> tupleDomain) {
        Verify.verify((this.partitions.size() < this.partitionCount ? 1 : 0) != 0);
        this.partitions.add(tupleDomain);
        if (this.partitions.size() == this.partitionCount) {
            TupleDomain<VariableReferenceExpression> result = this.convertTupleDomain((TupleDomain<String>)TupleDomain.columnWiseUnion(this.partitions));
            Verify.verify((boolean)this.resultFuture.set(result), (String)"dynamic filter result is provided more than once", (Object[])new Object[0]);
        }
    }

    private TupleDomain<VariableReferenceExpression> convertTupleDomain(TupleDomain<String> result) {
        if (result.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)result.getDomains().get()).entrySet()) {
            Domain domain = (Domain)entry.getValue();
            for (DynamicFilters.DynamicFilterPlaceholder placeholder : this.probeVariables.get(entry.getKey())) {
                Domain updatedDomain = placeholder.applyComparison(domain);
                builder.put((Object)((VariableReferenceExpression)placeholder.getInput()), (Object)updatedDomain);
            }
        }
        return TupleDomain.withColumnDomains((Map)builder.build());
    }

    public static Optional<LocalDynamicFilter> create(AbstractJoinNode planNode, int partitionCount) {
        Set<String> joinDynamicFilters = planNode.getDynamicFilters().keySet();
        List filterNodes = PlanNodeSearcher.searchFrom(planNode.getProbe()).where(PlannerUtils::isFilterAboveTableScan).findAll();
        ImmutableMultimap.Builder probeVariablesBuilder = ImmutableMultimap.builder();
        for (FilterNode filterNode : filterNodes) {
            DynamicFilters.DynamicFilterExtractResult extractResult = DynamicFilters.extractDynamicFilters((RowExpression)filterNode.getPredicate());
            for (DynamicFilters.DynamicFilterPlaceholder placeholder : extractResult.getDynamicConjuncts()) {
                if (!(placeholder.getInput() instanceof VariableReferenceExpression) || !joinDynamicFilters.contains(placeholder.getId())) continue;
                probeVariablesBuilder.put((Object)placeholder.getId(), (Object)placeholder);
            }
        }
        ImmutableMultimap probeVariables = probeVariablesBuilder.build();
        PlanNode buildNode = planNode.getBuild();
        Map<String, Integer> buildChannels = planNode.getDynamicFilters().entrySet().stream().filter(arg_0 -> LocalDynamicFilter.lambda$create$0((Multimap)probeVariables, arg_0)).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            VariableReferenceExpression buildVariable = (VariableReferenceExpression)entry.getValue();
            int buildChannelIndex = buildNode.getOutputVariables().indexOf(buildVariable);
            Verify.verify((buildChannelIndex >= 0 ? 1 : 0) != 0);
            return buildChannelIndex;
        }));
        if (buildChannels.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new LocalDynamicFilter((Multimap<String, DynamicFilters.DynamicFilterPlaceholder>)probeVariables, buildChannels, partitionCount));
    }

    public Map<String, Integer> getBuildChannels() {
        return this.buildChannels;
    }

    public ListenableFuture<TupleDomain<VariableReferenceExpression>> getResultFuture() {
        return this.resultFuture;
    }

    public Consumer<TupleDomain<String>> getTupleDomainConsumer() {
        return this::addPartition;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("probeVariables", this.probeVariables).add("buildChannels", this.buildChannels).add("partitionCount", this.partitionCount).add("partitions", this.partitions).toString();
    }

    private static /* synthetic */ boolean lambda$create$0(Multimap probeVariables, Map.Entry entry) {
        return probeVariables.containsKey(entry.getKey());
    }
}

