/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.NullabilityAnalyzer;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.ExpressionEquivalence;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class InequalityInference {
    private final Set<RowExpression> inequalityExpressions;
    private final FunctionAndTypeManager functionAndTypeManager;
    private final ExpressionEquivalence expressionEquivalence;
    private final Optional<Collection<VariableReferenceExpression>> outerVariables;

    public InequalityInference(Set<RowExpression> inequalityExpressions, FunctionAndTypeManager functionAndTypeManager, ExpressionEquivalence expressionEquivalence, Optional<Collection<VariableReferenceExpression>> outerVariables) {
        if (inequalityExpressions.stream().anyMatch(e -> !EqualityInference.isOperation(e, OperatorType.LESS_THAN, functionAndTypeManager) && !EqualityInference.isOperation(e, OperatorType.LESS_THAN_OR_EQUAL, functionAndTypeManager))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "all inequality expressions for inference must be < or <=");
        }
        this.inequalityExpressions = Objects.requireNonNull(inequalityExpressions, "inequalityExpressions is null");
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.expressionEquivalence = Objects.requireNonNull(expressionEquivalence, "expressionEquivalence is null");
        this.outerVariables = Objects.requireNonNull(outerVariables, "outerVariables is null");
    }

    public Set<RowExpression> inferInequalities() {
        if (this.inequalityExpressions.size() < 2) {
            return ImmutableSet.of();
        }
        HashSet<RowExpression> allInferredInequalities = new HashSet<RowExpression>();
        Set<Object> inequalitiesInferredInCurrentTraversal = new HashSet<RowExpression>(this.inequalityExpressions);
        HashSet exploredCombinations = new HashSet();
        while (!allInferredInequalities.containsAll(inequalitiesInferredInCurrentTraversal)) {
            allInferredInequalities.addAll(inequalitiesInferredInCurrentTraversal);
            Set newCombinations = (Set)Sets.combinations(allInferredInequalities, (int)2).stream().filter(subset -> !exploredCombinations.contains(subset)).collect(ImmutableSet.toImmutableSet());
            inequalitiesInferredInCurrentTraversal = (Set)newCombinations.stream().map(pair -> {
                Iterator it = pair.iterator();
                return this.compareAndExtractInequalities((RowExpression)it.next(), (RowExpression)it.next());
            }).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet());
            exploredCombinations.addAll(newCombinations);
        }
        allInferredInequalities.removeAll(this.inequalityExpressions);
        return ImmutableSet.copyOf(allInferredInequalities);
    }

    private Optional<RowExpression> compareAndExtractInequalities(RowExpression expression1, RowExpression expression2) {
        CallExpression firstConjunct = (CallExpression)expression1;
        OperatorType firstOperatorType = (OperatorType)this.functionAndTypeManager.getFunctionMetadata(firstConjunct.getFunctionHandle()).getOperatorType().get();
        CallExpression secondConjunct = (CallExpression)expression2;
        OperatorType secondOperatorType = (OperatorType)this.functionAndTypeManager.getFunctionMetadata(secondConjunct.getFunctionHandle()).getOperatorType().get();
        Optional<OperatorType> inferenceOperatorType = this.getComparisonInferenceOperatorType(secondOperatorType, firstOperatorType);
        if (!inferenceOperatorType.isPresent()) {
            return Optional.empty();
        }
        RowExpression firstConjunctLHS = (RowExpression)firstConjunct.getArguments().get(0);
        RowExpression firstConjunctRHS = (RowExpression)firstConjunct.getArguments().get(1);
        RowExpression secondConjunctLHS = (RowExpression)secondConjunct.getArguments().get(0);
        RowExpression secondConjunctRHS = (RowExpression)secondConjunct.getArguments().get(1);
        Optional<Object> inferredFirstArgument = Optional.empty();
        Optional<Object> inferredSecondArgument = Optional.empty();
        Object variablesReferencedInInferredPredicate = ImmutableSet.of();
        if (this.expressionEquivalence.areExpressionsEquivalent(firstConjunctRHS, secondConjunctLHS)) {
            variablesReferencedInInferredPredicate = InequalityInference.getVariablesReferencedInInferredPredicate(firstConjunctLHS, secondConjunctRHS);
            if (!variablesReferencedInInferredPredicate.isEmpty()) {
                inferredFirstArgument = Optional.of(firstConjunctLHS);
                inferredSecondArgument = Optional.of(secondConjunctRHS);
            }
        } else if (this.expressionEquivalence.areExpressionsEquivalent(firstConjunctLHS, secondConjunctRHS) && !(variablesReferencedInInferredPredicate = InequalityInference.getVariablesReferencedInInferredPredicate(firstConjunctRHS, secondConjunctLHS)).isEmpty()) {
            inferredFirstArgument = Optional.of(secondConjunctLHS);
            inferredSecondArgument = Optional.of(firstConjunctRHS);
        }
        if (!inferredFirstArgument.isPresent() || !inferredSecondArgument.isPresent() || this.outerVariables.isPresent() && Iterables.any((Iterable)variablesReferencedInInferredPredicate, (Predicate)Predicates.in(this.outerVariables.get()))) {
            return Optional.empty();
        }
        FunctionHandle inferredComparatorFunctionHandle = this.functionAndTypeManager.resolveOperator(inferenceOperatorType.get(), TypeSignatureProvider.fromTypes((Type[])new Type[]{((RowExpression)inferredFirstArgument.get()).getType(), ((RowExpression)inferredSecondArgument.get()).getType()}));
        return Optional.of(new CallExpression(inferenceOperatorType.toString(), inferredComparatorFunctionHandle, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)inferredFirstArgument.get(), (Object)inferredSecondArgument.get())));
    }

    private Optional<OperatorType> getComparisonInferenceOperatorType(OperatorType operator1, OperatorType operator2) {
        Optional<OperatorType> inferenceType = Optional.empty();
        if (operator1.equals((Object)OperatorType.LESS_THAN)) {
            if (operator2.equals((Object)OperatorType.LESS_THAN) || operator2.equals((Object)OperatorType.LESS_THAN_OR_EQUAL)) {
                inferenceType = Optional.of(OperatorType.LESS_THAN);
            }
        } else if (operator1.equals((Object)OperatorType.LESS_THAN_OR_EQUAL)) {
            if (operator2.equals((Object)OperatorType.LESS_THAN)) {
                inferenceType = Optional.of(OperatorType.LESS_THAN);
            } else if (operator2.equals((Object)OperatorType.LESS_THAN_OR_EQUAL)) {
                inferenceType = Optional.of(OperatorType.LESS_THAN_OR_EQUAL);
            }
        }
        return inferenceType;
    }

    private static Set<VariableReferenceExpression> getVariablesReferencedInInferredPredicate(RowExpression firstConjunct, RowExpression secondConjunct) {
        Set<VariableReferenceExpression> firstConjunctReferencedVariables = VariablesExtractor.extractUnique(firstConjunct);
        if (firstConjunctReferencedVariables.isEmpty()) {
            return VariablesExtractor.extractUnique(secondConjunct);
        }
        Set<VariableReferenceExpression> secondConjunctReferencedVariables = VariablesExtractor.extractUnique(secondConjunct);
        if (secondConjunctReferencedVariables.isEmpty()) {
            return firstConjunctReferencedVariables;
        }
        return ImmutableSet.of();
    }

    public static class Builder {
        private final FunctionAndTypeManager functionAndTypeManager;
        private final NullabilityAnalyzer nullabilityAnalyzer;
        private final RowExpressionDeterminismEvaluator determinismEvaluator;
        private final ExpressionEquivalence expressionEquivalence;
        private final Set<RowExpression> inequalityExpressions = new HashSet<RowExpression>();
        private final Optional<Collection<VariableReferenceExpression>> outerVariables;

        public Builder(FunctionAndTypeManager functionAndTypeManager, ExpressionEquivalence expressionEquivalence, Optional<Collection<VariableReferenceExpression>> outerVariables) {
            this.functionAndTypeManager = functionAndTypeManager;
            this.determinismEvaluator = new RowExpressionDeterminismEvaluator(functionAndTypeManager);
            this.expressionEquivalence = expressionEquivalence;
            this.nullabilityAnalyzer = new NullabilityAnalyzer(functionAndTypeManager);
            this.outerVariables = outerVariables;
        }

        public InequalityInference build() {
            return new InequalityInference(this.inequalityExpressions, this.functionAndTypeManager, this.expressionEquivalence, this.outerVariables);
        }

        public Builder addInequalityInferences(RowExpression ... expressions) {
            for (RowExpression expression : expressions) {
                this.extractInequalityInferenceCandidates(expression);
            }
            return this;
        }

        private Builder extractInequalityInferenceCandidates(RowExpression expression) {
            Iterable candidates = Iterables.filter((Iterable)LogicalRowExpressions.extractConjuncts((RowExpression)expression), this.isInequalityInferenceCandidate());
            for (RowExpression conjunct : candidates) {
                this.addInequalityInferenceCandidate(conjunct);
            }
            return this;
        }

        private Builder addInequalityInferenceCandidate(RowExpression expression) {
            Preconditions.checkArgument((boolean)this.isInequalityInferenceCandidate().apply((Object)expression), (Object)("RowExpression: " + expression + " is not an inequality inference candidate"));
            this.inequalityExpressions.add(this.canonicalizeInequality(expression));
            return this;
        }

        RowExpression canonicalizeInequality(RowExpression expression) {
            if (EqualityInference.isOperation(expression, OperatorType.GREATER_THAN, this.functionAndTypeManager) || EqualityInference.isOperation(expression, OperatorType.GREATER_THAN_OR_EQUAL, this.functionAndTypeManager)) {
                CallExpression callExpression = (CallExpression)expression;
                OperatorType operatorType = (OperatorType)this.functionAndTypeManager.getFunctionMetadata(callExpression.getFunctionHandle()).getOperatorType().get();
                operatorType = OperatorType.flip((OperatorType)operatorType);
                FunctionHandle functionHandle = this.functionAndTypeManager.resolveOperator(operatorType, ExpressionEquivalence.swapPair(TypeSignatureProvider.fromTypes((List)((List)callExpression.getArguments().stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList())))));
                expression = new CallExpression(operatorType.getOperator(), functionHandle, (Type)BooleanType.BOOLEAN, ExpressionEquivalence.swapPair(callExpression.getArguments()));
            }
            return expression;
        }

        private Predicate<RowExpression> isInequalityInferenceCandidate() {
            return expression -> (EqualityInference.isOperation(expression, OperatorType.GREATER_THAN_OR_EQUAL, this.functionAndTypeManager) || EqualityInference.isOperation(expression, OperatorType.GREATER_THAN, this.functionAndTypeManager) || EqualityInference.isOperation(expression, OperatorType.LESS_THAN_OR_EQUAL, this.functionAndTypeManager) || EqualityInference.isOperation(expression, OperatorType.LESS_THAN, this.functionAndTypeManager)) && this.determinismEvaluator.isDeterministic((RowExpression)expression) && !this.nullabilityAnalyzer.mayReturnNullOnNonNullInput((RowExpression)expression) && !EqualityInference.getLeft(expression).equals((Object)EqualityInference.getRight(expression));
        }
    }
}

