/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.presto.spi.function.Description;
import javax.validation.constraints.Min;

@DefunctConfig(value={"compiler.interpreter-enabled"})
public class CompilerConfig {
    private int expressionCacheSize = 10000;
    private int leafNodeLimit = 10000;
    private boolean leafNodeLimitEnabled;

    @Min(value=0L)
    public @Min(value=0L) int getExpressionCacheSize() {
        return this.expressionCacheSize;
    }

    @Config(value="compiler.expression-cache-size")
    @Description(value="Reuse compiled expressions across multiple queries")
    public CompilerConfig setExpressionCacheSize(int expressionCacheSize) {
        this.expressionCacheSize = expressionCacheSize;
        return this;
    }

    public int getLeafNodeLimit() {
        return this.leafNodeLimit;
    }

    @Config(value="planner.max-leaf-nodes-in-plan")
    @ConfigDescription(value="Maximum number of leaf nodes in logical plan, throw an exception when exceed if leaf-node-limit-enabled is set true")
    public CompilerConfig setLeafNodeLimit(int num) {
        this.leafNodeLimit = num;
        return this;
    }

    public boolean getLeafNodeLimitEnabled() {
        return this.leafNodeLimitEnabled;
    }

    @Config(value="planner.leaf-node-limit-enabled")
    @ConfigDescription(value="Throw an exception if number of leaf nodes in logical plan exceeds threshold set in max-leaf-nodes-in-plan")
    public CompilerConfig setLeafNodeLimitEnabled(boolean enabled) {
        this.leafNodeLimitEnabled = enabled;
        return this;
    }
}

