/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.cost.HistoryBasedStatisticsCacheManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.statistics.JoinNodeStatistics;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.sql.planner.CanonicalPlan;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.sql.planner.PlanCanonicalInfoProvider;
import com.facebook.presto.sql.planner.PlanNodeCanonicalInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class CachingPlanCanonicalInfoProvider
implements PlanCanonicalInfoProvider {
    private final HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager;
    private final ObjectMapper objectMapper;
    private final Metadata metadata;

    public CachingPlanCanonicalInfoProvider(HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager, ObjectMapper objectMapper, Metadata metadata) {
        this.historyBasedStatisticsCacheManager = Objects.requireNonNull(historyBasedStatisticsCacheManager, "historyBasedStatisticsCacheManager is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Optional<String> hash(Session session, PlanNode planNode, PlanCanonicalizationStrategy strategy) {
        CacheKey key = new CacheKey(planNode, strategy);
        return this.loadValue(session, key).map(PlanNodeCanonicalInfo::getHash);
    }

    @Override
    public Optional<List<PlanStatistics>> getInputTableStatistics(Session session, PlanNode planNode) {
        CacheKey key = new CacheKey(planNode, (PlanCanonicalizationStrategy)PlanCanonicalizationStrategy.historyBasedPlanCanonicalizationStrategyList().get(0));
        return this.loadValue(session, key).map(PlanNodeCanonicalInfo::getInputTableStatistics);
    }

    private Optional<PlanNodeCanonicalInfo> loadValue(Session session, CacheKey key) {
        long startTimeInNano = System.nanoTime();
        long timeoutInMilliseconds = SystemSessionProperties.getHistoryBasedOptimizerTimeoutLimit(session).toMillis();
        Map<CacheKey, PlanNodeCanonicalInfo> cache = this.historyBasedStatisticsCacheManager.getCanonicalInfoCache(session.getQueryId());
        PlanNodeCanonicalInfo result = cache.get(key);
        if (result != null) {
            return Optional.of(result);
        }
        CanonicalPlanGenerator.Context context = new CanonicalPlanGenerator.Context();
        key.getNode().accept((PlanVisitor)new CanonicalPlanGenerator(key.getStrategy(), this.objectMapper, session), (Object)context);
        for (Map.Entry<PlanNode, CanonicalPlan> entry : context.getCanonicalPlans().entrySet()) {
            CanonicalPlan canonicalPlan = entry.getValue();
            PlanNode plan = entry.getKey();
            String hashValue = this.hashCanonicalPlan(canonicalPlan, this.objectMapper);
            ImmutableList.Builder inputTableStatisticsBuilder = ImmutableList.builder();
            for (TableScanNode scanNode : context.getInputTables().get(plan)) {
                if (this.loadValueTimeout(startTimeInNano, timeoutInMilliseconds)) break;
                inputTableStatisticsBuilder.add((Object)this.getPlanStatisticsForTable(session, scanNode));
            }
            cache.put(new CacheKey(plan, key.getStrategy()), new PlanNodeCanonicalInfo(hashValue, (List<PlanStatistics>)inputTableStatisticsBuilder.build()));
        }
        return Optional.ofNullable(cache.get(key));
    }

    private boolean loadValueTimeout(long startTimeInNano, long timeoutInMilliseconds) {
        if (timeoutInMilliseconds == 0L) {
            return false;
        }
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeInNano) > timeoutInMilliseconds;
    }

    private PlanStatistics getPlanStatisticsForTable(Session session, TableScanNode table) {
        InputTableCacheKey key = new InputTableCacheKey(new TableHandle(table.getTable().getConnectorId(), table.getTable().getConnectorHandle(), table.getTable().getTransaction(), Optional.empty()), (List<ColumnHandle>)ImmutableList.copyOf(table.getAssignments().values()), (Constraint<ColumnHandle>)new Constraint(table.getCurrentConstraint()));
        Map<InputTableCacheKey, PlanStatistics> cache = this.historyBasedStatisticsCacheManager.getInputTableStatistics(session.getQueryId());
        PlanStatistics planStatistics = cache.get(key);
        if (planStatistics != null) {
            return planStatistics;
        }
        TableStatistics tableStatistics = this.metadata.getTableStatistics(session, key.getTableHandle(), key.getColumnHandles(), key.getConstraint());
        planStatistics = new PlanStatistics(tableStatistics.getRowCount(), tableStatistics.getTotalSize(), 1.0, JoinNodeStatistics.empty());
        cache.put(key, planStatistics);
        return planStatistics;
    }

    @VisibleForTesting
    public long getCacheSize() {
        return this.historyBasedStatisticsCacheManager.getCanonicalInfoCache().values().stream().mapToLong(cache -> cache.size()).sum();
    }

    @VisibleForTesting
    public HistoryBasedStatisticsCacheManager getHistoryBasedStatisticsCacheManager() {
        return this.historyBasedStatisticsCacheManager;
    }

    private String hashCanonicalPlan(CanonicalPlan plan, ObjectMapper objectMapper) {
        return Hashing.sha256().hashString((CharSequence)plan.toString(objectMapper), StandardCharsets.UTF_8).toString();
    }

    public static class InputTableCacheKey {
        private final TableHandle tableHandle;
        private final List<ColumnHandle> columnHandles;
        private final Constraint<ColumnHandle> constraint;

        public InputTableCacheKey(TableHandle tableHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
            this.columnHandles = ImmutableList.copyOf(columnHandles);
            this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        }

        public TableHandle getTableHandle() {
            return this.tableHandle;
        }

        public List<ColumnHandle> getColumnHandles() {
            return this.columnHandles;
        }

        public Constraint<ColumnHandle> getConstraint() {
            return this.constraint;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InputTableCacheKey)) {
                return false;
            }
            InputTableCacheKey other = (InputTableCacheKey)obj;
            return this.tableHandle.equals((Object)other.tableHandle) && this.columnHandles.equals(other.columnHandles) && this.constraint.equals(other.constraint);
        }

        public int hashCode() {
            return Objects.hash(this.tableHandle, this.columnHandles, this.constraint);
        }
    }

    public static class CacheKey {
        private final PlanNode node;
        private final PlanCanonicalizationStrategy strategy;

        public CacheKey(PlanNode node, PlanCanonicalizationStrategy strategy) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.strategy = Objects.requireNonNull(strategy, "strategy is null");
        }

        public PlanNode getNode() {
            return this.node;
        }

        public PlanCanonicalizationStrategy getStrategy() {
            return this.strategy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.node == cacheKey.node && this.strategy.equals((Object)cacheKey.strategy);
        }

        public int hashCode() {
            return Objects.hash(System.identityHashCode(this.node), this.strategy);
        }
    }
}

