/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SwitchCodeGenerator
implements SpecialFormBytecodeGenerator {
    private static final String CASE_LABEL_PREFIX = "_case_";
    private static final String RESULT_LABEL_PREFIX = "_result_";

    private static boolean isEqualsExpression(RowExpression expression) {
        return expression instanceof CallExpression && ((CallExpression)expression).getDisplayName().equals(OperatorType.EQUAL.getFunctionName().getObjectName()) && ((CallExpression)expression).getArguments().size() == 2;
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Optional<Object> getTempVariableNode;
        BytecodeNode elseValue;
        List<RowExpression> whenClauses;
        Scope scope = generatorContext.getScope();
        RowExpression last = arguments.get(arguments.size() - 1);
        if (last instanceof SpecialFormExpression && ((SpecialFormExpression)last).getForm().equals((Object)SpecialFormExpression.Form.WHEN)) {
            whenClauses = arguments.subList(1, arguments.size());
            elseValue = new BytecodeBlock().append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantTrue())).pushJavaDefault(returnType.getJavaType());
        } else {
            whenClauses = arguments.subList(1, arguments.size() - 1);
            elseValue = generatorContext.generate(last, Optional.empty());
        }
        RowExpression value = arguments.get(0);
        Class valueType = value.getType().getJavaType();
        boolean searchedCase = value instanceof ConstantExpression && ((ConstantExpression)value).getType() == BooleanType.BOOLEAN && ((ConstantExpression)value).getValue() == Boolean.TRUE;
        LabelNode elseLabel = new LabelNode("else");
        LabelNode endLabel = new LabelNode("end");
        BytecodeBlock block = new BytecodeBlock();
        if (!searchedCase) {
            BytecodeNode valueBytecode = generatorContext.generate(value, Optional.empty());
            Variable tempVariable = scope.createTempVariable(valueType);
            block.append(valueBytecode).append(BytecodeUtils.ifWasNullClearPopAndGoto(scope, elseLabel, Void.TYPE, valueType)).putVariable(tempVariable);
            getTempVariableNode = Optional.of(VariableInstruction.loadVariable((Variable)tempVariable));
        } else {
            getTempVariableNode = Optional.empty();
        }
        Variable wasNull = generatorContext.wasNull();
        block.putVariable(wasNull, false);
        HashMap<RowExpression, LabelNode> resultLabels = new HashMap<RowExpression, LabelNode>();
        for (RowExpression rowExpression : whenClauses) {
            BytecodeNode operandBytecode;
            Preconditions.checkArgument((rowExpression instanceof SpecialFormExpression && ((SpecialFormExpression)rowExpression).getForm().equals((Object)SpecialFormExpression.Form.WHEN) ? 1 : 0) != 0);
            RowExpression operand = (RowExpression)((SpecialFormExpression)rowExpression).getArguments().get(0);
            if (searchedCase) {
                operandBytecode = generatorContext.generate(operand, Optional.empty());
            } else {
                FunctionHandle equalsFunction = generatorContext.getFunctionManager().resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{value.getType(), operand.getType()}));
                operandBytecode = generatorContext.generateCall(OperatorType.EQUAL.name(), generatorContext.getFunctionManager().getJavaScalarFunctionImplementation(equalsFunction), (List<BytecodeNode>)ImmutableList.of((Object)generatorContext.generate(operand, Optional.empty()), (Object)getTempVariableNode.get()));
            }
            block.append(operandBytecode);
            IfStatement ifWasNull = new IfStatement().condition((BytecodeNode)wasNull);
            ifWasNull.ifTrue().putVariable(wasNull, false).pop(Boolean.class);
            RowExpression result = (RowExpression)((SpecialFormExpression)rowExpression).getArguments().get(1);
            LabelNode target = (LabelNode)resultLabels.get(result);
            if (target == null) {
                target = new LabelNode(RESULT_LABEL_PREFIX + resultLabels.size());
                resultLabels.put(result, target);
            }
            ifWasNull.ifFalse().ifTrueGoto(target);
            block.append((BytecodeNode)ifWasNull);
        }
        block.visitLabel(elseLabel).append(elseValue).gotoLabel(endLabel);
        for (Map.Entry entry : resultLabels.entrySet()) {
            block.visitLabel((LabelNode)entry.getValue()).append(generatorContext.generate((RowExpression)entry.getKey(), Optional.empty())).gotoLabel(endLabel);
        }
        block.visitLabel(endLabel);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generatorContext, returnType, output)));
        return block;
    }
}

